<?php
require_once __DIR__.'/db.php'; require_once __DIR__.'/helpers.php'; require_once __DIR__.'/middleware.php';
try{
  $a=$_GET['a']??'list';
  switch($a){
    case 'list': require_auth('partners.view'); list_dt(); break;
    case 'get': require_auth('partners.view'); get_one(); break;
    case 'save': require_auth(['partners.create','partners.edit']); save_one(); break;
    case 'delete': require_auth('partners.delete'); del_one(); break;
    case 'search': require_auth('partners.view'); quick(); break;
    case 'options': require_auth('partners.view'); options(); break;
    default: json_err('Noto‘g‘ri action');
  }
}catch(Throwable $e){ json_err($e->getMessage(),500); }

function list_dt(){
  $pdo=pdo();
  $s=$_GET['search']['value']??'';
  $where=["deleted_at IS NULL"]; $p=[];
  if($s!==''){ $where[]="(name LIKE :q OR address LIKE :q OR phone LIKE :q OR territory LIKE :q OR category LIKE :q)"; $p[':q']='%'.$s.'%'; }
  $W='WHERE '.implode(' AND ',$where);
  $total=(int)$pdo->query("SELECT COUNT(*) FROM partners WHERE deleted_at IS NULL")->fetchColumn();
  $st=$pdo->prepare("SELECT COUNT(*) FROM partners $W"); foreach($p as $k=>$v){ $st->bindValue($k,$v); } $st->execute(); $filtered=(int)$st->fetchColumn();
  $start=(int)($_GET['start']??0); $len=(int)($_GET['length']??50); if($len<1||$len>1000)$len=50;
  $cols=['name','territory','category','address','phone','created_at']; $idx=(int)($_GET['order'][0]['column']??0); $dir=(strtolower($_GET['order'][0]['dir']??'asc')==='desc')?'DESC':'ASC'; $idx=max(0,min($idx,len($cols:=['name','territory','category','address','phone','created_at'])-1));
  $order=$cols[$idx].' '.$dir;
  $q=$pdo->prepare("SELECT id,name,territory,category,address,phone,created_at FROM partners $W ORDER BY $order LIMIT :s,:l");
  foreach($p as $k=>$v){ $q->bindValue($k,$v); } $q->bindValue(':s',$start,PDO::PARAM_INT); $q->bindValue(':l',$len,PDO::PARAM_INT); $q->execute();
  echo json_encode(['draw'=>(int)($_GET['draw']??0),'recordsTotal'=>$total,'recordsFiltered'=>$filtered,'data'=>$q->fetchAll()], JSON_UNESCAPED_UNICODE); exit;
}
function get_one(){
  $id=(int)($_GET['id']??0); if($id<=0) json_err('ID');
  $st=pdo()->prepare("SELECT * FROM partners WHERE id=:id"); $st->execute([':id'=>$id]); $p=$st->fetch(); if(!$p) json_err('Topilmadi',404);
  json_ok($p);
}
function save_one(){
  $b=body_json(); $id=(int)arr_get($b,'id',0);
  $cols=['name','territory','category','address','phone','phone2','phone3','type','sales_channel','client_class','lat','lng','note'];
  $vals=[]; foreach($cols as $k){ $vals[$k]=arr_get($b,$k,null); }
  $pdo=pdo();
  if($id>0){
    $set=[]; $bind=[]; foreach($vals as $k=>$v){ $set[]="`$k`=:$k"; $bind[":$k"]=$v; } $bind[':id']=$id;
    $pdo->prepare("UPDATE partners SET ".implode(',', $set)." WHERE id=:id")->execute($bind);
  }else{
    $names=array_keys($vals); $ph=array_map(fn($x)=>":$x",$names); $bind=[]; foreach($vals as $k=>$v){ $bind[":$k"]=$v; }
    $pdo->prepare("INSERT INTO partners(`".implode('`,`',$names)."`) VALUES(".implode(',',$ph).")")->execute($bind);
    $id=(int)$pdo->lastInsertId();
  }
  json_ok(['id'=>$id]);
}
function del_one(){
  $id=(int)($_GET['id']??0); if($id<=0) json_err('ID');
  pdo()->prepare("UPDATE partners SET deleted_at=NOW() WHERE id=:id")->execute([':id'=>$id]); json_ok(['deleted'=>true]);
}
function quick(){
  $q=trim($_GET['q']??''); if($q==='') json_ok([]);
  $st=pdo()->prepare("SELECT id,name,territory,category,address,phone,phone2,phone3 FROM partners WHERE deleted_at IS NULL AND (name LIKE :q OR address LIKE :q OR phone LIKE :q) ORDER BY name LIMIT 20");
  $st->execute([':q'=>'%'.$q.'%']); json_ok($st->fetchAll());
}
function options(){
  $ter=pdo()->query("SELECT name FROM territories ORDER BY name")->fetchAll(PDO::FETCH_COLUMN);
  $cat=pdo()->query("SELECT id,name,parent_id FROM categories ORDER BY name")->fetchAll();
  json_ok(['territories'=>$ter,'categories'=>$cat]);
}
