<?php
require_once __DIR__.'/db.php'; require_once __DIR__.'/helpers.php'; require_once __DIR__.'/middleware.php';
try{
  $a=$_GET['a']??'list';
  switch($a){
    case 'list': require_auth('orders.view'); list_dt(); break;
    case 'get': require_auth('orders.view'); get_one(); break;
    case 'save': require_auth(['orders.create','orders.edit']); save_one(); break;
    case 'delete': require_auth('orders.delete'); del_one(); break;
    case 'set_status': require_auth('orders.edit'); set_status(); break;
    case 'nextno': require_auth('orders.create'); nextno(); break;
    case 'partner_search': require_auth('orders.view'); partner_search(); break;
    case 'options': require_auth('orders.view'); options(); break;
    default: json_err('Noto‘g‘ri action');
  }
}catch(Throwable $e){ json_err($e->getMessage(),500); }

function list_dt(){
  $pdo=pdo();
  $s=$_GET['search']['value']??'';
  $f_ter=trim($_GET['f_territory']??''); $f_cat=trim($_GET['f_category']??''); $f_st=trim($_GET['f_status']??''); $df=trim($_GET['f_date_from']??''); $dt=trim($_GET['f_date_to']??'');
  $where=["o.deleted_at IS NULL"]; $p=[];
  if($s!==''){ $where[]="(o.partner_name LIKE :q OR o.delivery_address LIKE :q OR o.order_no LIKE :q)"; $p[':q']='%'.$s.'%'; }
  if($f_ter!==''){ $where[]="o.territory=:t"; $p[':t']=$f_ter; }
  if($f_cat!==''){ $where[]="o.category=:c"; $p[':c']=$f_cat; }
  if($f_st!==''){ $where[]="o.status=:s"; $p[':s']=$f_st; }
  if($df!==''){ $where[]="o.order_date>=:df"; $p[':df']=$df.' 00:00:00'; }
  if($dt!==''){ $where[]="o.order_date<=:dt"; $p[':dt']=$dt.' 23:59:59'; }
  $W='WHERE '.implode(' AND ',$where);
  $total=(int)$pdo->query("SELECT COUNT(*) FROM orders WHERE deleted_at IS NULL")->fetchColumn();
  $st=$pdo->prepare("SELECT COUNT(*) FROM orders o $W"); foreach($p as $k=>$v){ $st->bindValue($k,$v); } $st->execute(); $filtered=(int)$st->fetchColumn();
  $start=(int)($_GET['start']??0); $len=(int)($_GET['length']??50); if($len<1||$len>1000)$len=50;
  $cols=['order_no','order_date','partner_name','territory','category','total_amount','status','created_by']; $idx=(int)($_GET['order'][0]['column']??0); $dir=(strtolower($_GET['order'][0]['dir']??'desc')==='asc')?'ASC':'DESC'; $idx=max(0,min($idx,count($cols)-1));
  $order=$cols[$idx].' '.$dir;
  $q=$pdo->prepare("SELECT o.id,o.order_no,o.order_date,o.partner_name,o.territory,o.category,o.total_amount,o.status,
                           COALESCE(u.full_name,'—') addedBy
                    FROM orders o LEFT JOIN users u ON u.id=o.created_by $W ORDER BY $order LIMIT :s,:l");
  foreach($p as $k=>$v){ $q->bindValue($k,$v); } $q->bindValue(':s',$start,PDO::PARAM_INT); $q->bindValue(':l',$len,PDO::PARAM_INT); $q->execute();
  echo json_encode(['draw'=>(int)($_GET['draw']??0),'recordsTotal'=>$total,'recordsFiltered'=>$filtered,'data'=>$q->fetchAll()], JSON_UNESCAPED_UNICODE); exit;
}
function get_one(){
  $id=(int)($_GET['id']??0); if($id<=0) json_err('ID');
  $pdo=pdo();
  $o=$pdo->prepare("SELECT * FROM orders WHERE id=:id"); $o->execute([':id'=>$id]); $ord=$o->fetch(); if(!$ord) json_err('Topilmadi',404);
  $it=$pdo->prepare("SELECT product_name,unit,price,qty,(price*qty) line_total FROM order_items WHERE order_id=:id ORDER BY id"); $it->execute([':id'=>$id]);
  $log=$pdo->prepare("SELECT status,changed_at,changed_by,note FROM order_status_log WHERE order_id=:id ORDER BY id DESC"); $log->execute([':id'=>$id]);
  json_ok(['order'=>$ord,'items'=>$it->fetchAll(),'log'=>$log->fetchAll()]);
}
function save_one(){
  $u=require_auth(['orders.create','orders.edit']);
  $b=body_json(); $id=(int)arr_get($b,'id',0);
  $partner_id=(int)arr_get($b,'partner_id',0);
  $order_no=(int)arr_get($b,'order_no',0);
  $order_date=str_or_null(arr_get($b,'order_date',now()));
  $status='new';
  $delivery_date=str_or_null(arr_get($b,'delivery_date',null));
  $delivery_address=str_or_null(arr_get($b,'delivery_address',null));
  $note=str_or_null(arr_get($b,'note',null));
  $items=arr_get($b,'items',[]); if(!is_array($items)) $items=[];
  if($order_no<=0){ $order_no = (int)pdo()->query("SELECT COALESCE(MAX(order_no),0)+1 FROM orders")->fetchColumn(); }
  // partner
  $partner=null;
  if($partner_id>0){ $ps=pdo()->prepare("SELECT id,name,territory,category,address FROM partners WHERE id=:id"); $ps->execute([':id'=>$partner_id]); $partner=$ps->fetch(); }
  if(!$partner) json_err('Mijoz tanlanmagan');
  $territory=$partner['territory']; $category=$partner['category']; $partner_name=$partner['name']; if(!$delivery_address) $delivery_address=$partner['address'];
  // compute total
  $total=0; $clean=[];
  foreach($items as $it){
    $name=str_or_null(arr_get($it,'product_name','')); $unit=str_or_null(arr_get($it,'unit','ta')); $price=(float)arr_get($it,'price',0); $qty=(int)arr_get($it,'qty',0);
    if(!$name || $qty<=0) continue;
    $line=$price*$qty; $total+=$line; $clean[]=['product_name'=>$name,'unit'=>$unit,'price'=>$price,'qty'=>$qty,'line_total'=>$line];
  }
  if(!count($clean)) json_err('Pozitsiyalar bo‘sh');
  $pdo=pdo(); $pdo->beginTransaction();
  try{
    if($id>0){
      $pdo->prepare("UPDATE orders SET order_no=:no,order_date=:dt,partner_id=:pid,partner_name=:pn,territory=:ter,category=:cat,status=:st,delivery_date=:dd,delivery_address=:da,total_amount=:tot,note=:note WHERE id=:id")
          ->execute([':no'=>$order_no,':dt'=>$order_date,':pid'=>$partner_id,':pn'=>$partner_name,':ter'=>$territory,':cat'=>$category,':st'=>$status,':dd'=>$delivery_date,':da'=>$delivery_address,':tot'=>$total,':note'=>$note,':id'=>$id]);
      $pdo->prepare("DELETE FROM order_items WHERE order_id=:id")->execute([':id'=>$id]);
    }else{
      $pdo->prepare("INSERT INTO orders(order_no,order_date,partner_id,partner_name,territory,category,status,delivery_date,delivery_address,total_amount,note,created_by,created_at) VALUES(:no,:dt,:pid,:pn,:ter,:cat,:st,:dd,:da,:tot,:note,:cb,NOW())")
          ->execute([':no'=>$order_no,':dt'=>$order_date,':pid'=>$partner_id,':pn'=>$partner_name,':ter'=>$territory,':cat'=>$category,':st'=>$status,':dd'=>$delivery_date,':da'=>$delivery_address,':tot'=>$total,':note'=>$note,':cb'=>$u['id']??null]);
      $id=(int)$pdo->lastInsertId();
      $pdo->prepare("INSERT INTO order_status_log(order_id,status,changed_by) VALUES(:id,'new',:by)")->execute([':id'=>$id,':by'=>$u['full_name']??'']);
    }
    $ins=$pdo->prepare("INSERT INTO order_items(order_id,product_name,unit,price,qty,line_total) VALUES(:oid,:n,:u,:p,:q,:l)");
    foreach($clean as $it){ $ins->execute([':oid'=>$id,':n'=>$it['product_name'],':u'=>$it['unit'],':p'=>$it['price'],':q'=>$it['qty'],':l'=>$it['line_total']]); }
    $pdo->commit();
    json_ok(['id'=>$id]);
  }catch(Throwable $e){ $pdo->rollBack(); json_err($e->getMessage(),500); }
}
function del_one(){ $id=(int)($_GET['id']??0); if($id<=0) json_err('ID'); pdo()->prepare("UPDATE orders SET deleted_at=NOW() WHERE id=:id")->execute([':id'=>$id]); json_ok(['deleted'=>true]); }
function set_status(){
  $u=require_auth('orders.edit'); $b=body_json(); $id=(int)arr_get($b,'id',0); $st=str_or_null(arr_get($b,'status','new'));
  $pdo=pdo(); $pdo->beginTransaction(); try{
    $pdo->prepare("UPDATE orders SET status=:s WHERE id=:id")->execute([':s'=>$st,':id'=>$id]);
    $pdo->prepare("INSERT INTO order_status_log(order_id,status,changed_by) VALUES(:id,:s,:by)")->execute([':id'=>$id,':s'=>$st,':by'=>$u['full_name']??'']);
    $pdo->commit(); json_ok(['ok'=>true]);
  }catch(Throwable $e){ $pdo->rollBack(); json_err($e->getMessage(),500); }
}
function nextno(){ $n=(int)pdo()->query("SELECT COALESCE(MAX(order_no),0)+1 FROM orders")->fetchColumn(); json_ok(['order_no'=>$n]); }
function partner_search(){ $_GET['q']= $_GET['q'] ?? ''; require_once __DIR__.'/mijozlar.php'; quick(); }
function options(){
  $pdo=pdo();
  $territories=$pdo->query("SELECT name FROM territories ORDER BY name")->fetchAll(PDO::FETCH_COLUMN);
  $products=$pdo->query("SELECT id,name,unit,price FROM products WHERE is_active=1 ORDER BY name")->fetchAll();
  $cats=$pdo->query("SELECT id,name,parent_id FROM categories ORDER BY name")->fetchAll();
  json_ok(['territories'=>$territories,'products'=>$products,'categories'=>$cats]);
}
