<?php
require_once __DIR__.'/db.php'; require_once __DIR__.'/helpers.php'; require_once __DIR__.'/middleware.php';
try{
  $a=$_GET['a']??'list';
  switch($a){
    case 'list': require_auth('roles.manage'); list_roles(); break;
    case 'get': require_auth('roles.manage'); get_one(); break;
    case 'save': require_auth('roles.manage'); save_one(); break;
    case 'delete': require_auth('roles.manage'); del(); break;
    case 'permissions': require_auth('roles.manage'); perms(); break;
    default: json_err('Noto‘g‘ri action');
  }
}catch(Throwable $e){ json_err($e->getMessage(),500); }
function list_roles(){ $rows=pdo()->query("SELECT r.id,r.name,r.slug,(SELECT GROUP_CONCAT(p.slug SEPARATOR ',') FROM role_permissions rp JOIN permissions p ON p.id=rp.permission_id WHERE rp.role_id=r.id) perms FROM roles r ORDER BY r.name")->fetchAll(); json_ok($rows); }
function perms(){ $rows=pdo()->query("SELECT id,slug,name FROM permissions ORDER BY slug")->fetchAll(); json_ok($rows); }
function get_one(){ $id=(int)($_GET['id']??0); if($id<=0) json_err('ID'); $pdo=pdo(); $r=$pdo->prepare("SELECT id,name,slug FROM roles WHERE id=:id"); $r->execute([':id'=>$id]); $role=$r->fetch(); if(!$role) json_err('Topilmadi',404);
  $p=$pdo->prepare("SELECT p.id,p.slug,p.name FROM role_permissions rp JOIN permissions p ON p.id=rp.permission_id WHERE rp.role_id=:id"); $p->execute([':id'=>$id]); json_ok(['role'=>$role,'perms'=>$p->fetchAll()]);
}
function save_one(){ $b=body_json(); $id=(int)arr_get($b,'id',0); $name=str_or_null(arr_get($b,'name','')); $slug=str_or_null(arr_get($b,'slug','')); $perms=arr_get($b,'permissions',[]); if(!$name||!$slug) json_err('Majburiy maydonlar');
  $pdo=pdo(); $pdo->beginTransaction(); try{
    if($id>0){ $pdo->prepare("UPDATE roles SET name=:n,slug=:s WHERE id=:id")->execute([':n'=>$name,':s'=>$slug,':id'=>$id]); $pdo->prepare("DELETE FROM role_permissions WHERE role_id=:id")->execute([':id'=>$id]); }
    else { $pdo->prepare("INSERT INTO roles(name,slug) VALUES(:n,:s)")->execute([':n'=>$name,':s'=>$slug]); $id=(int)$pdo->lastInsertId(); }
    if(is_array($perms)&&count($perms)){ $map=$pdo->prepare("SELECT id FROM permissions WHERE slug=:s"); $ins=$pdo->prepare("INSERT INTO role_permissions(role_id,permission_id) VALUES(:r,:p)"); foreach($perms as $sl){ $map->execute([':s'=>$sl]); if($pid=$map->fetchColumn()){ $ins->execute([':r'=>$id,':p'=>$pid]); } } }
    $pdo->commit(); json_ok(['id'=>$id]);
  }catch(Throwable $e){ $pdo->rollBack(); json_err($e->getMessage(),500); }
}
function del(){ $id=(int)($_GET['id']??0); if($id<=0) json_err('ID'); pdo()->prepare("DELETE FROM roles WHERE id=:id")->execute([':id'=>$id]); json_ok(['deleted'=>true]); }
