<?php
require_once __DIR__.'/db.php'; require_once __DIR__.'/helpers.php'; require_once __DIR__.'/middleware.php';
try{
  $a=$_GET['a']??'list';
  switch($a){
    case 'list': require_auth('users.manage'); list_dt(); break;
    case 'get': require_auth('users.manage'); get_one(); break;
    case 'save': require_auth('users.manage'); save_one(); break;
    case 'toggle': require_auth('users.manage'); toggle(); break;
    default: json_err('Noto‘g‘ri action');
  }
}catch(Throwable $e){ json_err($e->getMessage(),500); }
function list_dt(){
  $pdo=pdo(); $total=(int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
  $s=$_GET['search']['value']??''; $w=''; $p=[]; if($s!==''){ $w="WHERE (username LIKE :q OR full_name LIKE :q OR phone LIKE :q)"; $p[':q']='%'.$s+'%'; }
  $st=$pdo->prepare("SELECT COUNT(*) FROM users $w"); $st->execute($p); $f=(int)$st->fetchColumn();
  $start=(int)($_GET['start']??0); $len=(int)($_GET['length']??50); if($len<1||$len>1000)$len=50;
  $cols=['username','full_name','role_primary','is_active','created_at']; $idx=(int)($_GET['order'][0]['column']??0); $dir=(strtolower($_GET['order'][0]['dir']??'asc')==='desc')?'DESC':'ASC'; $idx=max(0,min($idx,count($cols)-1)); $order=$cols[$idx].' '.$dir;
  $q=$pdo->prepare("SELECT u.id,username,full_name,phone,role_primary,is_active,created_at,(SELECT GROUP_CONCAT(r.name SEPARATOR ', ') FROM user_roles ur JOIN roles r ON r.id=ur.role_id WHERE ur.user_id=u.id) roles FROM users u $w ORDER BY $order LIMIT :s,:l");
  foreach($p as $k=>$v){ $q->bindValue($k,$v); } $q->bindValue(':s',$start,PDO::PARAM_INT); $q->bindValue(':l',$len,PDO::PARAM_INT); $q->execute();
  echo json_encode(['draw'=>(int)($_GET['draw']??0),'recordsTotal'=>$total,'recordsFiltered'=>$f,'data'=>$q->fetchAll()], JSON_UNESCAPED_UNICODE); exit;
}
function get_one(){
  $id=(int)($_GET['id']??0); if($id<=0) json_err('ID'); $pdo=pdo();
  $u=$pdo->prepare("SELECT id,username,full_name,phone,role_primary,is_active FROM users WHERE id=:id"); $u->execute([':id'=>$id]); $user=$u->fetch(); if(!$user) json_err('Topilmadi',404);
  $r=$pdo->prepare("SELECT r.id,r.name FROM user_roles ur JOIN roles r ON r.id=ur.role_id WHERE ur.user_id=:id"); $r->execute([':id'=>$id]);
  json_ok(['user'=>$user,'roles'=>$r->fetchAll()]);
}
function save_one(){
  $b=body_json(); $id=(int)arr_get($b,'id',0); $u=str_or_null(arr_get($b,'username','')); $f=str_or_null(arr_get($b,'full_name','')); $ph=str_or_null(arr_get($b,'phone','')); $rp=str_or_null(arr_get($b,'role_primary','')); $pw=str_or_null(arr_get($b,'password','')); $roles=arr_get($b,'roles',[]); if(!$u) json_err('Login majburiy');
  $pdo=pdo(); $pdo->beginTransaction(); try{
    if($id>0){
      $sql="UPDATE users SET username=:u,full_name=:f,phone=:ph,role_primary=:rp"; $bind=[':u'=>$u,':f'=>$f,':ph'=>$ph,':rp'=>$rp,':id'=>$id];
      if($pw){ $sql.=", password_hash=:pw"; $bind[':pw']=password_hash($pw,PASSWORD_BCRYPT); }
      $sql.=" WHERE id=:id"; $pdo->prepare($sql)->execute($bind);
      $pdo->prepare("DELETE FROM user_roles WHERE user_id=:id")->execute([':id'=>$id]);
    }else{
      $hash = password_hash($pw ?: 'password', PASSWORD_BCRYPT);
      $pdo->prepare("INSERT INTO users(username,full_name,phone,role_primary,password_hash,created_at) VALUES(:u,:f,:ph,:rp,:pw,NOW())")->execute([':u'=>$u,':f'=>$f,':ph'=>$ph,':rp'=>$rp,':pw'=>$hash]);
      $id=(int)$pdo->lastInsertId();
    }
    if(is_array($roles) && count($roles)){
      $ins=$pdo->prepare("INSERT INTO user_roles(user_id,role_id) VALUES(:u,:r)"); foreach($roles as $rid){ $ins->execute([':u'=>$id,':r'=>(int)$rid]); }
    }
    $pdo->commit(); json_ok(['id'=>$id]);
  }catch(Throwable $e){ $pdo->rollBack(); json_err($e->getMessage(),500); }
}
function toggle(){ $id=(int)($_GET['id']??0); if($id<=0) json_err('ID'); pdo()->prepare("UPDATE users SET is_active=1-is_active WHERE id=:id")->execute([':id'=>$id]); json_ok(['ok'=>true]); }
