<?php require_once __DIR__.'/../config.php'; $db=db();
if(!isset($_SESSION['uid'])) json_out(['ok'=>false,'error'=>'Auth required'],401);
$r=$_GET['r']??''; $a=$_GET['a']??''; $method=$_SERVER['REQUEST_METHOD'];

function b64save($cid,$kind,$mime,$name,$base64){
  if(!$base64) return null; if(!is_dir(UPLOAD_DIR)) @mkdir(UPLOAD_DIR,0775,true);
  $bin = base64_decode(preg_replace('#^data:.*?;base64,#','',$base64)); if(!$bin) return null;
  $safe = preg_replace('/[^a-zA-Z0-9_\.-]+/','_', $name ?: ($kind.'_'.uniqid().'.bin'));
  $fname = $cid.'_'.$kind.'_'.time().'_'.mt_rand(100,999).'_'.$safe; $path = UPLOAD_DIR.'/'.$fname; file_put_contents($path,$bin);
  return ['rel'=>'uploads/'.$fname, 'size'=>filesize($path), 'mime'=>$mime];
}

try{
  // ===== Stats (dashboard) =====
  if($r==='stats' && $a==='kpi'){
    $today = date('Y-m-d');
    $submitted = $db->query("SELECT COUNT(*) c FROM contracts WHERE DATE(created_at)='$today'")->fetch_assoc()['c'] ?? 0;
    $approved  = $db->query("SELECT COUNT(*) c FROM contracts WHERE status='approved'")->fetch_assoc()['c'] ?? 0;
    $rejected  = $db->query("SELECT COUNT(*) c FROM contracts WHERE status='rejected'")->fetch_assoc()['c'] ?? 0;
    $equip     = $db->query("SELECT COUNT(*) c FROM equipment")->fetch_assoc()['c'] ?? 0;
    json_out(['ok'=>true,'kpi'=>['submitted'=>(int)$submitted,'approved'=>(int)$approved,'rejected'=>(int)$rejected,'equip'=>(int)$equip]]);
  }

  // ===== Regions =====
  if($r==='regions'){
    if($a==='list'){ $rs=$db->query("SELECT * FROM regions ORDER BY id DESC"); json_out(['ok'=>true,'items'=>$rs->fetch_all(MYSQLI_ASSOC)]); }
    if($a==='save' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $name=trim($d['name']??''); $lat=$d['latitude']??null; $lng=$d['longitude']??null; if($name==='') json_out(['ok'=>false,'error'=>'Nomi kerak'],400); $st=$db->prepare("INSERT INTO regions(name,latitude,longitude) VALUES (?,?,?)"); $st->bind_param('sdd',$name,$lat,$lng); $st->execute(); audit('create','region',$st->insert_id,['name'=>$name]); json_out(['ok'=>true,'id'=>$st->insert_id]); }
    if($a==='update' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); $name=trim($d['name']??''); $lat=$d['latitude']??null; $lng=$d['longitude']??null; if(!$id||$name==='') json_out(['ok'=>false,'error'=>'ID yoki nom yo‘q'],400); $st=$db->prepare("UPDATE regions SET name=?, latitude=?, longitude=? WHERE id=?"); $st->bind_param('sddi',$name,$lat,$lng,$id); $st->execute(); audit('update','region',$id,['name'=>$name]); json_out(['ok'=>true]); }
    if($a==='delete' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); if(!$id) json_out(['ok'=>false,'error'=>'ID yo‘q'],400); $db->query("DELETE FROM regions WHERE id=$id"); audit('delete','region',$id,[]); json_out(['ok'=>true]); }
  }

  // ===== Equipment =====
  if($r==='equipment'){
    if($a==='list'){ $rs=$db->query("SELECT * FROM equipment ORDER BY id DESC"); json_out(['ok'=>true,'items'=>$rs->fetch_all(MYSQLI_ASSOC)]); }
    if($a==='save' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $name=trim($d['name']??''); if($name==='') json_out(['ok'=>false,'error'=>'Nomi kerak'],400); $st=$db->prepare("INSERT INTO equipment(name) VALUES (?)"); $st->bind_param('s',$name); $st->execute(); audit('create','equipment',$st->insert_id,['name'=>$name]); json_out(['ok'=>true,'id'=>$st->insert_id]); }
    if($a==='update' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); $name=trim($d['name']??''); if(!$id||$name==='') json_out(['ok'=>false,'error'=>'ID yoki nom yo‘q'],400); $st=$db->prepare("UPDATE equipment SET name=? WHERE id=?"); $st->bind_param('si',$name,$id); $st->execute(); audit('update','equipment',$id,['name'=>$name]); json_out(['ok'=>true]); }
    if($a==='delete' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); if(!$id) json_out(['ok'=>false,'error'=>'ID yo‘q'],400); $db->query("DELETE FROM equipment WHERE id=$id"); audit('delete','equipment',$id,[]); json_out(['ok'=>true]); }
  }

  // ===== Fields =====
  if($r==='fields'){
    if($a==='list'){ $rs=$db->query("SELECT * FROM form_fields ORDER BY sort_order,id"); json_out(['ok'=>true,'items'=>$rs->fetch_all(MYSQLI_ASSOC)]); }
    if($a==='save' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $label=trim($d['label']??''); $type=$d['type']??'text'; $req=(int)($d['required']??0); $so=(int)($d['sort_order']??0); $opt=$d['options']??[]; if($label==='') json_out(['ok'=>false,'error'=>'Label kerak'],400); $optj=json_encode($opt,JSON_UNESCAPED_UNICODE); $st=$db->prepare("INSERT INTO form_fields(label,type,options_json,required,is_active,sort_order) VALUES (?,?,?,?,1,?)"); $st->bind_param('sssii',$label,$type,$optj,$req,$so); $st->execute(); audit('create','field',$st->insert_id,['label'=>$label]); json_out(['ok'=>true,'id'=>$st->insert_id]); }
    if($a==='update' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); $label=trim($d['label']??''); $type=$d['type']??'text'; $req=(int)($d['required']??0); $so=(int)($d['sort_order']??0); $opt=$d['options']??[]; if(!$id||$label==='') json_out(['ok'=>false,'error'=>'ID yoki label yo‘q'],400); $optj=json_encode($opt,JSON_UNESCAPED_UNICODE); $st=$db->prepare("UPDATE form_fields SET label=?, type=?, options_json=?, required=?, is_active=1, sort_order=? WHERE id=?"); $st->bind_param('sssiii',$label,$type,$optj,$req,$so,$id); $st->execute(); audit('update','field',$id,['label'=>$label]); json_out(['ok'=>true]); }
    if($a==='delete' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); if(!$id) json_out(['ok'=>false,'error'=>'ID yo‘q'],400); $db->query("DELETE FROM form_fields WHERE id=$id"); audit('delete','field',$id,[]); json_out(['ok'=>true]); }
  }

  // ===== Users =====
  if($r==='users'){
    if(!is_admin()) json_out(['ok'=>false,'error'=>'Admin only'],403);
    if($a==='list'){ $page=max(1,(int)($_GET['page']??1)); $size=max(1,min(200,(int)($_GET['size']??20))); $q=$db->real_escape_string($_GET['q']??''); $w="1=1"; if($q!=='') $w.=" AND (username LIKE '%$q%' OR full_name LIKE '%$q%')"; $total=$db->query("SELECT COUNT(*) c FROM users WHERE $w")->fetch_assoc()['c']??0; $off=($page-1)*$size; $rs=$db->query("SELECT id,username,full_name,phone,is_admin FROM users WHERE $w ORDER BY id DESC LIMIT $off,$size"); json_out(['ok'=>true,'items'=>$rs->fetch_all(MYSQLI_ASSOC),'total'=>(int)$total]); }
    if($a==='get'){ $id=(int)($_GET['id']??0); $row=$db->query("SELECT id,username,full_name,phone,is_admin,permissions_json FROM users WHERE id=$id")->fetch_assoc(); if(!$row) json_out(['ok'=>false,'error'=>'Topilmadi'],404); json_out(['ok'=>true,'id'=>$row['id'],'username'=>$row['username'],'full_name'=>$row['full_name'],'phone'=>$row['phone'],'is_admin'=>(int)$row['is_admin'],'permissions'=>json_decode($row['permissions_json']?:'{}',true)]); }
    if($a==='save' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $username=trim($d['username']??''); $full=trim($d['full_name']??''); $phone=trim($d['phone']??''); $is_admin=(int)($d['is_admin']??0); $pass=$d['pass']??''; $perms=json_encode($d['permissions']??[],JSON_UNESCAPED_UNICODE); if($username===''||$pass==='') json_out(['ok'=>false,'error'=>'Login va parol kerak'],400); $ph=password_hash($pass,PASSWORD_DEFAULT); $st=$db->prepare("INSERT INTO users(username, pass_hash, full_name, phone, is_admin, permissions_json) VALUES (?,?,?,?,?,?)"); $st->bind_param('ssssss',$username,$ph,$full,$phone,$is_admin,$perms); $st->execute(); audit('create','user',$st->insert_id,['username'=>$username]); json_out(['ok'=>true,'id'=>$st->insert_id]); }
    if($a==='update' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); $username=trim($d['username']??''); $full=trim($d['full_name']??''); $phone=trim($d['phone']??''); $is_admin=(int)($d['is_admin']??0); $pass=$d['pass']??''; $perms=json_encode($d['permissions']??[],JSON_UNESCAPED_UNICODE); if(!$id||$username==='') json_out(['ok'=>false,'error'=>'ID yoki login yo‘q'],400); if($pass!==''){ $ph=password_hash($pass,PASSWORD_DEFAULT); $st=$db->prepare("UPDATE users SET username=?, pass_hash=?, full_name=?, phone=?, is_admin=?, permissions_json=? WHERE id=?"); $st->bind_param('ssssisi',$username,$ph,$full,$phone,$is_admin,$perms,$id); } else { $st=$db->prepare("UPDATE users SET username=?, full_name=?, phone=?, is_admin=?, permissions_json=? WHERE id=?"); $st->bind_param('sssisi',$username,$full,$phone,$is_admin,$perms,$id); } $st->execute(); audit('update','user',$id,['username'=>$username]); json_out(['ok'=>true]); }
    if($a==='delete' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); if(!$id) json_out(['ok'=>false,'error'=>'ID yo‘q'],400); $db->query("DELETE FROM users WHERE id=$id"); audit('delete','user',$id,[]); json_out(['ok'=>true]); }
  }

  // ===== Contracts =====
  if($r==='contracts'){
    if($a==='list'){ $page=max(1,(int)($_GET['page']??1)); $size=max(1,min(200,(int)($_GET['size']??20))); $q=$db->real_escape_string($_GET['q']??''); $status=$db->real_escape_string($_GET['status']??''); $w="1=1"; if($q!=='') $w.=" AND (c.shop_name LIKE '%$q%' OR c.code LIKE '%$q%')"; if($status!=='') $w.=" AND c.status='$status'"; $total=$db->query("SELECT COUNT(*) c FROM contracts c WHERE $w")->fetch_assoc()['c']??0; $off=($page-1)*$size; $rs=$db->query("SELECT c.*, r.name region_name FROM contracts c LEFT JOIN regions r ON r.id=c.region_id WHERE $w ORDER BY c.id DESC LIMIT $off,$size"); json_out(['ok'=>true,'items'=>$rs->fetch_all(MYSQLI_ASSOC),'total'=>(int)$total]); }
    if($a==='get'){ $id=(int)($_GET['id']??0); if(!$id) json_out(['ok'=>false,'error'=>'ID yo‘q'],400); $c=$db->query("SELECT c.*, r.name region_name FROM contracts c LEFT JOIN regions r ON r.id=c.region_id WHERE c.id=$id")->fetch_assoc(); if(!$c) json_out(['ok'=>false,'error'=>'Topilmadi'],404); $fields=$db->query("SELECT f.id field_id,f.label,cf.value FROM contract_fields cf JOIN form_fields f ON f.id=cf.field_id WHERE cf.contract_id=$id ORDER BY f.sort_order")->fetch_all(MYSQLI_ASSOC); $equip=$db->query("SELECT e.name, ce.qty, e.id FROM contract_equipment ce JOIN equipment e ON e.id=ce.equipment_id WHERE ce.contract_id=$id")->fetch_all(MYSQLI_ASSOC); $files=$db->query("SELECT id, kind, path, mime, size FROM contract_files WHERE contract_id=$id ORDER BY id")->fetch_all(MYSQLI_ASSOC); json_out(['ok'=>true,'contract'=>$c,'fields'=>$fields,'equipment'=>$equip,'files'=>$files]); }
    if($a==='save' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $shop=trim($d['shop_name']??''); $region_id=(int)($d['region_id']??0); $address=trim($d['address']??''); $lat=$d['latitude']??null; $lng=$d['longitude']??null; $fields=$d['fields']??[]; $equip=$d['equipment']??[]; $files=$d['files']??[]; if($shop===''||!$region_id||$address===''||!$lat||!$lng) json_out(['ok'=>false,'error'=>'Majburiy maydonlar to‘liq emas'],400);
      // dynamic required
      $req=$db->query("SELECT id,type FROM form_fields WHERE is_active=1 AND required=1")->fetch_all(MYSQLI_ASSOC); $provided=[]; foreach($fields as $f){ $provided[(int)$f['id']]=trim((string)($f['value']??'')); }
      $hasImage=false; foreach($files as $ff){ if(($ff['kind']??'')==='image'){ $hasImage=true; break; } }
      $missing=[]; foreach($req as $rrow){ $rid=(int)$rrow['id']; $rt=$rrow['type']; $val=$provided[$rid]??''; if($rt==='camera'){ if($val!=='' && $val!=='0') continue; if($hasImage) continue; $missing[]=$rid; } else { if($val==='') $missing[]=$rid; } }
      if($missing){ json_out(['ok'=>false,'error'=>'Dinamik majburiy maydonlar to‘liq emas','missing'=>$missing],400); }
      // require signatures?
      if(perm('require_two_signatures',false)){ $kinds=array_map(fn($x)=>($x['kind']??''), $files); if(!(in_array('signature_staff',$kinds) && in_array('signature_shop',$kinds))) json_out(['ok'=>false,'error'=>'Ikkala tomon imzosi talab etiladi'],400); }
      $db->begin_transaction(); try{
        $code='C'.time().mt_rand(100,999); $uid=(int)($_SESSION['uid']??0);
        $st=$db->prepare("INSERT INTO contracts(code,staff_id,shop_name,region_id,address,latitude,longitude,status) VALUES (?,?,?,?,?,?,?, 'submitted')");
        $st->bind_param('sisssdd',$code,$uid,$shop,$region_id,$address,$lat,$lng); $st->execute(); $cid=$st->insert_id;
        if(!empty($fields)){ $sf=$db->prepare("INSERT INTO contract_fields(contract_id,field_id,value) VALUES (?,?,?)"); foreach($fields as $f){ $fid=(int)$f['id']; $val=(string)($f['value']??''); $sf->bind_param('iis',$cid,$fid,$val); $sf->execute(); } }
        if(!empty($equip)){ $se=$db->prepare("INSERT INTO contract_equipment(contract_id,equipment_id,qty) VALUES (?,?,?)"); foreach($equip as $e){ $eid=(int)$e['id']; $q=(int)$e['qty']; if($q<1)$q=1; $se->bind_param('iii',$cid,$eid,$q); $se->execute(); } }
        if(!empty($files)){ $sfile=$db->prepare("INSERT INTO contract_files(contract_id,kind,path,mime,size) VALUES (?,?,?,?,?)"); foreach($files as $f){ $kind=$f['kind']??'file'; $mime=$f['mime']??'application/octet-stream'; $name=$f['name']??($kind.'.bin'); $b64=$f['base64']??''; $sv=b64save($cid,$kind,$mime,$name,$b64); if(!$sv) continue; $sfile->bind_param('isssi',$cid,$kind,$sv['rel'],$mime,$sv['size']); $sfile->execute(); } }
        $db->commit(); audit('create','contract',$cid,['code'=>$code,'shop'=>$shop,'region_id'=>$region_id]); json_out(['ok'=>true,'id'=>$cid,'code'=>$code]);
      }catch(Throwable $e){ $db->rollback(); log_line('SAVE ERR: '.$e->getMessage()); json_out(['ok'=>false,'error'=>'DB error'],500); }
    }
    if($a==='file'){ $id=(int)($_GET['id']??0); if(!$id){ header('HTTP/1.1 400'); echo 'ID required'; exit; } $row=$db->query("SELECT * FROM contract_files WHERE id=$id")->fetch_assoc(); if(!$row){ header('HTTP/1.1 404'); echo 'Not found'; exit; } $full=__DIR__.'/../'.$row['path']; if(!is_file($full)){ header('HTTP/1.1 404'); echo 'Not found'; exit; } header('Content-Type: '.($row['mime']?:'application/octet-stream')); header('Content-Length: '.filesize($full)); header('Content-Disposition: inline; filename=\"'.basename($full).'\"'); readfile($full); exit; }
    if($a==='print_html'){ header('Content-Type: text/html; charset=utf-8'); $ids=array_filter(array_map('intval', explode(',', $_GET['ids']??''))); if(empty($ids)){ echo 'IDs yo‘q'; exit; } $tpl_id=(int)($_GET['template_id']??0); $tpl_items=[]; if($tpl_id){ $row=$db->query("SELECT items_json FROM templates WHERE id=$tpl_id")->fetch_assoc(); if($row){ $tpl_items=json_decode($row['items_json'],true)?:[]; } } echo "<!doctype html><html><head><meta charset='utf-8'><title>Print</title><style>body{font-family:Arial,Helvetica,sans-serif;margin:24px} .c{page-break-after:always;border:1px solid #ddd;padding:12px;margin-bottom:18px} h3{margin:.2rem 0}</style></head><body>";
      foreach($ids as $id){ $c=$db->query("SELECT c.*, r.name region_name FROM contracts c LEFT JOIN regions r ON r.id=c.region_id WHERE c.id=$id")->fetch_assoc(); if(!$c){ echo "<div class='c'>#{$id} topilmadi</div>"; continue; } $fields=$db->query("SELECT f.id field_id,f.label,cf.value FROM contract_fields cf JOIN form_fields f ON f.id=cf.field_id WHERE cf.contract_id=$id ORDER BY f.sort_order")->fetch_all(MYSQLI_ASSOC); $equip=$db->query("SELECT e.name,ce.qty FROM contract_equipment ce JOIN equipment e ON e.id=ce.equipment_id WHERE ce.contract_id=$id")->fetch_all(MYSQLI_ASSOC); $files=$db->query("SELECT kind,path,mime FROM contract_files WHERE contract_id=$id ORDER BY id")->fetch_all(MYSQLI_ASSOC);
        echo "<div class='c'><h3>Shartnoma #".h($c['code'])."</h3><div><strong>Do‘kon:</strong> ".h($c['shop_name'])." &nbsp; <strong>Manzil:</strong> ".h($c['address'])."</div>";
        if($tpl_items){ echo "<hr><table>"; foreach($tpl_items as $it){ $k=$it['key']??''; $lab=h($it['label']??$k); $val=''; if($k==='shop_name') $val=h($c['shop_name']); elseif($k==='address') $val=h($c['address']); elseif($k==='region_name') $val=h($c['region_name']); elseif($k==='status') $val=h($c['status']); elseif($k==='latitude') $val=$c['latitude']; elseif($k==='longitude') $val=$c['longitude']; elseif(substr($k,0,6)==='field:'){ $fid=(int)substr($k,6); foreach($fields as $f){ if((int)$f['field_id']===$fid){ $val=h($f['value']); break; } } } elseif($k==='signature_staff'||$k==='signature_shop'){ foreach($files as $f){ if($f['kind']===$k){ $val=\"<img src='../\".h($f['path']).\"' style='max-width:180px'>\"; break; } } } elseif($k==='image'){ foreach($files as $f){ if($f['kind']==='image'){ $val.=\"<img src='../\".h($f['path']).\"' style='max-width:140px; margin-right:6px'>\"; } } } elseif($k==='audio'){ $val='(audio mavjud)'; } echo "<tr><td style='padding-right:12px'>".$lab."</td><td>".$val."</td></tr>"; } echo "</table>"; }
        else { echo "<hr><div><strong>Maydonlar:</strong><ul>"; foreach($fields as $f){ echo "<li>".h($f['label']).": ".h($f['value'])."</li>"; } echo "</ul></div><div><strong>Jihozlar:</strong><ul>"; foreach($equip as $e){ echo "<li>".h($e['name'])." — ".(int)$e['qty']."</li>"; } echo "</ul></div>"; }
        foreach($files as $f){ if($f['kind']==='signature_staff'||$f['kind']==='signature_shop'||$f['kind']==='image'){ echo "<img src='../".h($f['path'])."' style='max-width:180px; margin:4px'>"; } }
        echo "</div>";
      } echo "</body></html>"; exit;
    }
    if($a==='export_selected'){ $ids=array_filter(array_map('intval', explode(',', $_GET['ids']??''))); if(empty($ids)) json_out(['ok'=>false,'error'=>'IDs yo‘q'],400); $type=strtolower($_GET['type']??'csv');
      if($type==='txt'){ header('Content-Type: text/plain; charset=utf-8'); header('Content-Disposition: attachment; filename=\"contracts.txt\"'); $rs=$db->query("SELECT c.id,c.code,c.shop_name,r.name region_name,c.address,c.status,c.created_at FROM contracts c LEFT JOIN regions r ON r.id=c.region_id WHERE c.id IN (".implode(',',$ids).") ORDER BY c.id"); while($row=$rs->fetch_assoc()){ echo $row['id']."\t".$row['code']."\t".$row['shop_name']."\t".$row['address']."\t".$row['region_name']."\t".$row['status']."\t".$row['created_at'].PHP_EOL; } exit; }
      if($type==='xls'){ header('Content-Type: application/vnd.ms-excel'); header('Content-Disposition: attachment; filename=\"contracts.xls\"'); echo "<table border='1'><tr><th>ID</th><th>Kod</th><th>Do‘kon</th><th>Manzil</th><th>Viloyat</th><th>Status</th><th>Vaqt</th></tr>"; $rs=$db->query("SELECT c.id,c.code,c.shop_name,r.name region_name,c.address,c.status,c.created_at FROM contracts c LEFT JOIN regions r ON r.id=c.region_id WHERE c.id IN (".implode(',',$ids).") ORDER BY c.id"); while($row=$rs->fetch_assoc()){ echo "<tr><td>".h($row['id'])."</td><td>".h($row['code'])."</td><td>".h($row['shop_name'])."</td><td>".h($row['address'])."</td><td>".h($row['region_name'])."</td><td>".h($row['status'])."</td><td>".h($row['created_at'])."</td></tr>"; } echo "</table>"; exit; }
      if($type==='doc'){ header('Content-Type: application/msword'); header('Content-Disposition: attachment; filename=\"contracts.doc\"'); echo "<html><body><h3>Shartnomalar</h3><table border='1' cellspacing='0' cellpadding='6'><tr><th>ID</th><th>Kod</th><th>Do‘kon</th><th>Manzil</th><th>Viloyat</th><th>Status</th><th>Vaqt</th></tr>"; $rs=$db->query("SELECT c.id,c.code,c.shop_name,r.name region_name,c.address,c.status,c.created_at FROM contracts c LEFT JOIN regions r ON r.id=c.region_id WHERE c.id IN (".implode(',',$ids).") ORDER BY c.id"); while($row=$rs->fetch_assoc()){ echo "<tr><td>".h($row['id'])."</td><td>".h($row['code'])."</td><td>".h($row['shop_name'])."</td><td>".h($row['address'])."</td><td>".h($row['region_name'])."</td><td>".h($row['status'])."</td><td>".h($row['created_at'])."</td></tr>"; } echo "</table></body></html>"; exit; }
      header('Content-Type: text/csv; charset=utf-8'); header('Content-Disposition: attachment; filename=\"contracts.csv\"'); $out=fopen('php://output','w'); fputcsv($out,['ID','Kod','Do‘kon','Manzil','Viloyat','Status','Vaqt']); $rs=$db->query("SELECT c.id,c.code,c.shop_name,r.name region_name,c.address,c.status,c.created_at FROM contracts c LEFT JOIN regions r ON r.id=c.region_id WHERE c.id IN (".implode(',',$ids).") ORDER BY c.id"); while($row=$rs->fetch_assoc()){ fputcsv($out,[$row['id'],$row['code'],$row['shop_name'],$row['address'],$row['region_name'],$row['status'],$row['created_at']]); } exit;
    }
  }

  // ===== Templates =====
  if($r==='templates'){
    if($a==='list'){ $rs=$db->query("SELECT id,name,created_at FROM templates ORDER BY id DESC"); json_out(['ok'=>true,'items'=>$rs->fetch_all(MYSQLI_ASSOC)]); }
    if($a==='get'){ $id=(int)($_GET['id']??0); $row=$db->query("SELECT * FROM templates WHERE id=$id")->fetch_assoc(); if(!$row) json_out(['ok'=>false,'error'=>'Topilmadi'],404); json_out(['ok'=>true,'id'=>$row['id'],'name'=>$row['name'],'items'=>json_decode($row['items_json']??'[]',true)]); }
    if($a==='save' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $name=trim($d['name']??''); $items=$d['items']??[]; if($name==='') json_out(['ok'=>false,'error'=>'Nomi kerak'],400); $ij=json_encode($items,JSON_UNESCAPED_UNICODE); $st=$db->prepare("INSERT INTO templates(name,items_json) VALUES (?,?)"); $st->bind_param('ss',$name,$ij); $st->execute(); audit('create','template',$st->insert_id,['name'=>$name]); json_out(['ok'=>true,'id'=>$st->insert_id]); }
    if($a==='update' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); $name=trim($d['name']??''); $items=$d['items']??[]; if(!$id||$name==='') json_out(['ok'=>false,'error'=>'ID yoki nom yo‘q'],400); $ij=json_encode($items,JSON_UNESCAPED_UNICODE); $st=$db->prepare("UPDATE templates SET name=?, items_json=? WHERE id=?"); $st->bind_param('ssi',$name,$ij,$id); $st->execute(); audit('update','template',$id,['name'=>$name]); json_out(['ok'=>true]); }
    if($a==='delete' && $method==='POST'){ $d=json_decode(file_get_contents('php://input'),true)?:[]; $id=(int)($d['id']??0); if(!$id) json_out(['ok'=>false,'error'=>'ID yo‘q'],400); $db->query("DELETE FROM templates WHERE id=$id"); audit('delete','template',$id,[]); json_out(['ok'=>true]); }
  }

  // ===== Logs =====
  if($r==='logs' && $a==='list'){
    $page=max(1,(int)($_GET['page']??1)); $size=max(1,min(200,(int)($_GET['size']??20))); $q=$db->real_escape_string($_GET['q']??'');
    $w="1=1"; if($q!=='') $w.=" AND (a.action LIKE '%$q%' OR a.entity LIKE '%$q%' OR u.username LIKE '%$q%')";
    $total=$db->query("SELECT COUNT(*) c FROM audit_log a LEFT JOIN users u ON u.id=a.user_id WHERE $w")->fetch_assoc()['c']??0; $off=($page-1)*$size;
    $rs=$db->query("SELECT a.*, u.username FROM audit_log a LEFT JOIN users u ON u.id=a.user_id WHERE $w ORDER BY a.id DESC LIMIT $off,$size");
    json_out(['ok'=>true,'items'=>$rs->fetch_all(MYSQLI_ASSOC),'total'=>(int)$total]);
  }

  // Fallback
  json_out(['ok'=>false,'error'=>'Unknown route'],404);
}catch(Throwable $e){ log_line('FATAL: '.$e->getMessage().' @ '.$e->getFile().':'.$e->getLine()); json_out(['ok'=>false,'error'=>'Server error'],500); }
