if(window.__APP_LOADED__){ console.warn('APP already loaded'); } else { window.__APP_LOADED__=true;
window.APP=(function(){
  'use strict';
  const st={page:1,size:20,map:null,marker:null,imgs:[],vids:[],files:[],camCtx:{},camShots:[],audioRec:null,audioChunks:[],sig1:null,sig2:null,
            userPage:1,userSize:20,logPage:1,logSize:20};
  const $=s=>document.querySelector(s), $$=s=>Array.from(document.querySelectorAll(s));
  async function j(url,opt){ const r=await fetch(url,opt||{}); const t=await r.text(); let data; try{ data=JSON.parse(t); }catch(e){ throw new Error('Non-JSON: '+t.slice(0,200)); } if(!r.ok || data.ok===false) throw new Error(data.error||('HTTP '+r.status)); return data; }
  function msg(title,body){ const m=$('#msgModal'); if(!m) return alert(title+': '+body); m.querySelector('.modal-title').textContent=title||'Xabar'; m.querySelector('.modal-body').innerHTML=(typeof body==='string'? body : JSON.stringify(body)); new bootstrap.Modal(m).show(); }
  function confirmAsk(title,body,cb){ const m=$('#confirmModal'); APP.__confirmYes=cb; m.querySelector('.modal-title').textContent=title||'Tasdiqlash'; m.querySelector('.modal-body').textContent=body||''; new bootstrap.Modal(m).show(); }

  // ===== Dashboard =====
  async function loadKPIs(){ try{ const d=await j('api/index.php?r=stats&a=kpi'); $('#kpi_submitted').textContent=d.kpi.submitted; $('#kpi_approved').textContent=d.kpi.approved; $('#kpi_rejected').textContent=d.kpi.rejected; $('#kpi_equip').textContent=d.kpi.equip; }catch(e){ console.error(e); } }
  async function loadAuditStream(){ try{ const d=await j('api/index.php?r=logs&a=list&size=20'); const el=$('#events_stream'); el.innerHTML=''; (d.items||[]).forEach(x=>{ const div=document.createElement('div'); div.textContent = `[${x.created_at}] ${x.username||''} — ${x.action} ${x.entity}#${x.entity_id}`; el.prepend(div); }); }catch(e){ console.error(e); } }

  // ===== Common data =====
  async function loadRegions(){ const d=await j('api/index.php?r=regions&a=list'); const sel=$('#regionSelect'); if(!sel) return; sel.innerHTML='<option value=\"\">Tanlang…</option>'; (d.items||[]).forEach(i=>{ const o=document.createElement('option'); o.value=i.id; o.textContent=i.name; sel.appendChild(o); }); }
  async function loadEquipment(){ const d=await j('api/index.php?r=equipment&a=list'); const wrap=$('#equipWrap'); if(!wrap) return; wrap.innerHTML=''; (d.items||[]).forEach(i=>{ const div=document.createElement('div'); div.className='col-md-4'; div.innerHTML=`<label class=\"form-label\">${i.name}</label><div class=\"input-group\"><span class=\"input-group-text\">Soni</span><input type=\"number\" min=\"0\" class=\"form-control\" data-eid=\"${i.id}\" value=\"0\"></div>`; wrap.appendChild(div); }); }
  async function loadFields(){ const d=await j('api/index.php?r=fields&a=list'); const wrap=$('#dynFields'); if(!wrap) return; wrap.innerHTML=''; (d.items||[]).filter(x=>x.is_active==1).sort((a,b)=>a.sort_order-b.sort_order).forEach(f=>{ const col=document.createElement('div'); col.className='col-md-4'; let input=''; const req=f.required==1?'required':'';
      if(f.type==='text') input=`<input class=\"form-control\" data-fid=\"${f.id}\" ${req}>`;
      else if(f.type==='number') input=`<input type=\"number\" class=\"form-control\" data-fid=\"${f.id}\" ${req}>`;
      else if(f.type==='date') input=`<input type=\"date\" class=\"form-control\" data-fid=\"${f.id}\" ${req}>`;
      else if(f.type==='textarea') input=`<textarea class=\"form-control\" data-fid=\"${f.id}\" ${req}></textarea>`;
      else if(f.type==='select'){ let opts=[]; try{ opts=JSON.parse(f.options_json||'[]'); }catch(_){ opts=[]; } input = `<select class=\"form-select\" data-fid=\"${f.id}\" ${req}>`+(['Tanlang...'].concat(opts.map(o=>o.text||o.value))).map((t,i)=>`<option value=\"${i? (opts[i-1].value||opts[i-1].text):''}\">${t}</option>`).join('')+`</select>`; }
      else if(f.type==='checkbox') input=`<div class=\"form-check\"><input class=\"form-check-input\" type=\"checkbox\" data-fid=\"${f.id}\" ${req}><label class=\"form-check-label\">${f.label}</label></div>`;
      else if(f.type==='camera'){ const camId='cam_'+f.id; input=`<input type='hidden' id='camFlag_${f.id}' data-fid='${f.id}' value='0'><div id='${camId}' class='border rounded p-2'><div class='d-flex gap-2 align-items-center'><button type='button' class='btn btn-outline-primary btn-sm' onclick='APP.startCam(${f.id})'>Kamerani yoqish</button><button type='button' class='btn btn-outline-success btn-sm' onclick='APP.snapCam(${f.id})' disabled>Rasmga olish</button><button type='button' class='btn btn-outline-danger btn-sm' onclick='APP.stopCam(${f.id})' disabled>To‘xtatish</button></div><video autoplay playsinline style='display:none;max-width:100%'></video><canvas style='display:none;max-width:100%'></canvas><div class='form-text'>Olingan rasm(lar) previewda ko‘rinadi.</div></div>`; }
      col.innerHTML=`<label class=\"form-label\">${f.label}${f.required==1?' *':''}</label>${input}`; wrap.appendChild(col); }); }

  // ===== Contracts list & actions =====
  async function loadContracts(page){ st.page=page||1; const p=new URLSearchParams(new FormData($('#filterForm'))); p.set('page',st.page); p.set('size',st.size);
    const d=await j('api/index.php?r=contracts&a=list&'+p.toString()); const tb=$('#contracts_tbody'); tb.innerHTML='';
    (d.items||[]).forEach(row=>{ const tr=document.createElement('tr'); tr.innerHTML=`<td><input type='checkbox' class='rowchk' value='${row.id}'></td><td>${row.id}</td><td>${row.code||''}</td><td>${row.shop_name}</td><td>${row.region_name||''}</td><td>${row.status}</td><td>${row.created_at}</td><td><div class='btn-group btn-group-sm'><button class='btn btn-outline-primary' onclick='APP.openRead(${row.id})'>Ko‘rish</button><button class='btn btn-outline-secondary' onclick='APP.printOne(${row.id})'>Print</button></div></td>`; tb.appendChild(tr); });
    const total=d.total||0; $('#rangeTxt').textContent=`${((st.page-1)*st.size)+1}–${Math.min(st.page*st.size,total)} / jami ${total}`; $('#rangeC2').textContent = $('#rangeTxt').textContent;
  }
  function idsSelected(){ return $$('.rowchk:checked').map(x=>x.value).join(','); }
  function previewSelected(){ const ids=idsSelected(); if(!ids) return msg('Diqqat','Hech narsa tanlanmadi'); const tpl=($('#tplSelect')||{value:0}).value; window.open('api/index.php?r=contracts&a=print_html&ids='+ids+(tpl?('&template_id='+tpl):''),'_blank'); }
  function exportSelected(fmt){ const ids=idsSelected(); if(!ids) return msg('Diqqat','Hech narsa tanlanmadi'); const tpl=($('#tplSelect')||{value:0}).value; window.open('api/index.php?r=contracts&a=export_selected&type='+fmt+'&ids='+ids+(tpl?('&template_id='+tpl):''),'_blank'); }
  function printOne(id){ const tpl=($('#tplSelect')||{value:0}).value; window.open('api/index.php?r=contracts&a=print_html&ids='+id+(tpl?('&template_id='+tpl):''),'_blank'); }

  // ===== Contract modal lifecycle =====
  function onContractShown(){ startAudio(); wireMedia(); initSign(); initMap(); }
  function onContractHidden(){ stopAudio(); st.imgs=[]; st.vids=[]; st.files=[]; st.camShots=[]; st.audioChunks=[]; st.sig1=null; st.sig2=null; if(st.audioRec && st.audioRec.stream){ st.audioRec.stream.getTracks().forEach(t=>t.stop()); } Object.values(st.camCtx).forEach(c=>{ if(c.stream) (c.stream.getTracks()||[]).forEach(t=>t.stop()); }); st.camCtx={}; }

  // ===== Media helpers =====
  function fileToB64(f){ return new Promise((res,rej)=>{ const rd=new FileReader(); rd.onload=()=>res(rd.result); rd.onerror=rej; rd.readAsDataURL(f); }); }
  function wireMedia(){ const imgIn=$('#imgInput'), vidIn=$('#vidInput'), fileIn=$('#fileInput'); const imgP=$('#imgPreview'), vidP=$('#vidPreview'), fileP=$('#filePreview');
    const add=(list,files,kind,prev)=>{ for(const f of files){ list.push(f); const wrap=document.createElement('div'); wrap.className='position-relative'; const del=document.createElement('button'); del.type='button'; del.className='btn btn-sm btn-danger position-absolute'; del.style.top='-8px'; del.style.right='-8px'; del.textContent='O‘chirish'; del.onclick=()=>{ const i=list.indexOf(f); if(i>=0) list.splice(i,1); wrap.remove(); };
      if(kind==='image'){ const url=URL.createObjectURL(f); wrap.innerHTML=`<img src='${url}' class='img-thumbnail' style='width:120px;height:120px;object-fit:cover;'>`; }
      else if(kind==='video'){ const url=URL.createObjectURL(f); wrap.innerHTML=`<video src='${url}' style='width:180px;height:120px' controls></video>`; }
      else{ wrap.innerHTML=`<span class='badge bg-secondary'>${f.name}</span>`; }
      wrap.appendChild(del); prev.appendChild(wrap); } };
    if(imgIn) imgIn.onchange=e=>{ add(st.imgs, e.target.files, 'image', imgP); imgIn.value=''; };
    if(vidIn) vidIn.onchange=e=>{ add(st.vids, e.target.files, 'video', vidP); vidIn.value=''; };
    if(fileIn) fileIn.onchange=e=>{ add(st.files, e.target.files, 'file', fileP); fileIn.value=''; };
  }

  // ===== Audio (auto) =====
  async function startAudio(){ try{ const s=await navigator.mediaDevices.getUserMedia({audio:true}); st.audioRec=new MediaRecorder(s); st.audioChunks=[]; st.audioRec.ondataavailable=e=>{ if(e.data.size>0) st.audioChunks.push(e.data); }; st.audioRec.onstop=()=>{ const blob=new Blob(st.audioChunks,{type:'audio/webm'}); const rd=new FileReader(); rd.onload=()=>{ const a=$('#audioPrev'); if(a){ a.src=URL.createObjectURL(blob); a.style.display='block'; } st.audioB64=rd.result; }; rd.readAsDataURL(blob); }; st.audioRec.start(); }catch(e){ console.warn('Audio ruxsat yo‘q', e); } }
  function stopAudio(){ try{ if(st.audioRec&&st.audioRec.state!=='inactive'){ st.audioRec.stop(); if(st.audioRec.stream){ st.audioRec.stream.getTracks().forEach(t=>t.stop()); } } }catch(_){ } }

  // ===== Signatures =====
  function initSign(){ const c1=$('#sigStaff'), c2=$('#sigShop'); if(c1) st.sig1=new SigPad(c1); if(c2) st.sig2=new SigPad(c2); }
  function sigClear(which){ if(which==='staff'&&st.sig1) st.sig1.clear(); if(which==='shop'&&st.sig2) st.sig2.clear(); }
  function sigSave(which){ const data=(which==='staff'?(st.sig1?st.sig1.toDataURL():null):(st.sig2?st.sig2.toDataURL():null)); if(!data) return; const img=new Image(); img.src=data; img.className='img-thumbnail'; img.style.maxWidth='200px'; if(which==='staff'){ $('#sigPrevStaff').innerHTML=''; $('#sigPrevStaff').appendChild(img); st.sigStaff=data; } else { $('#sigPrevShop').innerHTML=''; $('#sigPrevShop').appendChild(img); st.sigShop=data; } }

  // ===== Camera =====
  async function startCam(fid){ const box=document.getElementById('cam_'+fid); if(!box) return; const v=box.querySelector('video'); const btns=box.querySelectorAll('button'); btns[1].disabled=true; btns[2].disabled=true;
    try{ const s=await navigator.mediaDevices.getUserMedia({video:true}); v.srcObject=s; v.style.display='block'; btns[1].disabled=false; btns[2].disabled=false; st.camCtx[fid]={stream:s,box}; }catch(e){ msg('Kamera','Ruxsat berilmadi: '+e.message); } }
  function snapCam(fid){ const ctx=st.camCtx[fid]; if(!ctx) return; const v=ctx.box.querySelector('video'); const c=ctx.box.querySelector('canvas'); c.width=v.videoWidth||640; c.height=v.videoHeight||480; c.getContext('2d').drawImage(v,0,0,c.width,c.height); const data=c.toDataURL('image/png'); st.camShots.push(data); c.style.display='block'; const prev=$('#imgPreview'); if(prev){ const w=document.createElement('div'); w.className='position-relative'; const del=document.createElement('button'); del.type='button'; del.className='btn btn-sm btn-danger position-absolute'; del.style.top='-8px'; del.style.right='-8px'; del.textContent='O‘chirish'; del.onclick=()=>{ const i=st.camShots.indexOf(data); if(i>=0) st.camShots.splice(i,1); w.remove(); }; w.innerHTML=`<img src='${data}' class='img-thumbnail' style='width:120px;height:120px;object-fit:cover;'>`; w.appendChild(del); prev.appendChild(w); } const hf=document.getElementById('camFlag_'+fid); if(hf) hf.value='1'; }
  function stopCam(fid){ const ctx=st.camCtx[fid]; if(!ctx) return; (ctx.stream.getTracks()||[]).forEach(t=>t.stop()); delete st.camCtx[fid]; const v=ctx.box.querySelector('video'); if(v) v.style.display='none'; }

  // ===== Save Contract =====
  async function saveContract(){ const frm=$('#contractForm'); const body={ shop_name: frm.shop_name.value.trim(), region_id: parseInt(frm.region_id.value||0), address: frm.address.value.trim(), latitude: parseFloat(frm.latitude.value), longitude: parseFloat(frm.longitude.value), fields: $$('#dynFields [data-fid]').map(el=>{ const fid=parseInt(el.getAttribute('data-fid')); const val=(el.type==='checkbox')?(el.checked?'ha':'yoq'):(el.value||''); return {id:fid,value:val}; }), equipment: $$('#equipWrap [data-eid]').map(el=>({id:parseInt(el.getAttribute('data-eid')), qty:parseInt(el.value||0)})).filter(x=>x.qty>0), files: [] };
    for(const f of st.imgs){ body.files.push({kind:'image', mime:f.type||'image/*', name:f.name, base64: await fileToB64(f)}); }
    for(const b64 of st.camShots){ body.files.push({kind:'image', mime:'image/png', name:'camera.png', base64: b64}); }
    for(const f of st.vids){ body.files.push({kind:'video', mime:f.type||'video/*', name:f.name, base64: await fileToB64(f)}); }
    for(const f of st.files){ body.files.push({kind:'file', mime:f.type||'application/octet-stream', name:f.name, base64: await fileToB64(f)}); }
    if(st.audioB64) body.files.push({kind:'audio', mime:'audio/webm', name:'audio.webm', base64: st.audioB64});
    if(window.st && st.sigStaff) body.files.push({kind:'signature_staff', mime:'image/png', name:'sig-staff.png', base64: st.sigStaff});
    if(window.st && st.sigShop) body.files.push({kind:'signature_shop', mime:'image/png', name:'sig-shop.png', base64: st.sigShop});
    try{ const r=await j('api/index.php?r=contracts&a=save',{method:'POST',body:JSON.stringify(body)}); msg('OK','Saqlandi: #'+r.id+' ('+(r.code||'')+')'); document.querySelector('#modalContract .btn-close').click(); loadContracts(1); }
    catch(e){ msg('Saqlashda xatolik', e.message); }
  }

  // ===== Read modal =====
  async function openRead(id){ const d=await j('api/index.php?r=contracts&a=get&id='+id); const c=d.contract, fields=d.fields||[], equip=d.equipment||[], files=d.files||[];
    let html=`<div class='row g-2'><div class='col-md-3'><strong>Kod:</strong> ${c.code||''}</div><div class='col-md-3'><strong>Status:</strong> ${c.status}</div><div class='col-md-6'><strong>Do‘kon:</strong> ${c.shop_name}</div><div class='col-md-6'><strong>Manzil:</strong> ${c.address}</div><div class='col-md-3'><strong>Viloyat:</strong> ${c.region_name||''}</div><div class='col-md-3'><strong>GPS:</strong> ${c.latitude}, ${c.longitude}</div></div><hr><h6>Maydonlar</h6><ul>`;
    fields.forEach(f=> html+=`<li><strong>${f.label}:</strong> ${f.value||''}</li>`); html+='</ul><h6>Jihozlar</h6><ul>'; equip.forEach(e=> html+=`<li>${e.name||''} — ${e.qty} dona</li>`); html+='</ul><h6>Fayllar</h6><div class="d-flex flex-wrap gap-3">';
    files.forEach(file=>{ if(file.kind==='image'||file.kind==='signature_staff'||file.kind==='signature_shop'){ html+=`<div><img src='${file.path}' style='max-width:220px' class='img-thumbnail'><div class='small text-muted'>${file.kind}</div></div>`; } else if(file.kind==='video'){ html+=`<video controls src='${file.path}' style='max-width:320px'></video>`; } else if(file.kind==='audio'){ html+=`<audio controls src='api/index.php?r=contracts&a=file&id=${file.id}'></audio>`; } else { html+=`<a class='btn btn-sm btn-outline-secondary' href='${file.path}' target='_blank'>${file.kind}</a>`; } });
    html+='</div>'; $('#readBody').innerHTML=html; new bootstrap.Modal(document.getElementById('modalRead')).show(); }

  // ===== Map =====
  function initMap(){ const el=document.getElementById('miniMap'); if(!el) return; if(st.map){ setTimeout(()=>st.map.invalidateSize(),200); return; } st.map=L.map('miniMap').setView([41.3,69.2],12); L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',{maxZoom:19}).addTo(st.map); st.marker=L.marker([41.3,69.2],{draggable:true}).addTo(st.map); const sync=()=>{ const p=st.marker.getLatLng(); const la=document.querySelector('input[name=latitude]'); const lo=document.querySelector('input[name=longitude]'); if(la) la.value=p.lat.toFixed(6); if(lo) lo.value=p.lng.toFixed(6); }; st.marker.on('dragend',sync); st.map.on('click',e=>{ st.marker.setLatLng(e.latlng); sync(); }); }

  // ===== Regions CRUD (page) =====
  async function regLoad(){ const d=await j('api/index.php?r=regions&a=list'); const tb=$('#regBody'); tb.innerHTML=''; (d.items||[]).forEach(r=>{ const tr=document.createElement('tr'); tr.innerHTML=`<td>${r.id}</td><td>${r.name}</td><td>${r.latitude||''}, ${r.longitude||''}</td><td><div class='btn-group btn-group-sm'><button class='btn btn-outline-secondary' onclick='APP.regEdit(${r.id})'>Tahrir</button><button class='btn btn-outline-danger' onclick='APP.regDel(${r.id})'>O‘chirish</button></div></td>`; tb.appendChild(tr); }); }
  function regOpen(){ $('#regId').value=''; $('#regName').value=''; $('#regLat').value=''; $('#regLng').value=''; const m=new bootstrap.Modal($('#modalRegion')); m.show(); setTimeout(()=>{ // map init
      const mapEl=document.getElementById('regMap'); if(!mapEl._leaflet_id){ const map=L.map('regMap').setView([41.3,69.2],12); L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',{maxZoom:19}).addTo(map); const mk=L.marker([41.3,69.2],{draggable:true}).addTo(map); const sync=()=>{ const p=mk.getLatLng(); $('#regLat').value=p.lat.toFixed(6); $('#regLng').value=p.lng.toFixed(6); }; mk.on('dragend',sync); map.on('click',e=>{ mk.setLatLng(e.latlng); sync(); }); setTimeout(()=>map.invalidateSize(),200); mapEl._leaflet_id=map._leaflet_id; mapEl._map=map; mapEl._marker=mk; } else { setTimeout(()=>mapEl._map.invalidateSize(),200); } },180); }
  async function regEdit(id){ const d=await j('api/index.php?r=regions&a=list'); const row=(d.items||[]).find(x=>parseInt(x.id)===parseInt(id)); if(!row) return; regOpen(); $('#regId').value=row.id; $('#regName').value=row.name; $('#regLat').value=row.latitude||''; $('#regLng').value=row.longitude||''; const mapEl=document.getElementById('regMap'); if(mapEl && mapEl._map && mapEl._marker){ mapEl._map.setView([row.latitude||41.3, row.longitude||69.2],13); mapEl._marker.setLatLng([row.latitude||41.3, row.longitude||69.2]); } }
  async function regSave(){ const id=parseInt($('#regId').value||0); const name=$('#regName').value.trim(); const lat=parseFloat($('#regLat').value||0); const lng=parseFloat($('#regLng').value||0); if(!name) return msg('Viloyat','Nomi kerak'); const url='api/index.php?r=regions&a='+(id?'update':'save'); await j(url,{method:'POST',body:JSON.stringify({id,name,latitude:lat,longitude:lng})}); msg('OK','Saqlandi'); document.querySelector('#modalRegion .btn-close').click(); regLoad(); }
  function regDel(id){ confirmAsk('O‘chirish','Viloyat o‘chirilsinmi?', async ()=>{ await j('api/index.php?r=regions&a=delete',{method:'POST',body:JSON.stringify({id})}); msg('OK','O‘chirildi'); regLoad(); }); }

  // ===== Equip CRUD =====
  async function eqLoad(){ const d=await j('api/index.php?r=equipment&a=list'); const tb=$('#eqBody'); if(!tb) return; tb.innerHTML=''; (d.items||[]).forEach(r=>{ const tr=document.createElement('tr'); tr.innerHTML=`<td>${r.id}</td><td>${r.name}</td><td><div class='btn-group btn-group-sm'><button class='btn btn-outline-secondary' onclick='APP.eqEdit(${r.id})'>Tahrir</button><button class='btn btn-outline-danger' onclick='APP.eqDel(${r.id})'>O‘chirish</button></div></td>`; tb.appendChild(tr); }); }
  function eqOpen(){ $('#eqId').value=''; $('#eqName').value=''; new bootstrap.Modal($('#modalEquip')).show(); }
  async function eqEdit(id){ const d=await j('api/index.php?r=equipment&a=list'); const row=(d.items||[]).find(x=>parseInt(x.id)===parseInt(id)); if(!row) return; eqOpen(); $('#eqId').value=row.id; $('#eqName').value=row.name; }
  async function eqSave(){ const id=parseInt($('#eqId').value||0); const name=$('#eqName').value.trim(); if(!name) return msg('Jihoz','Nomi kerak'); const url='api/index.php?r=equipment&a='+(id?'update':'save'); await j(url,{method:'POST',body:JSON.stringify({id,name})}); msg('OK','Saqlandi'); document.querySelector('#modalEquip .btn-close').click(); eqLoad(); }
  function eqDel(id){ confirmAsk('O‘chirish','Jihoz o‘chirilsinmi?', async ()=>{ await j('api/index.php?r=equipment&a=delete',{method:'POST',body:JSON.stringify({id})}); msg('OK','O‘chirildi'); eqLoad(); }); }

  // ===== Fields CRUD (in admin? present in templates.php page call via APP from admin not created; skip separate page) =====
  // Provided only for templates available tokens (loadFields already).

  // ===== Users CRUD =====
  async function userLoad(page){ st.userPage=page||1; const q=$('#userQ')?$('#userQ').value.trim():''; const d=await j('api/index.php?r=users&a=list&page='+st.userPage+'&size='+st.userSize+'&q='+encodeURIComponent(q)); const tb=$('#userBody'); if(!tb) return; tb.innerHTML=''; (d.items||[]).forEach(u=>{ const tr=document.createElement('tr'); tr.innerHTML=`<td>${u.id}</td><td>${u.username}</td><td>${u.full_name||''}</td><td>${u.is_admin==1?'ha':'yoq'}</td><td><div class='btn-group btn-group-sm'><button class='btn btn-outline-secondary' onclick='APP.userEdit(${u.id})'>Tahrir</button><button class='btn btn-outline-danger' onclick='APP.userDel(${u.id})'>O‘chirish</button></div></td>`; tb.appendChild(tr); }); const total=d.total||0; const range=document.getElementById('userRange'); const range2=document.getElementById('userRange2'); const txt=`${((st.userPage-1)*st.userSize)+1}–${Math.min(st.userPage*st.userSize,total)} / jami ${total}`; if(range) range.textContent=txt; if(range2) range2.textContent=txt; }
  function userPrev(){ if(st.userPage>1) userLoad(st.userPage-1); } function userNext(){ userLoad(st.userPage+1); }
  function userOpen(){ $('#userId').value=''; $('#userLogin').value=''; $('#userName').value=''; $('#userPhone').value=''; $('#userAdmin').checked=false; $('#p_create').checked=true; $('#p_export').checked=true; $('#p_auto_audio').checked=true; $('#p_two_sig').checked=false; $('#p_edit_after').checked=false; $('#userPass').value=''; $('#userPass2').value=''; new bootstrap.Modal($('#modalUser')).show(); }
  async function userEdit(id){ const d=await j('api/index.php?r=users&a=get&id='+id); $('#userId').value=d.id; $('#userLogin').value=d.username; $('#userName').value=d.full_name||''; $('#userPhone').value=d.phone||''; $('#userAdmin').checked=(d.is_admin==1); const p=d.permissions||{}; $('#p_create').checked=!!p.can_create_contract; $('#p_export').checked=!!p.can_export; $('#p_auto_audio').checked=!!p.auto_record_audio; $('#p_two_sig').checked=!!p.require_two_signatures; $('#p_edit_after').checked=!!p.allow_staff_edit_after_submit; $('#userPass').value=''; $('#userPass2').value=''; new bootstrap.Modal($('#modalUser')).show(); }
  async function userSave(){ const id=parseInt($('#userId').value||0); const username=$('#userLogin').value.trim(); const full_name=$('#userName').value.trim(); const phone=$('#userPhone').value.trim(); const is_admin=$('#userAdmin').checked?1:0; const pass=$('#userPass').value; const pass2=$('#userPass2').value; if(!username) return msg('Hodim','Login kerak'); if(pass!==pass2) return msg('Parol','Parollar mos emas'); const permissions={ can_create_contract: $('#p_create').checked, can_export: $('#p_export').checked, auto_record_audio: $('#p_auto_audio').checked, require_two_signatures: $('#p_two_sig').checked, allow_staff_edit_after_submit: $('#p_edit_after').checked }; const url='api/index.php?r=users&a='+(id?'update':'save'); const body={id,username,full_name,phone,is_admin,permissions,pass}; await j(url,{method:'POST',body:JSON.stringify(body)}); msg('OK','Saqlandi'); document.querySelector('#modalUser .btn-close').click(); userLoad(st.userPage); }
  function userDel(id){ confirmAsk('O‘chirish','Hodim o‘chirilsinmi?', async ()=>{ await j('api/index.php?r=users&a=delete',{method:'POST',body:JSON.stringify({id})}); msg('OK','O‘chirildi'); userLoad(st.userPage); }); }

  // ===== Templates CRUD =====
  async function tplLoad(){ const d=await j('api/index.php?r=templates&a=list'); const tb=$('#tplBody'); if(!tb) return; tb.innerHTML=''; (d.items||[]).forEach(t=>{ const tr=document.createElement('tr'); tr.innerHTML=`<td>${t.id}</td><td>${t.name}</td><td>${t.created_at}</td><td><div class='btn-group btn-group-sm'><button class='btn btn-outline-secondary' onclick='APP.tplEdit(${t.id})'>Tahrir</button><button class='btn btn-outline-danger' onclick='APP.tplDel(${t.id})'>O‘chirish</button></div></td>`; tb.appendChild(tr); }); }
  function tplOpen(){ $('#tplId').value=''; $('#tplName').value=''; $('#availBox').innerHTML=''; $('#selBox').innerHTML=''; buildAvailTokens(); new bootstrap.Modal($('#modalTpl')).show(); }
  async function tplEdit(id){ const d=await j('api/index.php?r=templates&a=get&id='+id); $('#tplId').value=d.id; $('#tplName').value=d.name; $('#availBox').innerHTML=''; $('#selBox').innerHTML=''; buildAvailTokens(); (d.items||[]).forEach(it=>tplAddSel(it.key||'', it.label||it.key||'')); new bootstrap.Modal($('#modalTpl')).show(); }
  function tplDel(id){ confirmAsk('O‘chirish','Shablon o‘chirilsinmi?', async ()=>{ await j('api/index.php?r=templates&a=delete',{method:'POST',body:JSON.stringify({id})}); msg('OK','O‘chirildi'); tplLoad(); }); }
  function buildAvailTokens(){ const base=['shop_name','address','region_name','latitude','longitude','status','created_at']; const box=$('#availBox'); base.forEach(k=>{ const btn=document.createElement('button'); btn.type='button'; btn.className='btn btn-sm btn-outline-secondary me-2 mb-2'; btn.textContent=k; btn.onclick=()=>tplAddSel(k,k); box.appendChild(btn); }); j('api/index.php?r=fields&a=list').then(d=>{ (d.items||[]).forEach(f=>{ const k='field:'+f.id; const btn=document.createElement('button'); btn.type='button'; btn.className='btn btn-sm btn-outline-secondary me-2 mb-2'; btn.textContent=k; btn.onclick=()=>tplAddSel(k, f.label); box.appendChild(btn); }); const files=['signature_staff','signature_shop','image','audio','video']; files.forEach(k=>{ const btn=document.createElement('button'); btn.type='button'; btn.className='btn btn-sm btn-outline-secondary me-2 mb-2'; btn.textContent=k; btn.onclick=()=>tplAddSel(k,k); box.appendChild(btn); }); }); }
  function tplAddSel(key,label){ const row=document.createElement('div'); row.className='input-group mb-2'; row.innerHTML=`<span class='input-group-text'>${key}</span><input class='form-control' value='${label.replace(\"'\",\"&#39;")}'><button class='btn btn-outline-secondary' type='button' onclick='this.parentNode.parentNode.insertBefore(this.parentNode, this.parentNode.previousElementSibling)'>⬆️</button><button class='btn btn-outline-secondary' type='button' onclick='let n=this.parentNode.nextElementSibling; if(n) n.parentNode.insertBefore(n,this.parentNode)'>⬇️</button><button class='btn btn-outline-danger' type='button' onclick='this.parentNode.remove()'>–</button>`; $('#selBox').appendChild(row); }
  async function tplSave(){ const id=parseInt($('#tplId').value||0); const name=$('#tplName').value.trim(); if(!name) return msg('Shablon','Nomi kerak'); const items=[...$('#selBox').querySelectorAll('.input-group')].map(g=>({key:g.children[0].textContent.trim(), label:g.children[1].value.trim()||g.children[0].textContent.trim()})); const url='api/index.php?r=templates&a='+(id?'update':'save'); await j(url,{method:'POST',body:JSON.stringify({id,name,items})}); msg('OK','Saqlandi'); document.querySelector('#modalTpl .btn-close').click(); tplLoad(); }

  // ===== Logs page =====
  async function logLoad(page){ st.logPage=page||1; const q=$('#logQ')?$('#logQ').value.trim():''; const d=await j('api/index.php?r=logs&a=list&page='+st.logPage+'&size='+st.logSize+'&q='+encodeURIComponent(q)); const tb=$('#logBody'); if(!tb) return; tb.innerHTML=''; (d.items||[]).forEach(l=>{ const tr=document.createElement('tr'); tr.innerHTML=`<td>${l.id}</td><td>${l.created_at}</td><td>${l.username||''}</td><td>${l.action}</td><td>${l.entity}</td><td>${l.entity_id}</td><td><code class='small'>${(l.details||'').slice(0,120)}</code></td><td>${l.ip||''}</td>`; tb.appendChild(tr); }); const total=d.total||0; const txt=`${((st.logPage-1)*st.logSize)+1}–${Math.min(st.logPage*st.logSize,total)} / jami ${total}`; const r1=$('#logRange'); const r2=$('#logRange2'); if(r1) r1.textContent=txt; if(r2) r2.textContent=txt; }
  function logPrev(){ if(st.logPage>1) logLoad(st.logPage-1); }
  function logNext(){ logLoad(st.logPage+1); }

  return { // expose
    msg, confirmAsk, __confirmYes:null,
    // dashboard
    loadKPIs, loadAuditStream,
    // common
    loadRegions, loadEquipment, loadFields, loadContracts, previewSelected, exportSelected, printOne,
    // modal lifecycle & save
    onContractShown, onContractHidden, saveContract,
    // media
    startCam, snapCam, stopCam, sigClear, sigSave, initSign, initMap,
    // regions
    regLoad, regOpen, regEdit, regSave, regDel,
    // equipment
    eqLoad, eqOpen, eqEdit, eqSave, eqDel,
    // users
    userLoad, userPrev, userNext, userOpen, userEdit, userSave, userDel,
    // templates
    tplLoad, tplOpen, tplEdit, tplDel, tplSave,
    // logs
    logLoad, logPrev, logNext,
    get page(){ return st.page; }
  };
})();
}