(function(){
  function Sig(el){ this.cv=el; this.ct=el.getContext('2d'); this.drawing=false; this.scale=window.devicePixelRatio||1; this.resize(); this.bind(); this.stamped=false; }
  Sig.prototype.resize=function(){ const r=this.cv.getBoundingClientRect(); this.cv.width=r.width*this.scale; this.cv.height=r.height*this.scale; this.ct.setTransform(this.scale,0,0,this.scale,0,0); this.ct.lineWidth=2; this.ct.lineCap='round'; this.ct.strokeStyle='#222'; this.clear(); }
  Sig.prototype.clear=function(){ this.ct.fillStyle='#fff'; this.ct.fillRect(0,0,this.cv.width,this.cv.height); this.stamped=false; }
  Sig.prototype.bind=function(){ const self=this; const pos=(e)=>{ const r=self.cv.getBoundingClientRect(); if(e.touches&&e.touches[0]) return {x:e.touches[0].clientX-r.left,y:e.touches[0].clientY-r.top}; return {x:e.clientX-r.left,y:e.clientY-r.top}; };
    const down=(e)=>{ e.preventDefault(); self.drawing=true; const p=pos(e); self.ct.beginPath(); self.ct.moveTo(p.x,p.y); };
    const move=(e)=>{ if(!self.drawing) return; e.preventDefault(); const p=pos(e); self.ct.lineTo(p.x,p.y); self.ct.stroke(); };
    const up=()=>{ self.drawing=false; };
    self.cv.addEventListener('mousedown',down); self.cv.addEventListener('mousemove',move); self.cv.addEventListener('mouseup',up);
    self.cv.addEventListener('touchstart',down,{passive:false}); self.cv.addEventListener('touchmove',move,{passive:false}); self.cv.addEventListener('touchend',up);
    window.addEventListener('resize',()=>self.resize());
  };
  Sig.prototype.toDataURL=function(){ if(!this.stamped){ const ts=new Date().toISOString().slice(0,19).replace('T',' '); this.ct.fillStyle='rgba(0,128,0,.9)'; this.ct.font='12px sans-serif'; this.ct.fillText('Imzolandi: '+ts, 8, this.cv.height/this.scale - 8); this.stamped=true; } return this.cv.toDataURL('image/png'); };
  window.SigPad=Sig;
})();