<?php
// ===== App & DB =====
define('APP_NAME','Contracts Platform');
define('DB_HOST','localhost');
define('DB_USER','root');
define('DB_PASS','');
define('DB_NAME','contracts_public_v32');

define('UPLOAD_DIR', __DIR__.'/uploads');
define('LOG_DIR', __DIR__.'/storage/logs');

if(session_status()===PHP_SESSION_NONE) session_start();
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// ===== Helpers =====
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES|ENT_SUBSTITUTE,'UTF-8'); }
function json_out($arr,$code=200){ http_response_code($code); header('Content-Type: application/json; charset=utf-8'); echo json_encode($arr, JSON_UNESCAPED_UNICODE); exit; }
function log_line($msg){ if(!is_dir(LOG_DIR)) @mkdir(LOG_DIR,0775,true); @file_put_contents(LOG_DIR.'/app.log','['.date('Y-m-d H:i:s').'] '.$msg.PHP_EOL, FILE_APPEND); }
function base_href_tag(){
  $proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? '';
  $dir = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
  echo '<base href="'.$proto.'://'.$host.$dir.'/">';
}

function db(){
  static $db=null; if($db) return $db;
  $db = new mysqli(DB_HOST, DB_USER, DB_PASS);
  $db->set_charset('utf8mb4');
  $db->query("CREATE DATABASE IF NOT EXISTS `".DB_NAME."` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
  $db->select_db(DB_NAME);

  // Schema
  $db->query("CREATE TABLE IF NOT EXISTS users(
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(64) UNIQUE,
    pass_hash VARCHAR(255),
    full_name VARCHAR(160),
    phone VARCHAR(40),
    is_admin TINYINT(1) DEFAULT 0,
    permissions_json TEXT
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $db->query("CREATE TABLE IF NOT EXISTS regions(
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(160) NOT NULL,
    latitude DECIMAL(10,6) DEFAULT NULL,
    longitude DECIMAL(10,6) DEFAULT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $db->query("CREATE TABLE IF NOT EXISTS equipment(
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(160) NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $db->query("CREATE TABLE IF NOT EXISTS form_fields(
    id INT AUTO_INCREMENT PRIMARY KEY,
    label VARCHAR(160) NOT NULL,
    type ENUM('text','number','date','textarea','select','checkbox','camera') DEFAULT 'text',
    options_json TEXT,
    required TINYINT(1) DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    sort_order INT DEFAULT 0
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $db->query("CREATE TABLE IF NOT EXISTS contracts(
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(40),
    staff_id INT,
    shop_name VARCHAR(200),
    region_id INT,
    address VARCHAR(255),
    latitude DECIMAL(10,6),
    longitude DECIMAL(10,6),
    status ENUM('draft','submitted','approved','rejected') DEFAULT 'submitted',
    editable_by_staff TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $db->query("CREATE TABLE IF NOT EXISTS contract_fields(
    id INT AUTO_INCREMENT PRIMARY KEY,
    contract_id INT,
    field_id INT,
    value TEXT
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $db->query("CREATE TABLE IF NOT EXISTS contract_equipment(
    id INT AUTO_INCREMENT PRIMARY KEY,
    contract_id INT,
    equipment_id INT,
    qty INT
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $db->query("CREATE TABLE IF NOT EXISTS contract_files(
    id INT AUTO_INCREMENT PRIMARY KEY,
    contract_id INT,
    kind VARCHAR(40),
    path VARCHAR(255),
    mime VARCHAR(160),
    size INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $db->query("CREATE TABLE IF NOT EXISTS audit_log(
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    action VARCHAR(40),
    entity VARCHAR(40),
    entity_id INT,
    details TEXT,
    ip VARCHAR(64),
    ua VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  // Seed admin
  $cnt = $db->query("SELECT COUNT(*) c FROM users")->fetch_assoc()['c'] ?? 0;
  if((int)$cnt===0){
    $ph = password_hash('admin123', PASSWORD_DEFAULT);
    $st = $db->prepare("INSERT INTO users(username, pass_hash, full_name, is_admin, permissions_json) VALUES ('admin', ?, 'Super Admin', 1, ?)");
    $perms = json_encode([
      'can_create_contract'=>true,
      'can_export'=>true,
      'auto_record_audio'=>true,
      'require_two_signatures'=>false,
      'allow_staff_edit_after_submit'=>false
    ], JSON_UNESCAPED_UNICODE);
    $st->bind_param('ss',$ph,$perms); $st->execute();
  }
  return $db;
}

function auth_required(){
  if(!isset($_SESSION['uid'])){ header('Location: login.php'); exit; }
}
function is_admin(){ return (int)($_SESSION['is_admin']??0)===1; }
function perms(){ static $p=null; if($p!==null) return $p; $p = json_decode($_SESSION['permissions_json'] ?? '{}', true) ?: []; return $p; }
function perm($key,$default=false){ $p=perms(); return array_key_exists($key,$p) ? (bool)$p[$key] : (bool)$default; }

function audit($action,$entity,$entity_id,$detailsArr=[]){
  $db=db(); $uid=(int)($_SESSION['uid']??0); $ip=$_SERVER['REMOTE_ADDR']??''; $ua=$_SERVER['HTTP_USER_AGENT']??'';
  $det=json_encode($detailsArr, JSON_UNESCAPED_UNICODE);
  $st=$db->prepare("INSERT INTO audit_log(user_id,action,entity,entity_id,details,ip,ua) VALUES (?,?,?,?,?,?,?)");
  $st->bind_param('ississs',$uid,$action,$entity,$entity_id,$det,$ip,$ua);
  $st->execute();
}
