<?php require_once __DIR__.'/config.php'; auth_required(); ?>
<!doctype html><html lang="uz"><head><?php base_href_tag(); ?>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Shartnomalar — <?=h(APP_NAME)?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" rel="stylesheet"/>
<link href="assets/css/style.css" rel="stylesheet">
</head><body>
<?php include __DIR__.'/partials_nav.php'; ?>

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">Shartnomalar</h4>
    <div class="d-flex gap-2">
      <select id="tplSelect" class="form-select form-select-sm" style="width:auto"><option value="">— Shablon —</option></select>
      <button class="btn btn-outline-secondary btn-sm" onclick="APP.previewSelected()">Print (tanlangan)</button>
      <div class="btn-group">
        <button class="btn btn-outline-secondary btn-sm" onclick="APP.exportSelected('csv')">CSV</button>
        <button class="btn btn-outline-secondary btn-sm" onclick="APP.exportSelected('txt')">TXT</button>
        <button class="btn btn-outline-secondary btn-sm" onclick="APP.exportSelected('xls')">XLS</button>
        <button class="btn btn-outline-secondary btn-sm" onclick="APP.exportSelected('doc')">DOC</button>
      </div>
      <?php if(perm('can_create_contract',true)): ?>
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalContract">+ Shartnoma</button>
      <?php endif; ?>
    </div>
  </div>

  <div class="card shadow-sm border-0">
    <div class="card-body bg-light">
      <form id="filterForm" class="row g-2 mb-3" onsubmit="event.preventDefault(); APP.loadContracts(1)">
        <div class="col-md-3"><input class="form-control" name="q" placeholder="Qidirish (do‘kon/kod)"></div>
        <div class="col-md-2">
          <select class="form-select" name="status">
            <option value="">Barcha status</option>
            <option>draft</option><option>submitted</option><option>approved</option><option>rejected</option>
          </select>
        </div>
        <div class="col-md-2"><button class="btn btn-outline-primary w-100">Filter</button></div>
        <div class="col-md-5 text-end"><span id="rangeTxt" class="text-muted small"></span></div>
      </form>

      <div class="table-responsive">
        <table class="table table-sm align-middle table-fixed">
          <thead><tr><th>#</th><th>ID</th><th>Kod</th><th>Do‘kon</th><th>Viloyat</th><th>Status</th><th>Vaqt</th><th style="width:180px"></th></tr></thead>
          <tbody id="contracts_tbody"></tbody>
        </table>
      </div>
      <div class="d-flex justify-content-between align-items-center">
        <div><button class="btn btn-outline-secondary" id="prevC">Orqaga</button> <button class="btn btn-outline-secondary" id="nextC">Keyingi</button></div>
        <div class="text-muted small" id="rangeC2"></div>
      </div>
    </div>
  </div>
</div>

<!-- Contract Modal -->
<div class="modal fade" id="modalContract" tabindex="-1"><div class="modal-dialog modal-xl modal-fullscreen-md-down modal-dialog-scrollable">
  <div class="modal-content">
    <div class="modal-header bg-white"><h5 class="modal-title text-primary">Shartnoma</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body">
      <form id="contractForm" onsubmit="event.preventDefault();" class="row g-3">
        <div class="col-md-4"><label class="form-label">Do‘kon nomi</label><input name="shop_name" class="form-control" required></div>
        <div class="col-md-4"><label class="form-label">Viloyat</label><select id="regionSelect" name="region_id" class="form-select" required></select></div>
        <div class="col-md-4"><label class="form-label">Manzil</label><input name="address" class="form-control" required></div>

        <div class="col-12">
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">GPS</label>
              <div class="input-group">
                <input name="latitude" class="form-control" placeholder="lat" required>
                <input name="longitude" class="form-control" placeholder="lng" required>
                <button class="btn btn-outline-secondary" type="button" onclick="APP.initMap()">Xarita</button>
              </div>
              <div class="form-text">Xaritadan tanlang — lat/lng avtomatik to‘ladi.</div>
            </div>
            <div class="col-md-6"><div id="miniMap" class="border rounded" style="height:260px;"></div></div>
          </div>
        </div>

        <div class="col-12"><hr><h6>Shartnoma ma’lumotlari (dinamik)</h6><div id="dynFields" class="row g-3"></div></div>
        <div class="col-12"><hr><h6>Jihozlar (nom + soni)</h6><div id="equipWrap" class="row g-2"></div></div>

        <div class="col-12"><hr><h6>Media</h6>
          <div class="row g-3">
            <div class="col-md-4"><label class="form-label">Rasm(lar)</label><input type="file" accept="image/*" capture="environment" multiple class="form-control" id="imgInput"><div class="mt-2 d-flex gap-2 flex-wrap" id="imgPreview"></div></div>
            <div class="col-md-4"><label class="form-label">Video(lar)</label><input type="file" accept="video/*" capture multiple class="form-control" id="vidInput"><div class="mt-2 d-flex gap-2 flex-wrap" id="vidPreview"></div></div>
            <div class="col-md-4"><label class="form-label">Fayl(lar)</label><input type="file" multiple class="form-control" id="fileInput"><div class="mt-2 d-flex gap-2 flex-wrap" id="filePreview"></div></div>
          </div>
        </div>

        <div class="col-12"><hr><h6>Audio yozuv (avtomatik)</h6>
          <div class="d-flex align-items-center gap-3">
            <div class="eq-bars" aria-label="Recording"><span></span><span></span><span></span><span></span><span></span></div>
            <small class="text-muted">Modal ochilishi bilan yozadi; saqlaganda/yopilganda to‘xtaydi.</small>
          </div>
          <audio id="audioPrev" controls class="mt-2" style="display:none"></audio>
        </div>

        <div class="col-12"><hr><h6>Imzolar</h6>
          <div class="row g-3">
            <div class="col-12 col-lg-6"><label class="form-label">1) Zavod hodimi imzosi</label><canvas id="sigStaff" class="border rounded w-100" height="180" style="background:#fff; touch-action:none"></canvas><div class="mt-2 d-flex gap-2"><button type="button" class="btn btn-sm btn-outline-secondary" onclick="APP.sigClear('staff')">Tozalash</button><button type="button" class="btn btn-sm btn-outline-dark" onclick="APP.sigSave('staff')">Saqlash</button></div><div class="mt-2" id="sigPrevStaff"></div></div>
            <div class="col-12 col-lg-6"><label class="form-label">2) Do‘kon hodimi imzosi</label><canvas id="sigShop" class="border rounded w-100" height="180" style="background:#fff; touch-action:none"></canvas><div class="mt-2 d-flex gap-2"><button type="button" class="btn btn-sm btn-outline-secondary" onclick="APP.sigClear('shop')">Tozalash</button><button type="button" class="btn btn-sm btn-outline-dark" onclick="APP.sigSave('shop')">Saqlash</button></div><div class="mt-2" id="sigPrevShop"></div></div>
          </div>
        </div>
      </form>
    </div>
    <div class="modal-footer bg-white"><div class="me-auto small text-success" id="saveMeta"></div><button class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button><button type="button" class="btn btn-primary" onclick="APP.saveContract()">Saqlash va yuborish</button></div>
  </div>
</div></div>

<!-- Read-only modal -->
<div class="modal fade" id="modalRead" tabindex="-1"><div class="modal-dialog modal-xl modal-fullscreen-md-down modal-dialog-scrollable">
  <div class="modal-content">
    <div class="modal-header"><h5 class="modal-title">Shartnoma ma’lumotlari</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
    <div class="modal-body" id="readBody">Yuklanmoqda...</div>
  </div>
</div></div>

<!-- Confirm & Msg modals -->
<div class="modal fade" id="confirmModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content">
  <div class="modal-header"><h5 class="modal-title">Tasdiqlash</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
  <div class="modal-body">...</div>
  <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Bekor</button><button class="btn btn-danger" data-bs-dismiss="modal" onclick="APP.__confirmYes && APP.__confirmYes()">Ha, davom</button></div>
</div></div></div>
<div class="modal fade modal-msg" id="msgModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content">
  <div class="modal-header"><h5 class="modal-title">Xabar</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
  <div class="modal-body">...</div>
  <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button></div>
</div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="assets/js/signature.js"></script>
<script src="assets/js/app.js"></script>
<script>
document.getElementById('prevC').onclick=()=>{ APP.loadContracts(Math.max(1,(APP.page||1)-1)); };
document.getElementById('nextC').onclick=()=>{ APP.loadContracts((APP.page||1)+1); };
document.getElementById('modalContract').addEventListener('shown.bs.modal', ()=>{ APP.onContractShown(); });
document.getElementById('modalContract').addEventListener('hidden.bs.modal', ()=>{ APP.onContractHidden(); });
document.addEventListener('DOMContentLoaded', async ()=>{
  await APP.loadRegions(); await APP.loadEquipment(); await APP.loadFields(); await APP.loadContracts(1);
  fetch('api/index.php?r=templates&a=list').then(r=>r.json()).then(d=>{ const sel=document.getElementById('tplSelect'); (d.items||[]).forEach(t=>{ const o=document.createElement('option'); o.value=t.id; o.textContent=t.name; sel.appendChild(o); }); });
});
</script>
</body></html>
