<?php
// public/transport.php — Transport kod va Xtrace aggregatsiya
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth_stub.php';

session_start();
?>
<!DOCTYPE html>
<html lang="uz">
<head>
  <meta charset="UTF-8">
  <title>Transport – SSCC20 & Xtrace aggregatsiya</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- FontAwesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <!-- Toastr -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">

  <style>
    :root {
      --brand-main: #0d47a1;
      --brand-soft: #e5edff;
      --brand-accent: #22c55e;
      --bg-soft: #f3f4f8;
      --card-bg: rgba(255,255,255,0.96);
      --border-soft: #d1d9e6;
      --text-main: #0b1220;
      --text-muted: #6b7280;
      --danger-soft: #fee2e2;
      --danger: #dc2626;
    }

    body {
      min-height: 100vh;
      margin: 0;
      background: radial-gradient(circle at top left, #c7d2fe 0, transparent 45%),
                  radial-gradient(circle at bottom right, #bfdbfe 0, transparent 45%),
                  #eef2ff;
      color: var(--text-main);
    }

    .page-wrapper {
      max-width: 1200px;
      margin: 0 auto;
    }

    .navbar {
      background: rgba(13,71,161,0.96);
      backdrop-filter: blur(10px);
      box-shadow: 0 10px 25px rgba(15,23,42,0.35);
    }
    .navbar-brand, .navbar-nav .nav-link, .navbar-text {
      color: #fff !important;
    }
    .navbar-nav .nav-link {
      font-size: 0.92rem;
      opacity: 0.9;
    }
    .navbar-nav .nav-link.active {
      opacity: 1;
      font-weight: 600;
      border-bottom: 2px solid #fff;
    }

    .card {
      border-radius: 18px;
      box-shadow: 0 16px 40px rgba(15,23,42,0.08);
      border: 1px solid rgba(148,163,184,0.35);
      background: var(--card-bg);
    }

    .pill-heading {
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.1em;
      color: var(--text-muted);
    }

    .form-label {
      font-weight: 600;
      color: var(--text-main);
    }

    .filter-pill {
      background: #f1f5f9;
      border-radius: 999px;
      padding: 0.25rem 0.75rem;
      font-size: 0.78rem;
      color: #64748b;
    }

    .table thead {
      background: #eff3ff;
      font-size: 0.88rem;
    }
    .table tbody tr {
      font-size: 0.86rem;
      transition: background 0.12s ease, border-left-color 0.12s ease;
    }
    .table tbody tr:hover {
      background: #f9fafb;
    }
    .row-error {
      background: var(--danger-soft) !important;
      border-left: 4px solid var(--danger) !important;
    }

    .status-pill {
      border-radius: 999px;
      font-size: 0.75rem;
      padding: 0.15rem 0.6rem;
      font-weight: 500;
    }
    .status-tasdiqlangan {
      background: #dcfce7;
      color: #166534;
    }
    .status-qoralama {
      background: #e0e7ff;
      color: #4338ca;
    }
    .status-bekor {
      background: #fee2e2;
      color: #b91c1c;
    }

    .agg-ok {
      color: #16a34a;
    }
    .agg-error {
      color: #dc2626;
    }
    .agg-progress {
      color: #f97316;
    }

    .loading-overlay {
      position: fixed;
      inset: 0;
      background: rgba(255,255,255,0.7);
      display: none;
      align-items: center;
      justify-content: center;
      z-index: 9999;
      backdrop-filter: blur(4px);
    }
    .loading-overlay.show {
      display: flex;
    }

    .thumb-img {
      width: 72px;
      height: 72px;
      object-fit: contain;   /* butunni ko‘rsatadi, kesmaydi */
      border-radius: 10px;
      border: 1px solid #e5e7eb;
      background: #fff;
      cursor: zoom-in;
    }

    .details-img {
      max-width: 100%;
      max-height: 80vh;
      object-fit: contain;
      border-radius: 16px;
      border: 1px solid #e5e7eb;
      background: #fff;
    }

    .codes-box {
      max-height: 220px;
      overflow-y: auto;
      padding: 6px 8px;
      border-radius: 8px;
      border: 1px solid #e5e7eb;
      background: #f9fafb;
    }

    @media (max-width: 767.98px) {
      .page-wrapper {
        padding-inline: 0.4rem;
      }
    }
  </style>
</head>
<body>

<?php
  $active = 'transport';
  require __DIR__ . '/navbar.php';
?>

<!-- GLOBAL LOADING -->
<div class="loading-overlay" id="global-loading">
  <div class="text-center">
    <div class="spinner-border text-primary mb-2"></div>
    <div class="text-muted small">Iltimos, kuting...</div>
  </div>
</div>

<div class="page-wrapper">
  <div class="py-4">

    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-3">
      <div>
        <h3 class="mb-1">Transport – SSCC20 va Xtrace aggregatsiya</h3>
        <div class="text-muted">
          Tasdiqlangan sotuvlar bo‘yicha transport kod generatsiya qilinadi va Xtrace’ga aggregatsiya yuboriladi.
        </div>
      </div>
      <div class="mt-2 mt-md-0">
        <span class="badge bg-primary-subtle text-primary">
          <i class="fa-solid fa-truck-fast me-1"></i> 1 mijozga 1 ta SSCC20
        </span>
      </div>
    </div>

    <!-- FILTER CARD -->
    <div class="card mb-3">
      <div class="card-body">
        <div class="pill-heading mb-3">Filter va qidiruv</div>
        <form id="filter-form" class="row g-3 align-items-end">
          <div class="col-md-4">
            <label class="form-label" for="search">Mijoz / viloyat / shahar</label>
            <input type="text" id="search" class="form-control" placeholder="Begimxon / Farg‘ona ...">
          </div>
          <div class="col-md-2">
            <label class="form-label" for="status-filter">Status</label>
            <select id="status-filter" class="form-select">
              <option value="tasdiqlangan" selected>Tasdiqlangan</option>
              <option value="qoralama">Qoralama</option>
              <option value="bekor">Bekor</option>
              <option value="">Barchasi</option>
            </select>
          </div>
          <div class="col-md-2">
            <label class="form-label" for="per-page">Sahifa hajmi</label>
            <select id="per-page" class="form-select">
              <option value="10">10</option>
              <option value="20" selected>20</option>
              <option value="50">50</option>
              <option value="100">100</option>
            </select>
          </div>
          <div class="col-md-4 d-flex flex-wrap justify-content-md-end gap-2">
            <button type="button" class="btn btn-outline-secondary btn-sm" id="btn-reset-filter">
              Reset
            </button>
            <button type="submit" class="btn btn-primary btn-sm" id="btn-apply-filter">
              <span class="spinner-border spinner-border-sm d-none" id="filter-spinner"></span>
              <span>Qidirish</span>
            </button>
          </div>
        </form>
      </div>
    </div>

    <!-- TABLE CARD -->
    <div class="card">
      <div class="card-body">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-2 gap-2">
          <div>
            <div class="pill-heading mb-1">Sotuvlar</div>
            <h5 class="mb-0">Tasdiqlangan matnli sotuvlar ro‘yxati</h5>
          </div>
          <div class="filter-pill" id="list-info">
            Sahifa 1/1, jami 0 ta
          </div>
        </div>

        <div class="table-responsive" id="sales-table-wrapper">
          <table class="table table-hover align-middle" id="sales-table">
            <thead>
            <tr>
              <th>#</th>
              <th>Mijoz</th>
              <th>Sana</th>
              <th>Status</th>
              <th>SSCC20</th>
              <th>Xtrace holati</th>
              <th>Amallar</th>
            </tr>
            </thead>
            <tbody>
            <tr>
              <td colspan="7" class="text-center py-3 text-muted">
                Ma’lumot yuklanmoqda...
              </td>
            </tr>
            </tbody>
          </table>
        </div>

        <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mt-3 gap-2">
          <div class="d-flex flex-wrap gap-2">
            <div class="btn-group btn-group-sm" id="export-buttons">
              <button type="button" class="btn btn-outline-secondary" data-format="csv">
                <i class="fa-solid fa-file-csv"></i> CSV
              </button>
              <button type="button" class="btn btn-outline-secondary" data-format="xls">
                <i class="fa-solid fa-file-excel"></i> XLS
              </button>
              <button type="button" class="btn btn-outline-secondary" data-format="xlsx">
                <i class="fa-solid fa-file-excel"></i> XLSX
              </button>
              <button type="button" class="btn btn-outline-secondary" data-format="doc">
                <i class="fa-solid fa-file-word"></i> DOC
              </button>
              <button type="button" class="btn btn-outline-secondary" data-format="pdf">
                <i class="fa-solid fa-file-pdf"></i> PDF
              </button>
              <button type="button" class="btn btn-outline-secondary" data-format="png">
                <i class="fa-solid fa-image"></i> PNG
              </button>
              <button type="button" class="btn btn-outline-secondary" data-format="jpg">
                <i class="fa-regular fa-image"></i> JPG
              </button>
            </div>
          </div>
          <nav>
            <ul class="pagination pagination-sm mb-0" id="pagination">
              <!-- JS render -->
            </ul>
          </nav>
        </div>

      </div>
    </div>

  </div>
</div>

<!-- Sotuv batafsil MODAL -->
<div class="modal fade" id="detailModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content" id="detailContent">
      <div class="modal-header">
        <h5 class="modal-title">Sotuv tafsilotlari</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div id="detail-main" class="mb-3"></div>
        <hr>
        <div id="detail-items"></div>
      </div>
      <div class="modal-footer">
        <div class="me-auto d-flex flex-wrap gap-2">
          <button type="button" class="btn btn-outline-secondary btn-sm" onclick="exportSaleDetails('csv')">CSV</button>
          <button type="button" class="btn btn-outline-secondary btn-sm" onclick="exportSaleDetails('xls')">XLS</button>
          <button type="button" class="btn btn-outline-secondary btn-sm" onclick="exportSaleDetails('xlsx')">XLSX</button>
          <button type="button" class="btn btn-outline-secondary btn-sm" onclick="exportSaleDetails('doc')">DOC</button>
          <button type="button" class="btn btn-outline-secondary btn-sm" onclick="exportSaleDetails('pdf')">PDF</button>
          <button type="button" class="btn btn-outline-secondary btn-sm" onclick="exportSaleDetails('png')">PNG</button>
          <button type="button" class="btn btn-outline-secondary btn-sm" onclick="exportSaleDetails('jpg')">JPG</button>
        </div>
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Yopish</button>
      </div>
    </div>
  </div>
</div>

<!-- Aggregatsiya tasdiqlash MODAL -->
<div class="modal fade" id="aggConfirmModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Transport kod va aggregatsiya</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="agg-confirm-message">
        Bu sotuv uchun SSCC20 generatsiya qilinib, Xtrace’ga aggregatsiya hujjati yuborilsinmi?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Bekor qilish</button>
        <button type="button" class="btn btn-primary btn-sm" id="agg-confirm-yes">
          <span class="spinner-border spinner-border-sm d-none" id="agg-spinner"></span>
          <span>Ha, yuborish</span>
        </button>
      </div>
    </div>
  </div>
</div>

<!-- Xtrace status MODAL -->
<div class="modal fade" id="statusModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content" id="statusContent">
      <div class="modal-header">
        <h5 class="modal-title">Xtrace hujjat statusi</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="status-body">
        <!-- JS bilan to‘ldiriladi -->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Yopish</button>
      </div>
    </div>
  </div>
</div>

<!-- Rasm preview MODAL -->
<div class="modal fade" id="imagePreviewModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Mahsulot rasmi</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body text-center">
        <img id="imagePreviewImg" src="" alt="Mahsulot rasmi" class="details-img img-fluid">
      </div>
    </div>
  </div>
</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<script>
  const apiUrl = 'api.php'; // kerak bo'lsa: 'api/api.php'

  toastr.options = {
    positionClass: "toast-top-right",
    timeOut: 3000
  };

  let currentPage = 1;
  let perPage     = 20;
  let total       = 0;
  let totalPages  = 1;
  let currentSaleDetails = null;
  let aggSaleId   = null;

  function showGlobalLoading(show) {
    const el = document.getElementById('global-loading');
    if (show) el.classList.add('show');
    else      el.classList.remove('show');
  }

  function escapeHtml(str) {
    if (!str) return '';
    return String(str)
      .replace(/&/g, "&amp;")
      .replace(/</g, "&lt;")
      .replace(/>/g, "&gt;")
      .replace(/"/g, "&quot;")
      .replace(/'/g, "&#039;");
  }

  $(function () {
    $('#filter-form').on('submit', function(e){
      e.preventDefault();
      currentPage = 1;
      loadSales();
    });

    $('#btn-reset-filter').on('click', function(){
      $('#search').val('');
      $('#status-filter').val('tasdiqlangan');
      $('#per-page').val('20');
      currentPage = 1;
      perPage     = 20;
      loadSales();
    });

    $('#per-page').on('change', function(){
      perPage = parseInt($(this).val(), 10) || 20;
      currentPage = 1;
      loadSales();
    });

    // Export tugmalari
    $('#export-buttons').on('click', 'button[data-format]', function(){
      const fmt = $(this).data('format');
      exportSales(fmt);
    });

    // Tafsilot tugmasi
    $(document).on('click', '.btn-detail', function(){
      const id = $(this).data('id');
      openDetailModal(id);
    });

    // Status tugmasi
    $(document).on('click', '.btn-check-status', function(){
      const id = $(this).data('id');
      checkAggStatus(id, $(this).closest('tr'));
    });

    // Transport kod (aggregatsiya) tugmasi
    $(document).on('click', '.btn-generate', function(){
      const id = $(this).data('id');
      aggSaleId = id;
      $('#agg-confirm-message').text(
        'Bu sotuv uchun SSCC20 generatsiya qilinib, Xtrace’ga aggregatsiya hujjati yuborilsinmi?'
      );
      $('#agg-spinner').addClass('d-none');
      $('#agg-confirm-yes').prop('disabled', false);
      const m = new bootstrap.Modal(document.getElementById('aggConfirmModal'));
      m.show();
    });

    // Agg tasdiqlash Ha
    $('#agg-confirm-yes').on('click', function(){
      if (!aggSaleId) return;
      sendAggregation(aggSaleId);
    });

    // Rasmga bosilganda kattaroq preview
    $(document).on('click', '.details-thumb, .thumb-img', function(){
      const src = $(this).attr('src');
      if (!src) return;
      $('#imagePreviewImg').attr('src', src);
      const m = new bootstrap.Modal(document.getElementById('imagePreviewModal'));
      m.show();
    });

    loadSales();
  });

  function getFilters() {
    return {
      search: $('#search').val().trim(),
      status: $('#status-filter').val()
    };
  }

  function loadSales() {
    const f = getFilters();
    showGlobalLoading(true);

    $.getJSON(apiUrl, {
      action: 'list_sales',
      page:   currentPage,
      per_page: perPage,
      search: f.search,
      status: f.status
    }).done(function(res){
      showGlobalLoading(false);
      if (res.status !== 'ok') {
        toastr.error(res.message || 'Sotuvlar ro‘yxatida xato');
        return;
      }
      const rows = res.rows || [];
      total      = res.total || 0;
      currentPage= res.page  || 1;
      perPage    = res.per_page || perPage;
      totalPages = Math.max(1, Math.ceil(total / perPage));

      renderSalesTable(rows);
      renderPagination();
      renderInfo();
    }).fail(function(){
      showGlobalLoading(false);
      toastr.error('Tarmoq xatosi (list_sales)');
    });
  }

  function renderSalesTable(rows) {
    const $tb = $('#sales-table tbody');
    $tb.empty();

    if (!rows.length) {
      $tb.append(
        '<tr><td colspan="7" class="text-center py-3 text-muted">Ma’lumot topilmadi</td></tr>'
      );
      return;
    }

    rows.forEach(function(row, idx){
      const index = (currentPage - 1) * perPage + idx + 1;
      const status = (row.status || '').toString();
      let statusClass = '';
      if (status === 'tasdiqlangan') statusClass = 'status-tasdiqlangan';
      else if (status === 'qoralama') statusClass = 'status-qoralama';
      else if (status === 'bekor') statusClass = 'status-bekor';

      const sscc = row.sscc20 || '';
      const docId = row.agg_doc_id || '';

      let aggHtml = '<span class="text-muted small">Yuborilmagan</span>';
      if (docId) {
        aggHtml = `
          <div class="small text-muted">
            ID: <code>${escapeHtml(docId)}</code>
          </div>
          <div class="badge bg-secondary-subtle text-secondary badge-pill-info">
            Hujjat statusini "Status" tugmasi orqali tekshiring
          </div>
        `;
      }

      const tr = $(`
        <tr data-id="${row.id}">
          <td>${index}</td>
          <td>
            <div class="fw-semibold">${escapeHtml(row.customer_name || '')}</div>
            <div class="small text-muted">
              ${(row.region || '')} ${(row.city ? (', ' + row.city) : '')}
            </div>
          </td>
          <td>${escapeHtml(row.created_at || '')}</td>
          <td>
            <span class="status-pill ${statusClass}">
              ${escapeHtml(status || '-')}
            </span>
          </td>
          <td><code>${escapeHtml(sscc)}</code></td>
          <td>${aggHtml}</td>
          <td>
            <div class="btn-group btn-group-sm">
              <button type="button" class="btn btn-outline-info btn-detail" data-id="${row.id}">
                Tafsilot
              </button>
              <button type="button" class="btn btn-outline-primary btn-check-status"
                      data-id="${row.id}" ${docId ? '' : 'disabled'}>
                Status
              </button>
              <button type="button" class="btn btn-success btn-generate"
                      data-id="${row.id}" ${docId ? 'disabled' : ''}>
                Transport kod
              </button>
            </div>
          </td>
        </tr>
      `);

      $tb.append(tr);
    });
  }

  function renderPagination() {
    const $pg = $('#pagination');
    $pg.empty();
    if (totalPages <= 1) return;

    function add(label, page, disabled) {
      const li = $(`
        <li class="page-item ${disabled ? 'disabled':''}">
          <a class="page-link" href="#">${label}</a>
        </li>
      `);
      li.on('click', function(e){
        e.preventDefault();
        if (!disabled) {
          currentPage = page;
          loadSales();
        }
      });
      $pg.append(li);
    }

    add('«', currentPage-1, currentPage <= 1);
    $pg.append(`
      <li class="page-item disabled">
        <span class="page-link">Sahifa ${currentPage}/${totalPages}</span>
      </li>
    `);
    add('»', currentPage+1, currentPage >= totalPages);
  }

  function renderInfo() {
    if (!total) {
      $('#list-info').text('Ma’lumot topilmadi');
      return;
    }
    const from = (currentPage - 1) * perPage + 1;
    const to   = Math.min(total, currentPage * perPage);
    $('#list-info').text(`Ko‘rsatilmoqda: ${from}–${to} / Jami: ${total}`);
  }

  function openDetailModal(saleId) {
    showGlobalLoading(true);
    $.getJSON(apiUrl, { action:'get_sale_detail', sale_id:saleId })
      .done(function(res){
        showGlobalLoading(false);
        if (res.status !== 'ok') {
          toastr.error(res.message || 'Sotuv tafsilotida xato');
          return;
        }
        const sale  = res.sale || {};
        const items = res.items || [];
        currentSaleDetails = { sale, items };

        let htmlMain = `
          <div class="row g-2 mb-2">
            <div class="col-md-4">
              <div class="small text-muted">Mijoz</div>
              <div class="fw-semibold">${escapeHtml(sale.customer_name || '')}</div>
              <div class="small text-muted">
                ${escapeHtml((sale.region || '') + (sale.city ? ', '+sale.city : ''))}
              </div>
            </div>
            <div class="col-md-3">
              <div class="small text-muted">Sana</div>
              <div>${escapeHtml(sale.created_at || '')}</div>
            </div>
            <div class="col-md-2">
              <div class="small text-muted">Status</div>
              <div>${escapeHtml(sale.status || '')}</div>
            </div>
            <div class="col-md-3">
              <div class="small text-muted">SSCC20</div>
              <div><code>${escapeHtml(sale.sscc20 || '-')}</code></div>
            </div>
          </div>
        `;
        if (sale.agg_doc_id) {
          htmlMain += `
            <div class="mt-2">
              <span class="small text-muted">Xtrace hujjat ID:</span>
              <code>${escapeHtml(sale.agg_doc_id)}</code>
            </div>
          `;
        }
        $('#detail-main').html(htmlMain);

        if (!items.length) {
          $('#detail-items').html(
            '<div class="text-muted small">Mahsulotlar topilmadi</div>'
          );
        } else {
          // === Mahsulotlarni product_id bo‘yicha birlashtirish ===
          const groupsMap = {};
          let totalCodes = 0;

          items.forEach(function(it){
            const pid = it.product_id || 0;
            if (!groupsMap[pid]) {
              groupsMap[pid] = {
                product_id: pid,
                product_name: it.product_name || '',
                product_gtin: it.product_gtin || '',
                product_image: it.product_image || '',
                codes: []
              };
            }
            const codeVal = it.gs1_code || '';
            if (codeVal) {
              groupsMap[pid].codes.push(codeVal);
              totalCodes++;
            }
          });

          const groups = Object.values(groupsMap);

          let t = `
            <div class="d-flex justify-content-between align-items-center mb-2">
              <div class="fw-semibold">
                Mahsulotlar (${groups.length} tur) – DataMatrix kodlar jami: ${totalCodes} ta
              </div>
              <div class="small text-muted">
                Har bir mahsulot qatorida <strong>“DataMatrix kodlar (N ta)”</strong> tugmasi orqali barcha kodlarni ko‘rishingiz mumkin.
              </div>
            </div>
            <div class="table-responsive">
              <table class="table table-sm align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>#</th>
                    <th>Mahsulot</th>
                    <th>GTIN</th>
                    <th>Rasm</th>
                    <th>DataMatrix kodlar</th>
                  </tr>
                </thead>
                <tbody>
          `;

          groups.forEach(function(g, idx){
            const imgFile = g.product_image || '';
            let imgHtml = '<span class="text-muted small">Yo‘q</span>';
            if (imgFile) {
              const src = '/mark2/' + imgFile;
              imgHtml = `<img src="${src}" class="thumb-img details-thumb" alt="rasm">`;
            }

            // Har bir mahsulot uchun unikal collapse id
            const groupId = `codesGroup_${sale.id}_${g.product_id || ('p'+(idx+1))}`;

            t += `
              <tr>
                <td>${idx+1}</td>
                <td>${escapeHtml(g.product_name || '')}</td>
                <td><code>${escapeHtml(g.product_gtin || '')}</code></td>
                <td>${imgHtml}</td>
                <td>
                  <button class="btn btn-link btn-sm p-0" type="button"
                          data-bs-toggle="collapse" data-bs-target="#${groupId}">
                    DataMatrix kodlar (${g.codes.length} ta)
                  </button>
                  <div class="collapse mt-1" id="${groupId}">
                    <div class="codes-box small">
                      ${g.codes.map(c => `<div><code>${escapeHtml(c || '')}</code></div>`).join('')}
                    </div>
                  </div>
                </td>
              </tr>
            `;
          });

          t += `
                </tbody>
              </table>
            </div>
          `;
          $('#detail-items').html(t);
        }

        const m = new bootstrap.Modal(document.getElementById('detailModal'));
        m.show();
      })
      .fail(function(){
        showGlobalLoading(false);
        toastr.error('Tarmoq xatosi (get_sale_detail)');
      });
  }

  function sendAggregation(saleId) {
    $('#agg-spinner').removeClass('d-none');
    $('#agg-confirm-yes').prop('disabled', true);

    $.post(apiUrl, { action:'generate_transport_code', sale_id:saleId }, function(res){
      $('#agg-spinner').addClass('d-none');
      $('#agg-confirm-yes').prop('disabled', false);

      if (res.status !== 'ok') {
        toastr.error(res.message || 'Aggregatsiya xatosi');
        if (res.data && res.data.raw) {
          console.log('Xtrace raw:', res.data.raw);
        }
        return;
      }

      const sscc  = res.sscc20 || '';
      const docId = res.document_id || '';

      toastr.success('Transport kod va aggregatsiya yuborildi');

      const m = bootstrap.Modal.getInstance(document.getElementById('aggConfirmModal'));
      if (m) m.hide();

      loadSales();

      let html = `
        <div class="mb-2">
          <div class="small text-muted">Sotuv ID:</div>
          <div class="fw-semibold">${saleId}</div>
        </div>
        <div class="mb-2">
          <div class="small text-muted">SSCC20:</div>
          <div><code>${escapeHtml(sscc)}</code></div>
        </div>
        <div class="mb-2">
          <div class="small text-muted">Xtrace hujjat ID:</div>
          <div><code>${escapeHtml(docId)}</code></div>
        </div>
        <div class="alert alert-info small">
          Hujjat holatini "Status" tugmasi orqali tekshirishingiz mumkin.
        </div>
      `;
      $('#status-body').html(html);
      const sm = new bootstrap.Modal(document.getElementById('statusModal'));
      sm.show();

    }, 'json').fail(function(){
      $('#agg-spinner').addClass('d-none');
      $('#agg-confirm-yes').prop('disabled', false);
      toastr.error('Tarmoq xatosi (generate_transport_code)');
    });
  }

  function checkAggStatus(saleId, $row) {
    showGlobalLoading(true);
    $.getJSON(apiUrl, { action:'check_agg_status', sale_id:saleId })
      .done(function(res){
        showGlobalLoading(false);
        if (res.status !== 'ok') {
          toastr.error(res.message || 'Status tekshirishda xato');
          return;
        }
        const st    = res.status_raw || {};
        const text  = res.status_text || '';
        const errs  = res.errors_list || [];

        let colorClass = 'agg-progress';
        if (text.includes('xatolar')) colorClass = 'agg-error';
        else if (text.includes('qayta ishlangan')) colorClass = 'agg-ok';

        let html = `
          <div class="mb-2">
            <div class="small text-muted">Sotuv ID:</div>
            <div class="fw-semibold">${res.sale_id}</div>
          </div>
          <div class="mb-2">
            <div class="small text-muted">Hujjat ID:</div>
            <div><code>${escapeHtml(res.document_id || '')}</code></div>
          </div>
          <div class="mb-2">
            <div class="small text-muted">Holat:</div>
            <div class="${colorClass} fw-semibold">${escapeHtml(text || '-')}</div>
          </div>
        `;

        if (errs.length) {
          html += `
            <div class="mt-2">
              <div class="small text-muted mb-1">Xatolar:</div>
              <ul class="small text-danger">
          `;
          errs.forEach(function(e){
            html += `<li>${escapeHtml(e)}</li>`;
          });
          html += '</ul></div>';

          if ($row && $row.length) {
            $row.addClass('row-error');
          }
        } else {
          if ($row && $row.length) {
            $row.removeClass('row-error');
          }
        }

        html += `
          <hr>
          <div class="small text-muted">Xtrace’dan qaytgan to‘liq JSON:</div>
          <pre style="white-space:pre-wrap;font-size:0.75rem;background:#f9fafb;border-radius:8px;padding:8px;border:1px solid #e5e7eb;">
${escapeHtml(JSON.stringify(st, null, 2))}
          </pre>
        `;

        $('#status-body').html(html);
        const m = new bootstrap.Modal(document.getElementById('statusModal'));
        m.show();

      }).fail(function(){
        showGlobalLoading(false);
        toastr.error('Tarmoq xatosi (check_agg_status)');
      });
  }

  // ——— Umumiy jadval export (csv/xls/xlsx/doc/pdf/png/jpg) ———

  function exportSales(format) {
    const f = getFilters();

    if (format === 'pdf' || format === 'png' || format === 'jpg') {
      exportTableAsImageOrPdf(format);
      return;
    }

    $.getJSON(apiUrl, {
      action: 'list_sales',
      page:   1,
      per_page: 100000,
      search: f.search,
      status: f.status
    }).done(function(res){
      if (res.status !== 'ok') {
        toastr.error(res.message || 'Exportda xato');
        return;
      }
      const rows = res.rows || [];
      if (!rows.length) {
        toastr.info('Export uchun ma’lumot yo‘q');
        return;
      }

      const csv = buildSalesCsv(rows);
      const now = new Date();
      const y = now.getFullYear();
      const m = String(now.getMonth()+1).padStart(2,'0');
      const d = String(now.getDate()).padStart(2,'0');

      const extMap = {csv:'csv', xls:'xls', xlsx:'xlsx', doc:'doc'};
      const ext = extMap[format] || 'csv';
      const filename = `transport_sales_${y}${m}${d}.${ext}`;
      downloadTextFile(csv, filename);
    }).fail(function(){
      toastr.error('Exportda server xatosi');
    });
  }

  function buildSalesCsv(rows) {
    const header = [
      'ID','Mijoz','Viloyat/shahar','Sana','Status',
      'SSCC20','XtraceDocID'
    ];
    const lines = [];
    lines.push(header.join(';'));

    rows.forEach(function(r){
      lines.push([
        r.id,
        (r.customer_name || '').replace(/;/g, ','),
        ((r.region || '') + (r.city ? ', '+r.city : '')).replace(/;/g, ','),
        r.created_at || '',
        r.status || '',
        (r.sscc20 || '').replace(/;/g, ','),
        (r.agg_doc_id || '').replace(/;/g, ',')
      ].join(';'));
    });

    return lines.join('\r\n');
  }

  function downloadTextFile(content, filename) {
    const blob = new Blob([content], { type:'text/csv;charset=utf-8;' });
    const url  = URL.createObjectURL(blob);
    const a    = document.createElement('a');
    a.href = url;
    a.download = filename;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
  }

  function exportTableAsImageOrPdf(format) {
    const el = document.getElementById('sales-table-wrapper');
    if (!el) return;

    html2canvas(el).then(canvas => {
      if (format === 'pdf') {
        const { jsPDF } = window.jspdf;
        const imgData   = canvas.toDataURL('image/png');
        const pdf       = new jsPDF('l','pt',[canvas.width,canvas.height]);
        pdf.addImage(imgData, 'PNG', 0, 0, canvas.width, canvas.height);
        pdf.save('transport_sales.pdf');
      } else {
        const mime = format === 'jpg' ? 'image/jpeg' : 'image/png';
        canvas.toBlob(function(blob){
          const url = URL.createObjectURL(blob);
          const a   = document.createElement('a');
          a.href = url;
          a.download = 'transport_sales.' + (format === 'jpg' ? 'jpg' : 'png');
          document.body.appendChild(a);
          a.click();
          document.body.removeChild(a);
          URL.revokeObjectURL(url);
        }, mime);
      }
    });
  }

  // ——— Bitta sotuvni modalda export qilish ———

  function exportSaleDetails(format) {
    if (!currentSaleDetails) {
      toastr.error('Sotuv tanlanmagan');
      return;
    }

    const sale  = currentSaleDetails.sale  || {};
    const items = currentSaleDetails.items || [];

    if (format === 'pdf' || format === 'png' || format === 'jpg') {
      const el = document.getElementById('detailContent');
      html2canvas(el).then(canvas => {
        if (format === 'pdf') {
          const { jsPDF } = window.jspdf;
          const imgData   = canvas.toDataURL('image/png');
          const pdf       = new jsPDF('p','pt',[canvas.width,canvas.height]);
          pdf.addImage(imgData, 'PNG', 0, 0, canvas.width, canvas.height);
          pdf.save('sale_'+sale.id+'_detail.pdf');
        } else {
          const mime = format === 'jpg' ? 'image/jpeg' : 'image/png';
          canvas.toBlob(function(blob){
            const url = URL.createObjectURL(blob);
            const a   = document.createElement('a');
            a.href    = url;
            a.download= 'sale_'+sale.id+'_detail.'+(format === 'jpg' ? 'jpg' : 'png');
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            URL.revokeObjectURL(url);
          }, mime);
        }
      });
      return;
    }

    const header = [
      'SaleID','Mijoz','Viloyat/shahar','Sana','Status',
      'SSCC20','XtraceDocID'
    ];
    const metaLine = [
      sale.id,
      (sale.customer_name || '').replace(/;/g, ','),
      ((sale.region || '') + (sale.city ? ', '+sale.city : '')).replace(/;/g, ','),
      sale.created_at || '',
      sale.status || '',
      (sale.sscc20 || '').replace(/;/g, ','),
      (sale.agg_doc_id || '').replace(/;/g, ',')
    ];

    const lines = [];
    lines.push(header.join(';'));
    lines.push(metaLine.join(';'));
    lines.push('');
    lines.push('Item#;Mahsulot;GTIN;GS1_text');

    items.forEach(function(it, idx){
      lines.push([
        idx+1,
        (it.product_name || '').replace(/;/g, ','),
        (it.product_gtin || '').replace(/;/g, ','),
        (it.gs1_code || '').replace(/;/g, ',')
      ].join(';'));
    });

    const csv = lines.join('\r\n');
    const extMap = {csv:'csv', xls:'xls', xlsx:'xlsx', doc:'doc'};
    const ext = extMap[format] || 'csv';
    const filename = `sale_${sale.id}_detail.${ext}`;
    downloadTextFile(csv, filename);
  }

  // global
  window.exportSaleDetails = exportSaleDetails;
</script>
</body>
</html>
