<?php
require_once __DIR__ . '/../config.php';
require_admin();

function earned_rule($approved,$target,$amount,$calc,$minp,$allow){
  if($target<=0 || $amount<=0) return 0;
  $pct = $approved / $target;
  if(!$allow) $pct = min(1.0, $pct);
  if($pct < $minp) return 0;
  if($calc==='threshold') return ($pct>=1.0)?$amount:0;
  return (int)round($amount*$pct);
}

$db = contracts_db();
mysqli_set_charset($db, 'utf8mb4');             // <-- juda muhim
$db->query("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");
$db->query("SET time_zone = '+05:00'");


$ym=$_GET['ym'] ?? date('Y-m'); $dept=trim($_GET['dept']??''); $region=trim($_GET['region']??''); $q=trim($_GET['q']??''); $op=(int)($_GET['op']??0);
$db=db(); $where="WHERE active=1"; if($op>0) $where.=" AND id=".$op;
if($dept!==''){ $d=$db->real_escape_string($dept); $where.=" AND department LIKE '%$d%'"; }
if($region!==''){ $r=$db->real_escape_string($region); $where.=" AND region LIKE '%$r%'"; }
if($q!==''){ $qq=$db->real_escape_string($q); $where.=" AND (name LIKE '%$qq%' OR code LIKE '%$qq%')"; }

$ops=[]; $r=$db->query("SELECT * FROM operators $where ORDER BY name ASC"); while($x=$r->fetch_assoc()) $ops[]=$x;

$st=$db->prepare("SELECT * FROM operator_monthly_metrics WHERE ym=?"); $st->bind_param("s",$ym); $st->execute(); $rr=$st->get_result(); $mm=[]; while($row=$rr->fetch_assoc()) $mm[(int)$row['operator_id']]=$row; $st->close();

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="payroll_'.$ym.'.csv"');
$out=fopen('php://output','w');
fputcsv($out,['code','name','department','region','base_amount','base_confirmed','dynamic_bonus','other_bonus','gross','penalties','net','admin_finalized','operator_signed']);

foreach($ops as $o){
  $m=$mm[$o['id']]??['ym'=>$ym];
  $base_amount    = isset($m['base_amount'])?(int)$m['base_amount']:1500000;
  $base_confirmed = (int)($m['base_confirmed']??0);
  $base           = $base_confirmed ? $base_amount : 0;
  $penalties      = (int)($m['late_minutes']??0)*300 + (int)($m['absent_days']??0)*100000 +
                    (int)($m['bad_comm_count']??0)*30000 + (int)($m['missing_info_count']??0)*20000 +
                    (int)($m['other_penalty']??0);

  $ap=[]; $qr=$db->query("SELECT item_id, COUNT(*) c FROM kpi_submissions WHERE operator_id=".$o['id']." AND ym='".$db->real_escape_string($ym)."' AND status='approved' GROUP BY item_id");
  while($x=$qr->fetch_assoc()){ $ap[(int)$x['item_id']] = (int)$x['c']; }

  $dyn=0;
  $qi=$db->query("SELECT i.id,i.target_int,i.reward_amount,i.reward_calc,i.reward_min_pct,i.reward_allow_over
                  FROM kpi_items i JOIN kpi_plans p ON p.id=i.plan_id JOIN kpi_assignments a ON a.plan_id=p.id AND a.operator_id=".$o['id']." WHERE p.ym='".$db->real_escape_string($ym)."'");
  while($it=$qi->fetch_assoc()){
    $dyn += earned_rule(($ap[(int)$it['id']]??0),(int)$it['target_int'],(int)$it['reward_amount'],($it['reward_calc']??'proportional'),(float)($it['reward_min_pct']??0.0),!empty($it['reward_allow_over'])?1:0);
  }

  $other = (int)($m['other_bonus']??0);
  $gross = $base + $dyn + $other;
  $net   = max(0, $gross - $penalties);
  fputcsv($out,[$o['code'],$o['name'],$o['department'],$o['region'],$base_amount,$base_confirmed,$dyn,$other,$gross,$penalties,$net,(int)($m['admin_finalized']??0),(int)($m['operator_signed']??0)]);
}
fclose($out); exit;
