<?php
require_once __DIR__ . '/../config.php';

$db = contracts_db();
mysqli_set_charset($db, 'utf8mb4');
@$db->query("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");
@$db->query("SET time_zone = '+05:00'");
date_default_timezone_set('Asia/Tashkent');

if (!function_exists('json_out')) {
  function json_out($data, $code=200){
    http_response_code($code);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
  }
}
function jerr($msg, $detail=null, $code=400){ $p=['ok'=>false,'error'=>$msg]; if($detail!==null)$p['detail']=$detail; json_out($p,$code); }
function ensure_upload_dir($dir){ if (is_dir($dir)) return true; return @mkdir($dir, 0775, true); }

if (!defined('PUBLIC_DIR')) {
  // /public katalogingiz boshqacha bo‘lsa, shu yerni moslang
  define('PUBLIC_DIR', realpath(__DIR__ . '/..') . '/public');
}
if (!defined('UPLOAD_DIR')) {
  define('UPLOAD_DIR', PUBLIC_DIR . '/uploads');
}

function within_uploads($relPath){
  if (!$relPath) return false;
  // relPath odatda '/uploads/...' bo‘ladi
  $abs  = rtrim(PUBLIC_DIR, '/') . '/' . ltrim($relPath, '/');
  $real = realpath($abs);
  $root = realpath(UPLOAD_DIR);
  if(!$real || !$root) return false;
  // faqat uploads ichida bo‘lsa true
  return str_starts_with($real, $root);
}

$u = current_user();
if (!$u) { http_response_code(403); echo "Auth kerak"; exit; }
$role = $u['role'] ?? '';

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$action = $_GET['action'] ?? '';

// -------- ADMIN: imzoni rad qilish --------
// POST /api/signoff.php?action=admin_reject
// BODY: { ym: 'YYYY-MM', operator_id: 123, reason?: '...' }
if ($method === 'POST' && $action === 'admin_reject') {
  if ($role !== 'admin') jerr('Ruxsat yo‘q (admin kerak)', null, 403);

  $in = json_decode(file_get_contents('php://input'), true);
  if (!is_array($in)) jerr('Bad JSON');
  $ym   = $in['ym'] ?? date('Y-m');
  $opId = (int)($in['operator_id'] ?? 0);
  $reason = $in['reason'] ?? '';

  if (!$opId || !$ym) jerr('ym va operator_id shart');

  // Avval eski imzo faylini o‘chiramiz (agar bor bo‘lsa)
  $st = $db->prepare("SELECT operator_signature_path FROM operator_monthly_metrics WHERE operator_id=? AND ym=?");
  $st->bind_param("is", $opId, $ym);
  if(!$st->execute()) jerr('DB error', $db->error, 500);
  $ex = $st->get_result()->fetch_assoc();
  $st->close();

  if ($ex && !empty($ex['operator_signature_path']) && within_uploads($ex['operator_signature_path'])) {
    @unlink(rtrim(PUBLIC_DIR,'/').'/'.ltrim($ex['operator_signature_path'],'/'));
  }

  // DB: imzo maydonlarini tozalaymiz
  $q = $db->prepare("UPDATE operator_monthly_metrics 
                     SET operator_signed=0, operator_signature_path=NULL, operator_signed_at=NULL
                     WHERE operator_id=? AND ym=?");
  if(!$q) jerr('DB prepare error', $db->error, 500);
  $q->bind_param("is", $opId, $ym);
  if(!$q->execute()) jerr('DB update error', $db->error, 500);

  // (ixtiyoriy) rad sababini loglash uchun qo‘shimcha ustunlaringiz bo‘lsa shu yerda saqlang
  // $db->query("UPDATE operator_monthly_metrics SET sig_rejected=1, sig_reject_reason='".$db->real_escape_string($reason)."' WHERE operator_id=$opId AND ym='".$db->real_escape_string($ym)."'");

  json_out(['ok'=>true]);
  exit;
}

// -------- OPERATOR API’lari (status/sign/clear) --------
if ($role !== 'operator') { http_response_code(403); echo "Operator kerak"; exit; }
$op_id = (int)($u['operator_id'] ?? 0);
if ($op_id <= 0) { http_response_code(403); echo "Operator kerak"; exit; }

// GET: status
if ($method === 'GET' && ($action === '' || !isset($_GET['action']))) {
  $ym = $_GET['ym'] ?? date('Y-m');
  $st = $db->prepare("SELECT admin_finalized, admin_finalized_at, operator_signed, operator_signature_path, operator_signed_at 
                      FROM operator_monthly_metrics WHERE operator_id=? AND ym=? LIMIT 1");
  $st->bind_param("is", $op_id, $ym);
  if (!$st->execute()) jerr('DB error', $db->error, 500);
  $m = $st->get_result()->fetch_assoc();
  $st->close();
  if (!$m) $m = ['admin_finalized'=>0,'admin_finalized_at'=>null,'operator_signed'=>0,'operator_signature_path'=>null,'operator_signed_at'=>null];
  json_out(['ok'=>true,'ym'=>$ym,'status'=>$m]);
}

// POST: sign (canvas dataURL)
if ($method === 'POST' && $action === 'sign') {
  $in = json_decode(file_get_contents('php://input'), true);
  if (!is_array($in)) jerr('Bad JSON');
  $ym = $in['ym'] ?? date('Y-m');
  $dataURL = $in['dataURL'] ?? null;
  if (!$dataURL || strpos($dataURL, 'data:image/png;base64,') !== 0) jerr('PNG dataURL kerak');

  $bin = base64_decode(substr($dataURL, strlen('data:image/png;base64,')));
  if (!$bin || strlen($bin) < 50) jerr('PNG noto‘g‘ri yoki juda kichik');

  // uploads/op_{id}/YYYY-MM
  $dir = rtrim(UPLOAD_DIR,'/')."/op_{$op_id}/{$ym}";
  if (!ensure_upload_dir($dir)) jerr('Upload papkasini yaratib bo‘lmadi', $dir, 500);

  // Eski imzoni o‘chirish (bor bo‘lsa)
  $st = $db->prepare("SELECT operator_signature_path FROM operator_monthly_metrics WHERE operator_id=? AND ym=?");
  $st->bind_param("is", $op_id, $ym);
  $st->execute();
  $ex = $st->get_result()->fetch_assoc();
  $st->close();

  $oldRel = $ex['operator_signature_path'] ?? null;
  if ($oldRel && within_uploads($oldRel)) {
    @unlink(rtrim(PUBLIC_DIR,'/').'/'.ltrim($oldRel,'/'));
  }

  // Unique fayl nomi
  try { $suffix = bin2hex(random_bytes(4)); } catch(Exception $e){ $suffix = uniqid(); }
  $fname = 'signature_' . time() . '_' . $suffix . '.png';
  $abs   = $dir . '/' . $fname;

  if (@file_put_contents($abs, $bin) === false || filesize($abs) < 50) jerr('Imzo faylini saqlab bo‘lmadi', $abs, 500);

  // Relativ /uploads/... yo‘l
  $rel = str_replace(rtrim(PUBLIC_DIR,'/'), '', $abs);
  if ($rel === $abs) {
    $rel = '/uploads/op_' . $op_id . '/' . $ym . '/' . $fname;
  }
  $now = date('Y-m-d H:i:s');

  // upsert
  $st = $db->prepare("SELECT id FROM operator_monthly_metrics WHERE operator_id=? AND ym=?");
  $st->bind_param("is", $op_id, $ym);
  $st->execute();
  $has = $st->get_result()->fetch_assoc();
  $st->close();

  if ($has) {
    $q = $db->prepare("UPDATE operator_monthly_metrics 
                       SET operator_signed=1, operator_signature_path=?, operator_signed_at=? 
                       WHERE operator_id=? AND ym=?");
    if(!$q) jerr('DB prepare error', $db->error, 500);
    $q->bind_param("ssis", $rel, $now, $op_id, $ym);
    if(!$q->execute()) jerr('DB update error', $db->error, 500);
  } else {
    $q = $db->prepare("INSERT INTO operator_monthly_metrics 
                       (operator_id,ym,operator_signed,operator_signature_path,operator_signed_at) 
                       VALUES (?,?,1,?,?)");
    if(!$q) jerr('DB prepare error', $db->error, 500);
    $q->bind_param("isss", $op_id, $ym, $rel, $now);
    if(!$q->execute()) jerr('DB insert error', $db->error, 500);
  }

  json_out(['ok'=>true, 'signature_path'=>$rel, 'signed_at'=>$now]);
}

// POST: clear (operator o‘chirish)
if ($method === 'POST' && $action === 'clear') {
  $in = json_decode(file_get_contents('php://input'), true);
  if (!is_array($in)) jerr('Bad JSON');
  $ym = $in['ym'] ?? date('Y-m');

  // Faylni o‘chirish
  $st = $db->prepare("SELECT operator_signature_path FROM operator_monthly_metrics WHERE operator_id=? AND ym=?");
  $st->bind_param("is", $op_id, $ym);
  $st->execute();
  $ex = $st->get_result()->fetch_assoc();
  $st->close();

  if ($ex && $ex['operator_signature_path'] && within_uploads($ex['operator_signature_path'])) {
    @unlink(rtrim(PUBLIC_DIR,'/').'/'.ltrim($ex['operator_signature_path'],'/'));
  }

  // DB ni tozalash
  $st = $db->prepare("UPDATE operator_monthly_metrics 
                      SET operator_signed=0, operator_signature_path=NULL, operator_signed_at=NULL 
                      WHERE operator_id=? AND ym=?");
  $st->bind_param("is", $op_id, $ym);
  if(!$st->execute()) jerr('DB update error', $db->error, 500);

  json_out(['ok'=>true]);
}

// Default
json_out(['ok'=>false,'error'=>'Method/action not allowed'], 405);
