<?php
require_once __DIR__ . '/../config.php';

header('Content-Type: application/json; charset=utf-8');
ini_set('default_charset', 'UTF-8');
mb_internal_encoding('UTF-8');
mb_http_output('UTF-8');
mb_regex_encoding('UTF-8');
date_default_timezone_set('Asia/Tashkent');

$db = contracts_db();
@$db->set_charset('utf8mb4');
@$db->query("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");
@$db->query("SET time_zone = '+05:00'");

if (!function_exists('json_out')) {
  function json_out($data, $code=200){
    http_response_code($code);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
  }
}
function json_bad($msg, $code=400){ json_out(['ok'=>false,'error'=>$msg], $code); }

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$action = $_GET['action'] ?? '';

/* ========= helpers ========= */
function cur_uid(){ return (int)(current_user()['operator_id'] ?? current_user()['id'] ?? 0); }
function norm($s){ return is_string($s)? trim($s):''; }
function ensure_dir($path){ return is_dir($path) ? is_writable($path) : @mkdir($path,0755,true); }
function has_col($db, $table, $col){
  $res = $db->query("SHOW COLUMNS FROM `".$db->real_escape_string($table)."` LIKE '".$db->real_escape_string($col)."'");
  return $res && $res->num_rows>0;
}
// Unicode-safe filename (kiril, raqam, bo'shliq, .-_ qoldiradi)
function safe_filename_u($name){
  $name = preg_replace('/[^\p{L}\p{N}\s\.\-_]+/u', '_', (string)$name);
  $name = preg_replace('/\s+/u', ' ', $name);
  $name = trim($name);
  return $name ?: ('file_'.time());
}

/* ========== CHECK (duplicate) ========== */
if ($method==='POST' && $action==='check'){
  $in = json_decode(file_get_contents('php://input'), true);
  if(!is_array($in)) json_bad('Bad JSON');

  $uid     = cur_uid();
  $ym      = norm($in['ym'] ?? '');
  $plan_id = (int)($in['plan_id'] ?? 0);
  $item_id = (int)($in['item_id'] ?? 0);
  $file_h  = norm($in['file_hash'] ?? '');
  $text_h  = norm($in['text_hash'] ?? '');

  if(!$uid || !$ym || !$item_id) json_bad('uid, ym, item_id shart');

  $cond = "operator_id=$uid AND ym='".$db->real_escape_string($ym)."' AND item_id=$item_id";

  $hasFile = has_col($db,'kpi_submissions','file_hash');
  $hasText = has_col($db,'kpi_submissions','text_hash');

  $hashParts = [];
  if ($hasFile && $file_h!=='') $hashParts[] = "file_hash='".$db->real_escape_string($file_h)."'";
  if ($hasText && $text_h!=='') $hashParts[] = "text_hash='".$db->real_escape_string($text_h)."'";
  if ($hashParts) $cond .= " AND (".implode(' OR ', $hashParts).")";

  $q = "SELECT id,status FROM kpi_submissions WHERE $cond ORDER BY id DESC LIMIT 1";
  $r = $db->query($q);
  if($r && $row=$r->fetch_assoc()){
    json_out(['ok'=>true,'exists'=>true,'status'=>$row['status'],'id'=>(int)$row['id']]);
  }
  json_out(['ok'=>true,'exists'=>false]);
}

/* ========== UPLOAD ========== */
if ($method==='POST' && $action==='upload'){
  // UTF-8 & TZ allaqachon o'rnatilgan — baribir set qilib qo'yamiz (idempotent)
  @$db->set_charset('utf8mb4');
  @$db->query("SET time_zone = '+05:00'");

  $uid     = cur_uid();
  $ym      = norm($_POST['ym'] ?? '');
  $plan_id = (int)($_POST['plan_id'] ?? 0);
  $item_id = (int)($_POST['item_id'] ?? 0);
  $text    = $_POST['text_content'] ?? '';
  $uname   = norm($_POST['username_ref'] ?? '');
  $fhash   = norm($_POST['file_hash'] ?? '');
  $thash   = norm($_POST['text_hash'] ?? '');

  if(!$uid || !$ym || !$item_id) json_bad('uid, ym, item_id shart');

  // --- Dublikat: pending/approved blok, rejected ruxsat
  $baseCond = "operator_id={$uid} AND ym='".$db->real_escape_string($ym)."' AND item_id={$item_id}";
  $hasFile  = has_col($db,'kpi_submissions','file_hash');
  $hasText  = has_col($db,'kpi_submissions','text_hash');
  $hashConds= [];
  if ($hasFile && $fhash!=='') $hashConds[] = "file_hash='".$db->real_escape_string($fhash)."'";
  if ($hasText && $thash!=='') $hashConds[] = "text_hash='".$db->real_escape_string($thash)."'";
  $cond = $baseCond . ($hashConds ? " AND (".implode(' OR ',$hashConds).")" : "");

  $q = "SELECT id,status FROM kpi_submissions WHERE {$cond} ORDER BY id DESC LIMIT 1";
  if (($r = $db->query($q)) && ($row = $r->fetch_assoc())) {
    if (in_array($row['status'], ['pending','approved'], true)) {
      json_bad('Dublikat: mavjud dalil '.$row['status'], 409);
    }
  }

  // --- Fayl saqlash (kiril nomlari barqaror, URL rawurlencode)
  $file_path=null; $file_mime=null; $file_size=null; $file_name_store=null;
  if (isset($_FILES['file']) && is_uploaded_file($_FILES['file']['tmp_name'])) {
    $ymDir = preg_replace('/[^0-9]/','', substr($ym,0,7)); // masalan 202509
    $base  = realpath(__DIR__.'/..')."/uploads/submissions/{$ymDir}/{$uid}";
    if (!ensure_dir($base)) json_bad('Upload katalogi yaratilmaydi', 500);

    $origName = $_FILES['file']['name'];                  // ko‘rsatish uchun foydali (kiril)
    $safeName = safe_filename_u($origName);               // xavfsiz nom (kirilni qoldiradi)
    $stored   = time().'_'.bin2hex(random_bytes(4)).'_'.$safeName;
    $dest     = $base.'/'.$stored;

    if (!@move_uploaded_file($_FILES['file']['tmp_name'], $dest)) {
      if (!@copy($_FILES['file']['tmp_name'], $dest)) json_bad('Fayl saqlanmadi', 500);
      @unlink($_FILES['file']['tmp_name']);
    }

    $file_path = '/oylik2/uploads/submissions/'.$ymDir.'/'.$uid.'/'.rawurlencode($stored);
    $file_mime = $_FILES['file']['type'] ?: 'application/octet-stream';
    $file_size = (int)($_FILES['file']['size'] ?? @filesize($dest));
    $file_name_store = $origName;                          // DBga asl nomni saqlaymiz (agar ustun bo‘lsa)
  }

  // --- Dinamik INSERT: mavjud ustunlarga qarab
  $cols = ['operator_id','ym','plan_id','item_id','text_content','username_ref','file_path','file_mime','file_size'];
  $vals = ['?','?','?','?','?','?','?','?','?'];
  $types= 'isiissssi';
  $args = [$uid,$ym,$plan_id,$item_id,$text,$uname,$file_path,$file_mime,$file_size];

  // ixtiyoriy ustunlar
  if ($hasFile) { $cols[]='file_hash'; $vals[]='?'; $types.='s'; $args[]=$fhash; }
  if ($hasText) { $cols[]='text_hash'; $vals[]='?'; $types.='s'; $args[]=$thash; }
  if (has_col($db,'kpi_submissions','file_name')) {
    $cols[]='file_name'; $vals[]='?'; $types.='s'; $args[]=$file_name_store;
  }
  if (has_col($db,'kpi_submissions','status')) {
    $cols[]='status'; $vals[]='?'; $types.='s'; $args[]='pending';
  }
  if (has_col($db,'kpi_submissions','created_at')) {
    // created_at alohida NOW() bilan
  }

  $sql = "INSERT INTO kpi_submissions (".implode(',',$cols). (has_col($db,'kpi_submissions','created_at') ? ',created_at' : '').")
          VALUES (".implode(',',$vals). (has_col($db,'kpi_submissions','created_at') ? ',NOW()' : '').")";

  $st = $db->prepare($sql);
  if(!$st) json_bad('DB prepare: '.$db->error,500);

  // bind_param variadic (references)
  $bind = [];
  $bind[] = $types;
  // references
  foreach($args as $k=>&$v){ $bind[] = &$v; }
  call_user_func_array([$st,'bind_param'],$bind);

  if(!$st->execute()) json_bad('DB exec: '.$st->error,500);

  json_out(['ok'=>true,'id'=>$st->insert_id]);
}

/* ========== LIST (operator uchun) ========== */
if($method==='GET' && $action==='list'){
  $uid = cur_uid();
  $ym  = norm($_GET['ym'] ?? '');
  if(!$uid) json_bad('auth kerak',401);

  $where = "WHERE s.operator_id={$uid}";
  if($ym!=='') $where .= " AND s.ym='".$db->real_escape_string($ym)."'";

  $rows=[];
  $q = "SELECT
          s.id,
          s.item_id,                -- frontdagi hisob-kitob uchun
          s.created_at,
          COALESCE(p.name,'')  AS plan_name,
          COALESCE(i.title,'') AS item_title,
          s.file_path,
          s.file_mime,
          s.text_content,
          s.username_ref,
          s.status
        FROM kpi_submissions s
        LEFT JOIN kpi_plans p ON p.id = s.plan_id
        LEFT JOIN kpi_items i ON i.id = s.item_id
        $where
        ORDER BY s.created_at DESC
        LIMIT 200";
  $r = $db->query($q);
  if(!$r){ json_bad('DB error: '.$db->error, 500); }
  while($x=$r->fetch_assoc()) $rows[]=$x;

  json_out(['ok'=>true,'rows'=>$rows]);
}

/* ========== UPDATE (pending bo‘lsa) ========== */
if($method==='POST' && $action==='update'){
  $in=json_decode(file_get_contents('php://input'),true);
  if(!is_array($in)) json_bad('Bad JSON');

  $uid = cur_uid();
  $id  = (int)($in['id'] ?? 0);
  $text= norm($in['text_content'] ?? '');
  $usr = norm($in['username_ref'] ?? '');
  if(!$uid || !$id) json_bad('id shart');

  // faqat o‘zining va faqat pending
  $r=$db->query("SELECT operator_id,status FROM kpi_submissions WHERE id=$id");
  if(!$r || !$r->num_rows) json_bad('Topilmadi',404);
  $row=$r->fetch_assoc();
  if((int)$row['operator_id']!==$uid) json_bad('Ruxsat yo‘q',403);
  if($row['status']!=='pending') json_bad('Pending emas',409);

  $st=$db->prepare("UPDATE kpi_submissions SET text_content=?, username_ref=? WHERE id=?");
  if(!$st) json_bad('DB prepare: '.$db->error,500);
  $st->bind_param("ssi",$text,$usr,$id);
  if(!$st->execute()) json_bad('DB exec: '.$st->error,500);
  json_out(['ok'=>true]);
}

// ... yuqori qismi avvalgidek ...

if ($method==='POST' && $action==='update_file'){
  mysqli_set_charset($db,'utf8mb4');
  $uid = (int)(current_user()['operator_id'] ?? current_user()['id'] ?? 0);
  $id  = (int)($_POST['id'] ?? 0);
  $ym  = trim($_POST['ym'] ?? '');
  $item_id = (int)($_POST['item_id'] ?? 0);
  $text = trim($_POST['text_content'] ?? '');
  $fhash= trim($_POST['file_hash'] ?? '');
  $thash= trim($_POST['text_hash'] ?? '');

  if(!$uid || !$id || !$ym) json_out(['ok'=>false,'error'=>'param yetarli emas'],400);

  // faqat o‘zining va pending bo‘lsa
  $r=$db->query("SELECT operator_id,status FROM kpi_submissions WHERE id=$id");
  if(!$r || !$r->num_rows) json_out(['ok'=>false,'error'=>'Topilmadi'],404);
  $row=$r->fetch_assoc();
  if((int)$row['operator_id']!==$uid) json_out(['ok'=>false,'error'=>'Ruxsat yo‘q'],403);
  if($row['status']!=='pending') json_out(['ok'=>false,'error'=>'Pending emas'],409);

  // dublikat (approved/pending blok)
  $hashParts=[];
  if($fhash!=='') $hashParts[]="file_hash='".$db->real_escape_string($fhash)."'";
  if($thash!=='') $hashParts[]="text_hash='".$db->real_escape_string($thash)."'";
  $cond="operator_id=$uid AND ym='".$db->real_escape_string($ym)."'";
  if($item_id>0) $cond.=" AND item_id=$item_id";
  if($hashParts) $cond.=" AND (".implode(' OR ',$hashParts).")";
  $q="SELECT id,status FROM kpi_submissions WHERE $cond ORDER BY id DESC LIMIT 1";
  if(($t=$db->query($q)) && ($x=$t->fetch_assoc())){
    if(in_array($x['status'],['pending','approved'],true)) json_out(['ok'=>false,'error'=>'Dublikat ('.$x['status'].')'],409);
  }

  // fayl saqlash
  $file_path=null; $file_mime=null; $file_size=null;
  if(isset($_FILES['file']) && is_uploaded_file($_FILES['file']['tmp_name'])){
    $ymDir = preg_replace('/[^0-9]/','', substr($ym,0,7));
    $base  = realpath(__DIR__.'/..')."/uploads/submissions/$ymDir/$uid";
    if(!is_dir($base)) @mkdir($base,0755,true);
    $origName = $_FILES['file']['name'];
    $safe = preg_replace('/[^\p{L}\p{N}\s\.\-_]+/u','_', $origName);
    $stored = time().'_'.bin2hex(random_bytes(4)).'_'.$safe;
    $dest = $base.'/'.$stored;
    if(!@move_uploaded_file($_FILES['file']['tmp_name'],$dest)){
      if(!@copy($_FILES['file']['tmp_name'],$dest)) json_out(['ok'=>false,'error'=>'Fayl saqlanmadi'],500);
      @unlink($_FILES['file']['tmp_name']);
    }
    $file_path = '/oylik2/uploads/submissions/'.$ymDir.'/'.$uid.'/'.rawurlencode($stored);
    $file_mime = $_FILES['file']['type'] ?: 'application/octet-stream';
    $file_size = (int)($_FILES['file']['size'] ?? @filesize($dest));
  }

  // yangilash
  $st=$db->prepare("UPDATE kpi_submissions SET text_content=?, file_path=?, file_mime=?, file_size=?, file_hash=?, text_hash=? WHERE id=?");
  if(!$st) json_out(['ok'=>false,'error'=>'DB prep: '.$db->error],500);
  $st->bind_param("sssissi", $text, $file_path, $file_mime, $file_size, $fhash, $thash, $id);
  if(!$st->execute()) json_out(['ok'=>false,'error'=>'DB exec: '.$st->error],500);

  json_out(['ok'=>true]);
}


json_bad('Unknown action',404);
