<?php
require_once __DIR__ . '/../config.php';
if (function_exists('require_admin')) require_admin();
elseif (function_exists('require_login')) require_login();
?>
<!doctype html>
<html lang="uz">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>CSV Import & Hisob</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.table-sticky thead th{position:sticky;top:0;background:#fff;z-index:2}
.code{font-family:ui-monospace,Menlo,Consolas,monospace}
.small-mono{font:12px ui-monospace,Menlo,Consolas,monospace;color:#6c757d}
.table-bordered td, .table-bordered th{border:1px solid #dee2e6 !important}
</style>
</head>
<body class="bg-light">
<!-- NAVBAR -->
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container">

    <div class="d-flex align-items-center gap-2 ms-auto">
        <a class="navbar-brand fw-bold" href="./dashboard.php">Oylik Hisob (Admin)</a>
    <ul class="navbar-nav ms-auto">
      <li class="nav-item"><a class="nav-link " href="./dashboard.php">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link" href="./operators.php">Operatorlar</a></li>
      <li class="nav-item"><a class="nav-link" href="./users.php">Foydalanuvchi (Operator)</a></li>
      <li class="nav-item"><a class="nav-link" href="./plans.php">Plan yaratish</a></li>
      <li class="nav-item"><a class="nav-link" href="./admin_review.php">Tekshirish</a></li>
      <li class="nav-item"><a class="nav-link" href="./operator_contracts.php">Shartnoma tayyorlash</a></li>
      <li class="nav-item"><a class="nav-link active" href="./attendance_calc.php">Keldi / Ketdi</a></li>
      <li class="nav-item"><a class="nav-link" href="./logout.php">Chiqish</a></li>
      <div class="text-white-50 small">Oy:</div>
      <input type="month" id="ymTop" class="form-control form-control-sm" value="<?php echo date('Y-m'); ?>">
      <label class="btn btn-outline-light btn-sm mb-0">
        CSV yuklash <input id="csvInput" type="file" accept=".csv" hidden>
      </label>
      <button class="btn btn-outline-light btn-sm" id="btnSettings">Sozlamalar</button>
    </div>
  </div>
</nav>

<div class="container my-3">
  <div id="alertBox"></div>
  <div class="row g-3">
    <!-- LEFT: Imports -->
    <div class="col-lg-4">
      <div class="card shadow-sm">
        <div class="card-header bg-light">Importlar</div>
        <div class="card-body p-2">
          <div class="table-responsive" style="max-height:520px">
            <table class="table table-sm table-hover table-bordered table-sticky" id="tblImports">
              <thead class="table-light"><tr><th>ID</th><th>Oy</th><th>Fayl</th><th>Vaqt</th><th></th></tr></thead>
              <tbody></tbody>
            </table>
          </div>
          <div class="small text-muted">CSV yuklagach, shu ro‘yxatdan ochiladi.</div>
        </div>
      </div>
    </div>

    <!-- RIGHT: Compute + Export -->
    <div class="col-lg-8">
      <div class="card shadow-sm">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
          <span>Oy bo‘yicha hisob</span>
          <div class="btn-group">
            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">Export (Jami)</button>
            <ul class="dropdown-menu dropdown-menu-end">
              <li><a class="dropdown-item" href="#" data-exp="csv">CSV</a></li>
              <li><a class="dropdown-item" href="#" data-exp="xls">Excel (XLS)</a></li>
              <li><a class="dropdown-item" href="#" data-exp="txt">TXT</a></li>
              <li><a class="dropdown-item" href="#" data-exp="doc">Word (DOC)</a></li>
              <li><a class="dropdown-item" href="#" data-exp="pdf">PDF (print)</a></li>
            </ul>
          </div>
        </div>
        <div class="card-body">
          <div class="row g-2 align-items-end mb-2">
            <div class="col-sm-4"><label class="form-label">Oy</label><input type="month" id="ym" class="form-control" value="<?php echo date('Y-m'); ?>"></div>
            <div class="col-sm-5"><label class="form-label">Qidirish</label><input id="q" class="form-control" placeholder="FIO / EmpCode / Bo‘lim"></div>
            <div class="col-sm-3 d-grid"><label class="form-label d-none d-sm-block">&nbsp;</label><button class="btn btn-primary" id="btnRun">Hisoblash</button></div>
          </div>

          <div class="table-responsive">
            <table class="table table-sm align-middle table-bordered table-sticky" id="tblCalc">
              <thead class="table-light"><tr>
                <th>ID</th><th>EmpCode</th><th>FIO</th><th>Bo‘lim</th>
                <th class="text-center">Kelgan kunlar</th><th class="text-center">Kelmagan kunlar</th>
                <th class="text-center">Kechikish (minut)</th><th class="text-center">Ish vaqti (soat)</th>
                <th class="text-end">Jarima</th><th class="text-end">Bonus</th><th class="text-end">Net</th>
                <th style="width:240px">Amal</th>
              </tr></thead>
              <tbody></tbody>
            </table>
          </div>

          <div class="d-flex justify-content-between align-items-center mt-2">
            <div class="text-muted small" id="sumInfo">0–0 / 0</div>
            <ul class="pagination pagination-sm mb-0" id="pager"></ul>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>

<!-- DETAIL MODAL -->
<div class="modal fade" id="detailModal" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-scrollable"><div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title">Kunlik hisob</h5>
      <div class="btn-group ms-auto">
        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">Export (Hodim)</button>
        <ul class="dropdown-menu dropdown-menu-end" id="empExportMenu">
          <li><a class="dropdown-item" href="#" data-exp="csv">CSV</a></li>
          <li><a class="dropdown-item" href="#" data-exp="xls">Excel (XLS)</a></li>
          <li><a class="dropdown-item" href="#" data-exp="txt">TXT</a></li>
          <li><a class="dropdown-item" href="#" data-exp="doc">Word (DOC)</a></li>
          <li><a class="dropdown-item" href="#" data-exp="pdf">PDF (print)</a></li>
        </ul>
      </div>
      <button class="btn-close ms-2" data-bs-dismiss="modal"></button>
    </div>
    <div class="modal-body" id="dBody"><div class="text-muted">Yuklanmoqda...</div></div>
  </div></div>
</div>

<!-- SETTINGS OFFCANVAS -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="settingsPanel">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title">Sozlamalar (Ish vaqti & Tariflar)</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body">
    <div class="small text-muted mb-2">Sozlamalar DB ga saqlanadi, hisob-kitobga darhol ta’sir qiladi.</div>
    <div class="card mb-3">
      <div class="card-header bg-light">Ish jadvali</div>
      <div class="card-body">
        <div class="row g-2">
          <div class="col-6"><div class="form-check"><input class="form-check-input" type="checkbox" id="sMon"><label class="form-check-label" for="sMon">Dushanba</label></div></div>
          <div class="col-6"><div class="form-check"><input class="form-check-input" type="checkbox" id="sTue"><label class="form-check-label" for="sTue">Seshanba</label></div></div>
          <div class="col-6"><div class="form-check"><input class="form-check-input" type="checkbox" id="sWed"><label class="form-check-label" for="sWed">Chorshanba</label></div></div>
          <div class="col-6"><div class="form-check"><input class="form-check-input" type="checkbox" id="sThu"><label class="form-check-label" for="sThu">Payshanba</label></div></div>
          <div class="col-6"><div class="form-check"><input class="form-check-input" type="checkbox" id="sFri"><label class="form-check-label" for="sFri">Juma</label></div></div>
          <div class="col-6"><div class="form-check"><input class="form-check-input" type="checkbox" id="sSat"><label class="form-check-label" for="sSat">Shanba</label></div></div>
          <div class="col-6"><div class="form-check"><input class="form-check-input" type="checkbox" id="sSun"><label class="form-check-label" for="sSun">Yakshanba</label></div></div>
        </div>
        <div class="row g-2 mt-2">
          <div class="col-4"><label class="form-label">Boshlanish</label><input type="time" id="sStart" class="form-control" value="09:00"></div>
          <div class="col-4"><label class="form-label">Tugash</label><input type="time" id="sEnd" class="form-control" value="18:00"></div>
          <div class="col-4"><label class="form-label">Tanaffus (minut)</label><input type="number" id="sBreak" class="form-control" value="0"></div>
        </div>
      </div>
    </div>

    <div class="card mb-3">
      <div class="card-header bg-light">Tariflar</div>
      <div class="card-body">
        <div class="row g-2">
          <div class="col-6"><label class="form-label">Jarima: kechikish (so‘m/minut)</label><input type="number" id="tLateMin" class="form-control" value="100"></div>
          <div class="col-6"><label class="form-label">Jarima: kelmagan (so‘m/kun)</label><input type="number" id="tAbsentDay" class="form-control" value="100000"></div>
          <div class="col-6"><label class="form-label">Bonus: ishlagan (so‘m/soat)</label><input type="number" id="tPresentHour" class="form-control" value="2000"></div>
          <div class="col-6"><label class="form-label">Bonus: o‘z vaqtida kelgan (so‘m/kun)</label><input type="number" id="tOntimeDay" class="form-control" value="5000"></div>
          <div class="col-12"><label class="form-label">Jarima: erta ketish (so‘m/minut)</label><input type="number" id="tEarlyLeave" class="form-control" value="100"></div>
        </div>
      </div>
    </div>

    <div class="d-grid gap-2">
      <button class="btn btn-primary" id="btnSaveSettings">Saqlash</button>
      <button class="btn btn-outline-secondary" id="btnReloadSettings">Yuklash</button>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
/* ===== Helpers ===== */
function esc(s){
  if (s === null || s === undefined) return '';
  try { return String(s).replace(/[&<>"']/g, m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;', "'":'&#39;'}[m])); }
  catch(_){ return ''; }
}
function show(msg,type){ const b=document.getElementById('alertBox'); b.innerHTML=`<div class="alert alert-${type||'info'}">${esc(msg)}</div>`; setTimeout(()=>b.innerHTML='',4000); }
async function fetchJSON(url,opts){ const r=await fetch(url,opts); const t=await r.text(); if(!r.ok) throw new Error(`HTTP ${r.status} ${r.statusText}: ${t.slice(0,300)}`); try{return JSON.parse(t);}catch{ throw new Error('JSON parse: '+t.slice(0,300)); } }
function fmt(n){ return new Intl.NumberFormat('uz-UZ').format(Math.round(n||0))+" so'm"; }

/* ===== Settings (DB) ===== */
async function loadServerSettings(){
  try{
    const d=await fetchJSON('../api/attendance.php?action=settings');
    const s=d.settings||{};
    sMon.checked=!!(+s.mon_work); sTue.checked=!!(+s.tue_work); sWed.checked=!!(+s.wed_work); sThu.checked=!!(+s.thu_work); sFri.checked=!!(+s.fri_work);
    sSat.checked=!!(+s.sat_work); sSun.checked=!!(+s.sun_work);
    sStart.value=(s.start_time||'09:00:00').slice(0,5);
    sEnd.value  =(s.end_time  ||'18:00:00').slice(0,5);
    sBreak.value=s.break_min||0;
    tLateMin.value=s.late_min_penalty||100;
    tAbsentDay.value=s.absent_day_penalty||100000;
    tPresentHour.value=s.present_hour_bonus||2000;
    tOntimeDay.value=s.ontime_day_bonus||5000;
    tEarlyLeave.value=s.early_leave_min_penalty||100;
  }catch(e){ show('Sozlamalar: '+e.message,'danger'); }
}
document.getElementById('btnSettings').addEventListener('click', ()=>{
  loadServerSettings();
  bootstrap.Offcanvas.getOrCreateInstance(document.getElementById('settingsPanel')).show();
});
document.getElementById('btnReloadSettings').addEventListener('click', loadServerSettings);
document.getElementById('btnSaveSettings').addEventListener('click', async ()=>{
  try{
    const body={
      mon_work: +sMon.checked, tue_work:+sTue.checked, wed_work:+sWed.checked, thu_work:+sThu.checked, fri_work:+sFri.checked, sat_work:+sSat.checked, sun_work:+sSun.checked,
      start_time: sStart.value+':00', end_time:sEnd.value+':00', break_min:parseInt(sBreak.value||'0',10),
      late_min_penalty:parseInt(tLateMin.value||'0',10), absent_day_penalty:parseInt(tAbsentDay.value||'0',10),
      present_hour_bonus:parseInt(tPresentHour.value||'0',10), ontime_day_bonus:parseInt(tOntimeDay.value||'0',10),
      early_leave_min_penalty:parseInt(tEarlyLeave.value||'0',10)
    };
    await fetchJSON('../api/attendance.php?action=settings_save',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)});
    show('Sozlamalar saqlandi','success');
    runCompute();
  }catch(e){ show('Saqlash: '+e.message,'danger'); }
});

/* ===== CSV UPLOAD ===== */
document.getElementById('csvInput').addEventListener('change', async (e)=>{
  const f=e.target.files[0]; if(!f) return;
  const ym=document.getElementById('ymTop').value || new Date().toISOString().slice(0,7);
  const fd=new FormData(); fd.append('ym', ym); fd.append('file', f, f.name);
  try{
    const d=await fetchJSON('../api/attendance.php?action=upload_csv',{method:'POST',body:fd});
    if(!d.ok){ show('Import xatosi: '+(d.error||''),'danger'); return; }
    show(`CSV import: #${d.import_id} (${d.file})`,'success');
    await loadImports();
    highlightImport(d.import_id);
    document.getElementById('ym').value = d.ym;
    await runCompute();
  }catch(err){ show('Import xatosi: '+err.message,'danger'); }
});

/* ===== Imports list ===== */
async function loadImports(){
  try{
    const d=await fetchJSON('../api/attendance.php?action=imports');
    const tb=document.querySelector('#tblImports tbody'); tb.innerHTML='';
    (d.rows||[]).forEach(x=>{
      const tr=document.createElement('tr');
      tr.innerHTML=`
        <td class="code">${esc(x.id)}</td>
        <td>${esc(x.ym)}</td>
        <td class="text-truncate" title="${esc(x.file_name)}">${esc(x.file_name)}</td>
        <td class="small text-muted">${esc(x.created_at||'')}</td>
        <td><button class="btn btn-sm btn-outline-primary impOpen" data-id="${esc(x.id)}">Ochish</button></td>`;
      tb.appendChild(tr);
    });
    tb.querySelectorAll('.impOpen').forEach(b=>b.addEventListener('click',()=>openImport(parseInt(b.dataset.id,10))));
  }catch(e){ show('Imports: '+e.message,'danger'); }
}
async function openImport(import_id){
  const row = [...document.querySelectorAll('#tblImports .impOpen')].find(b=>+b.dataset.id===import_id)?.closest('tr');
  if(row){ row.classList.add('table-success'); setTimeout(()=>row.classList.remove('table-success'),1500); }
}
function highlightImport(id){
  const btn=[...document.querySelectorAll('#tblImports .impOpen')].find(b=>parseInt(b.dataset.id,10)===id);
  if(btn){ btn.click(); }
}

/* ===== Hisob (oylik) ===== */
const st={rows:[], page:1, limit:20, total:0};
async function runCompute(){
  const ym=document.getElementById('ym').value; const q=document.getElementById('q').value.trim();
  const d=await fetchJSON(`../api/attendance.php?action=month_compute&ym=${encodeURIComponent(ym)}&page=${st.page}&limit=${st.limit}${q?`&q=${encodeURIComponent(q)}`:''}`);
  st.rows=d.rows||[]; st.total=d.total||st.rows.length; renderCompute(ym);
}
function renderCompute(ym){
  const tb=document.querySelector('#tblCalc tbody'); tb.innerHTML='';
  st.rows.forEach(x=>{
    const empId = parseInt(x.employee_id,10)||0;
    const empCode = x.emp_code||'';
    // EmpCode bo'lmaganlar API darajasida ham kelmaydi, lekin baribir guard:
    if(!empCode) return;
    const tr=document.createElement('tr');
    tr.innerHTML=`
      <td class="code">${empId}</td>
      <td class="code">${esc(empCode)}</td>
      <td>${esc(x.fio||'')}</td>
      <td>${esc(x.dept||'')}</td>
      <td class="text-center">${x.present_days}</td>
      <td class="text-center">${x.absent_days}</td>
      <td class="text-center">${x.late_min}</td>
      <td class="text-center">${Math.floor((x.worked_min||0)/60)}</td>
      <td class="text-end text-danger">-${fmt(x.penalties)}</td>
      <td class="text-end text-success">+${fmt(x.bonuses)}</td>
      <td class="text-end fw-semibold">${fmt(x.net)}</td>
      <td>
        <div class="btn-group btn-group-sm">
          <button class="btn btn-outline-primary dBtn" data-id="${empId}" data-code="${esc(empCode)}" data-fio="${esc(x.fio||'')}">Kunlik</button>
          <button class="btn btn-outline-secondary expRow" data-id="${empId}" data-code="${esc(empCode)}" data-fio="${esc(x.fio||'')}">Export</button>
          <button class="btn btn-outline-danger delRow" data-code="${esc(empCode)}">Delete</button>
        </div>
      </td>`;
    tb.appendChild(tr);
  });

  const from = st.total?((st.page-1)*st.limit+1):0;
  const to   = Math.min(st.total, st.page*st.limit);
  document.getElementById('sumInfo').textContent = `${from}–${to} / ${st.total}`;
  const pages=Math.max(1, Math.ceil(st.total/st.limit));
  const pg=document.getElementById('pager'); pg.innerHTML='';
  const mk=(dis,label,nav)=>{ const li=document.createElement('li'); li.className='page-item'+(dis?' disabled':''); li.innerHTML=`<a class="page-link" href="#" data-nav="${nav}">${label}</a>`; return li; };
  pg.appendChild(mk(st.page<=1,'Orqaga','prev'));
  pg.appendChild(mk(true,`${from}–${to}`,''));
  pg.appendChild(mk(st.page>=pages,'Keyingi','next'));
  pg.querySelectorAll('a.page-link').forEach(a=>a.addEventListener('click',e=>{
    e.preventDefault(); if(a.dataset.nav==='prev' && st.page>1){ st.page--; runCompute(); } if(a.dataset.nav==='next' && st.page<pages){ st.page++; runCompute(); }
  }));

  // Kunlik modal
  document.querySelectorAll('.dBtn').forEach(b=>{
    b.addEventListener('click', ()=>{
      openDaily(parseInt(b.dataset.id,10)||0, b.dataset.code||'', b.dataset.fio||'');
    });
  });
  // Export (hodim)
  document.querySelectorAll('.expRow').forEach(b=>b.addEventListener('click', async ()=>{
    await openDaily(parseInt(b.dataset.id,10)||0, b.dataset.code||'', b.dataset.fio||'', true);
    bootstrap.Modal.getOrCreateInstance(document.getElementById('detailModal')).show();
  }));
  // Delete (oy bo‘yicha emp_code)
  document.querySelectorAll('.delRow').forEach(b=>{
    b.addEventListener('click', async ()=>{
      const emp = b.dataset.code||''; if(!emp) return;
      const ym  = document.getElementById('ym').value;
      if(!confirm(`Rostdan ham ${emp} uchun ${ym} oyidagi barcha yozuvlarni o‘chirasizmi?`)) return;
      try{
        await fetchJSON('../api/attendance.php?action=delete_emp_month',{
          method:'POST', headers:{'Content-Type':'application/json'},
          body: JSON.stringify({ym, emp_code: emp})
        });
        show('O‘chirildi','success');
        runCompute();
      }catch(e){ show('Delete: '+e.message,'danger'); }
    });
  });
}

/* ===== Kunlik (modal) + Sababli ===== */
async function openDaily(empId, empCode, empFio, onlyLoad=false){
  const ym=document.getElementById('ym').value;
  let url = '../api/attendance.php?action=employee_month_calc&ym='+encodeURIComponent(ym);
  if(empId>0) url += '&employee_id='+empId;
  else if(empCode) url += '&emp_code='+encodeURIComponent(empCode);
  else { show('Hodim identifikatori topilmadi','danger'); return; }

  let d; try{ d=await fetchJSON(url); }catch(e){ show('Kunlik: '+e.message,'danger'); return; }

  const sum = d.summary||{};
  const rows=(d.days||[]).map(x=>{
    const status = (x.note||'').includes('kelajak')
      ? 'Kelajak'
      : (x.absent? 'Kelmadi' : (x.is_work?'Keldi':'Ish kuni emas'));
    return {...x, _status:status};
  });

  const hdr = `
    <div class="mb-2">
      <strong>${esc(d.employee?.fio || empFio || '')} ${d.employee?.emp_code? ' ('+esc(d.employee.emp_code)+')':''}</strong>
      <span class="text-muted">— ${esc(d.ym)}</span>
    </div>`;
  const cards = `
    <div class="row g-2 mb-2">
      <div class="col-sm-3"><div class="border rounded p-2"><div class="text-muted small">Kelgan kunlar</div><div class="fs-5">${sum.present_days||0} kun</div></div></div>
      <div class="col-sm-3"><div class="border rounded p-2"><div class="text-muted small">Kelmagan kunlar</div><div class="fs-5">${sum.absent_days||0} kun</div></div></div>
      <div class="col-sm-3"><div class="border rounded p-2"><div class="text-muted small">Kechikish</div><div class="fs-5">${sum.late_min||0} minut</div></div></div>
      <div class="col-sm-3"><div class="border rounded p-2"><div class="text-muted small">Ish vaqti</div><div class="fs-5">${Math.floor((sum.worked_min||0)/60)} soat</div></div></div>
    </div>
    <div class="row g-2 mb-3">
      <div class="col-sm-4"><div class="border rounded p-2"><div class="text-muted small">Jarimalar</div><div class="fs-5 text-danger">-${fmt(sum.penalties||0)}</div></div></div>
      <div class="col-sm-4"><div class="border rounded p-2"><div class="text-muted small">Bonuslar</div><div class="fs-5 text-success">+${fmt(sum.bonuses||0)}</div></div></div>
      <div class="col-sm-4"><div class="border rounded p-2"><div class="text-muted small">Net</div><div class="fs-5 fw-semibold">${fmt((sum.bonuses||0)-(sum.penalties||0))}</div></div></div>
    </div>`;

  const thead=['Sana','Holat','Kelish vaqti','Ketish vaqti','Kechikish (minut)','Jarima','Bonus','Izoh','Sababli'];
  const tr = rows.map(x=>{
    const chk = `<input type="checkbox" class="form-check-input excToggle" data-day="${esc(x.day)}" ${x.excused? 'checked':''}>`;
    const rsn = `<input type="text" class="form-control form-control-sm excReason" data-day="${esc(x.day)}" placeholder="Sabab..." value="${esc(x.reason||'')}">`;
    return `<tr>
      <td class="code">${esc(x.day)}</td>
      <td>${esc(x._status)}</td>
      <td class="text-center">${esc(x.first_in||'-')}</td>
      <td class="text-center">${esc(x.last_out||'-')}</td>
      <td class="text-center">${esc(x.late_min||0)}</td>
      <td class="text-end text-danger">-${fmt(x.penalty||0)}</td>
      <td class="text-end text-success">+${fmt(x.bonus||0)}</td>
      <td class="small">${esc(x.note||'')}</td>
      <td style="min-width:180px">
        <div class="d-flex gap-2 align-items-center">
          ${chk}
          <div class="flex-fill">${rsn}</div>
        </div>
      </td>
    </tr>`;
  }).join('');

  document.getElementById('dBody').innerHTML = hdr + cards + `
    <div class="table-responsive">
      <table class="table table-sm align-middle table-bordered">
        <thead class="table-light"><tr>${thead.map(h=>'<th>'+esc(h)+'</th>').join('')}</tr></thead>
        <tbody>${tr || '<tr><td colspan="9" class="text-muted">Ma’lumot yo‘q</td></tr>'}</tbody>
      </table>
    </div>`;

  // Sababli toggle / reason saqlash
  document.querySelectorAll('.excToggle').forEach(ch=>{
    ch.addEventListener('change', async ()=>{
      const day=ch.dataset.day, exc=ch.checked?1:0;
      const reason = document.querySelector(`.excReason[data-day="${CSS.escape(day)}"]`)?.value || '';
      try{
        await fetchJSON('../api/attendance.php?action=exception_set',{
          method:'POST', headers:{'Content-Type':'application/json'},
          body: JSON.stringify({ ym, day, excused:exc, reason, emp_code: (d.employee?.emp_code||''), fio:(d.employee?.fio||'') })
        });
        await openDaily(empId, empCode, empFio, true);
        bootstrap.Modal.getOrCreateInstance(document.getElementById('detailModal')).show();
        show('Saqlandi','success');
      }catch(e){ show('Sababli saqlash: '+e.message,'danger'); ch.checked=!exc; }
    });
  });
  document.querySelectorAll('.excReason').forEach(inp=>{
    inp.addEventListener('change', async ()=>{
      const day=inp.dataset.day, reason=inp.value;
      const ch=document.querySelector(`.excToggle[data-day="${CSS.escape(day)}"]`);
      const exc= ch && ch.checked?1:0;
      try{
        await fetchJSON('../api/attendance.php?action=exception_set',{
          method:'POST', headers:{'Content-Type':'application/json'},
          body: JSON.stringify({ ym, day, excused:exc, reason, emp_code: (d.employee?.emp_code||''), fio:(d.employee?.fio||'') })
        });
        await openDaily(empId, empCode, empFio, true);
        bootstrap.Modal.getOrCreateInstance(document.getElementById('detailModal')).show();
      }catch(e){ show('Sabab saqlash: '+e.message,'danger'); }
    });
  });

  document.getElementById('empExportMenu').dataset.emp = JSON.stringify({
    ym, fio:(d.employee?.fio||empFio||''), emp_code:(d.employee?.emp_code||empCode||''),
    rows: rows.map(x=>[x.day,x._status,x.first_in||'-',x.last_out||'-',x.late_min||0,x.penalty||0,x.bonus||0,x.note||''])
  });
  if(!onlyLoad) bootstrap.Modal.getOrCreateInstance(document.getElementById('detailModal')).show();
}

/* ===== Export helpers ===== */
document.querySelectorAll('.dropdown-menu [data-exp]').forEach(a=>{
  a.addEventListener('click', (e)=>{
    const type = a.dataset.exp;
    if(a.closest('#empExportMenu')){ exportEmployee(type); } else { exportAll(type); }
  });
});
function exportAll(type){
  const ym=document.getElementById('ym').value;
  const head = ['ID','EmpCode','FIO','Bo‘lim','Kelgan kunlar','Kelmagan kunlar','Kechikish (minut)','Ish vaqti (soat)','Jarima','Bonus','Net'];
  const rows = [...document.querySelectorAll('#tblCalc tbody tr')].map(tr=>{
    const tds=[...tr.children];
    return [
      tds[0].innerText, tds[1].innerText, tds[2].innerText, tds[3].innerText,
      tds[4].innerText, tds[5].innerText, tds[6].innerText, tds[7].innerText,
      parseNum(tds[8].innerText), parseNum(tds[9].innerText), parseNum(tds[10].innerText)
    ];
  });
  downloadTable(type, 'hisob_'+ym, head, rows);
}
function exportEmployee(type){
  const meta = document.getElementById('empExportMenu').dataset.emp;
  if(!meta){ show('Hodim ma’lumoti topilmadi','danger'); return; }
  const {ym,fio,emp_code,rows} = JSON.parse(meta);
  const head=['Sana','Holat','Kelish vaqti','Ketish vaqti','Kechikish (minut)','Jarima','Bonus','Izoh'];
  downloadTable(type, 'hisob_'+(emp_code||fio||'')+'_'+ym, head, rows, true);
}
function downloadTable(type, name, head, rows, withSum=false){
  if(type==='csv' || type==='txt'){
    const delim = (type==='csv') ? ',' : '\t';
    const lines = [];
    lines.push(head.join(delim));
    rows.forEach(r=>lines.push(r.join(delim)));
    if(withSum){
      const p = rows.reduce((s,r)=>s + (parseNum(r[5])||0),0);
      const b = rows.reduce((s,r)=>s + (parseNum(r[6])||0),0);
      lines.push(['','','','','Jami', p, b, ''].join(delim));
    }
    const blob = new Blob([lines.join('\n')], {type: 'text/'+(type==='csv'?'csv':'plain')+';charset=utf-8'});
    triggerBlob(blob, name+'.'+type); return;
  }
  const table = buildHtmlTable(head, rows, withSum);
  if(type==='xls'){
    const blob = new Blob(['\ufeff'+table], {type: 'application/vnd.ms-excel;charset=utf-8'});
    triggerBlob(blob, name+'.xls'); return;
  }
  if(type==='doc'){
    const html = '<html><head><meta charset="utf-8"></head><body>'+table+'</body></html>';
    const blob = new Blob([html], {type: 'application/msword;charset=utf-8'});
    triggerBlob(blob, name+'.doc'); return;
  }
  if(type==='pdf'){
    const w = window.open('', '_blank');
    w.document.write('<html><head><meta charset="utf-8"><title>'+name+'</title>');
    w.document.write('<style>table{border-collapse:collapse;width:100%}th,td{border:1px solid #ddd;padding:6px;font:12px Arial}</style>');
    w.document.write('</head><body>'+table+'</body></html>');
    w.document.close(); w.focus(); w.print(); return;
  }
}
function buildHtmlTable(head, rows, withSum){
  const th = '<tr>'+head.map(h=>'<th>'+esc(h)+'</th>').join('')+'</tr>';
  const tr = rows.map(r=>'<tr>'+r.map((c,i)=> (withSum && (i==5||i==6)) ? `<td class="${i==5?'text-danger text-end':'text-success text-end'}">${esc(c)}</td>` : `<td>${esc(c)}</td>`).join('')+'</tr>').join('');
  let sumRow='';
  if(withSum){
    const p = rows.reduce((s,r)=>s + (parseNum(r[5])||0),0);
    const b = rows.reduce((s,r)=>s + (parseNum(r[6])||0),0);
    sumRow = `<tr><th colspan="5" style="text-align:right">Jami</th><th class="text-danger text-end">${p}</th><th class="text-success text-end">${b}</th><th></th></tr>`;
  }
  return '<table style="border-collapse:collapse;width:100%">'+
           '<thead>'+th+'</thead><tbody>'+tr+sumRow+'</tbody></table>';
}
function parseNum(x){ if(typeof x==='number') return x; if(!x) return 0; return parseFloat(String(x).replace(/[^\d.\-]/g,''))||0; }
function triggerBlob(blob, filename){ const url=URL.createObjectURL(blob); const a=document.createElement('a'); a.href=url; a.download=filename; a.click(); setTimeout(()=>URL.revokeObjectURL(url),2000); }

/* ===== INIT ===== */
document.getElementById('btnRun').addEventListener('click', ()=>{ st.page=1; runCompute(); });
window.addEventListener('DOMContentLoaded', ()=>{ loadServerSettings(); loadImports(); runCompute(); });

</script>
</body>
</html>
