<?php require_once __DIR__ . '/../config.php'; require_admin(); ?>
<!doctype html><html lang="uz"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Operatorlar — CRUD</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark" style="background:#0d6efd;">
  <div class="container">
    <a class="navbar-brand fw-bold" href="./dashboard.php">Oylik Hisob (Admin)</a>
    <ul class="navbar-nav ms-auto">
      <li class="nav-item"><a class="nav-link " href="./dashboard.php">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link active" href="./operators.php">Operatorlar</a></li>
      <li class="nav-item"><a class="nav-link" href="./users.php">Foydalanuvchi (Operator)</a></li>
      <li class="nav-item"><a class="nav-link" href="./plans.php">Plan yaratish</a></li>
      <li class="nav-item"><a class="nav-link" href="./admin_review.php">Tekshirish</a></li>
      <li class="nav-item"><a class="nav-link" href="./operator_contracts.php">Shartnoma tayyorlash</a></li>
      <li class="nav-item"><a class="nav-link" href="./attendance_calc.php">Keldi / Ketdi</a></li>
      
      <li class="nav-item"><a class="nav-link" href="./admin_penalties.php">Jarimalar</a></li>
<li class="nav-item"><a class="nav-link" href="./logout.php">Chiqish</a></li>
    </ul>
  </div>
</nav>

<div class="container my-3">
  <div class="card shadow-sm mb-3"><div class="card-body">
    <div class="row g-2">
      <div class="col-md-2"><input id="code" class="form-control" placeholder="Kod (OP010)"></div>
      <div class="col-md-3"><input id="name" class="form-control" placeholder="Ism Familya"></div>
      <div class="col-md-3"><input id="dept" class="form-control" placeholder="Bo‘lim"></div>
      <div class="col-md-3"><input id="region" class="form-control" placeholder="Hudud"></div>
      <div class="col-md-1 d-grid"><button id="addBtn" class="btn btn-primary">Qo‘shish</button></div>
    </div>
  </div></div>

  <div class="card shadow-sm"><div class="card-body table-responsive">
    <table class="table table-sm table-hover align-middle" id="tbl">
      <thead class="table-light"><tr><th>Kod</th><th>Ism</th><th>Bo‘lim</th><th>Hudud</th><th>Holat</th><th>Amal</th></tr></thead>
      <tbody></tbody>
    </table>
    <nav class="mt-2"><ul class="pagination" id="pager"></ul></nav>
  </div></div>
</div>

<!-- Modals -->
<div class="modal fade" id="opEditModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content">
  <div class="modal-header bg-primary text-white"><h5 class="modal-title">Tahrirlash</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
  <div class="modal-body">
    <input type="hidden" id="eId">
    <div class="mb-2"><label class="form-label">Ism</label><input id="eName" class="form-control"></div>
    <div class="mb-2"><label class="form-label">Bo‘lim</label><input id="eDept" class="form-control"></div>
    <div class="mb-2"><label class="form-label">Hudud</label><input id="eReg" class="form-control"></div>
    <div class="form-check"><input class="form-check-input" type="checkbox" id="eActive"><label class="form-check-label" for="eActive">Faol</label></div>
  </div>
  <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Bekor</button><button class="btn btn-primary" id="eSave">Saqlash</button></div>
</div></div></div>

<div class="modal fade" id="opDelModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content">
  <div class="modal-header bg-danger text-white"><h5 class="modal-title">O‘chirish</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
  <div class="modal-body">Haqiqatan o‘chirmoqchimisiz? <strong id="dName"></strong></div>
  <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Bekor</button><button class="btn btn-danger" id="dYes">Ha, o‘chir</button></div>
</div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
let curRow=null, editModal, delModal; let page=1, total=0, limit=25;
async function loadPage(p=1){
  page=p; const r=await fetch('../api/operators.php?page='+page+'&limit='+limit); const d=await r.json();
  total=d.total||0; const tb=document.querySelector('#tbl tbody'); tb.innerHTML='';
  (d.rows||[]).forEach(o=>{ const tr=document.createElement('tr'); tr.dataset.id=o.id; tr.innerHTML=`<td>${o.code}</td><td>${o.name}</td><td>${o.department||''}</td><td>${o.region||''}</td><td>${o.active?'Faol':'Nofoal'}</td><td><button class='btn btn-sm btn-outline-primary' data-action='edit'>Tahrirlash</button> <button class='btn btn-sm btn-outline-danger ms-1' data-action='del'>O‘chirish</button></td>`; tb.appendChild(tr); });
  const pages=Math.ceil(total/limit); const pg=document.getElementById('pager'); pg.innerHTML=''; for(let i=1;i<=pages;i++){ const li=document.createElement('li'); li.className='page-item'+(i===page?' active':''); li.innerHTML=`<a class='page-link' href='#'>${i}</a>`; li.addEventListener('click',e=>{e.preventDefault(); loadPage(i);}); pg.appendChild(li); }
}
document.addEventListener('click', (e)=>{
  if(e.target.dataset.action==='edit'){ curRow=e.target.closest('tr'); const c=curRow.children; document.getElementById('eId').value=curRow.dataset.id; document.getElementById('eName').value=c[1].innerText; document.getElementById('eDept').value=c[2].innerText; document.getElementById('eReg').value=c[3].innerText; document.getElementById('eActive').checked=(c[4].innerText.trim()==='Faol'); editModal=new bootstrap.Modal(document.getElementById('opEditModal')); editModal.show(); }
  if(e.target.dataset.action==='del'){ curRow=e.target.closest('tr'); document.getElementById('dName').innerText=curRow.children[1].innerText; delModal=new bootstrap.Modal(document.getElementById('opDelModal')); delModal.show(); }
});
document.getElementById('eSave').addEventListener('click', async ()=>{
  const body={ id:parseInt(document.getElementById('eId').value,10), name:document.getElementById('eName').value, department:document.getElementById('eDept').value, region:document.getElementById('eReg').value, active:document.getElementById('eActive').checked?1:0 };
  const res=await fetch('../api/operators.php',{method:'POST',headers:{'Content-Type':'application/json','X-HTTP-Method-Override':'PUT'},body:JSON.stringify(body)}); const d=await res.json(); if(d.ok){ editModal.hide(); loadPage(page); } else alert(JSON.stringify(d));
});
document.getElementById('dYes').addEventListener('click', async ()=>{
  const id=parseInt(curRow.dataset.id,10); const res=await fetch('../api/operators.php',{method:'POST',headers:{'Content-Type':'application/json','X-HTTP-Method-Override':'DELETE'},body:JSON.stringify({id})}); const d=await res.json(); if(d.ok){ delModal.hide(); loadPage(page); } else alert(JSON.stringify(d));
});
document.getElementById('addBtn').addEventListener('click', async ()=>{
  const body={ code:document.getElementById('code').value.trim(), name:document.getElementById('name').value.trim(), department:document.getElementById('dept').value.trim(), region:document.getElementById('region').value.trim() };
  if(!body.code||!body.name) return alert('Kod va ism shart'); const res=await fetch('../api/operators.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)}); const d=await res.json(); if(d.id){ loadPage(1); } else alert(JSON.stringify(d));
});
window.addEventListener('DOMContentLoaded', ()=>loadPage(1));
</script>
</body></html>
