<?php require_once __DIR__ . '/../config.php'; require_admin(); ?>
<!doctype html><html lang="uz"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Foydalanuvchilar — CRUD</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark" style="background:#0d6efd;">
  <div class="container">
    <a class="navbar-brand fw-bold" href="./dashboard.php">Oylik Hisob (Admin)</a>
    <ul class="navbar-nav ms-auto">
      <li class="nav-item"><a class="nav-link " href="./dashboard.php">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link" href="./operators.php">Operatorlar</a></li>
      <li class="nav-item"><a class="nav-link active" href="./users.php">Foydalanuvchi (Operator)</a></li>
      <li class="nav-item"><a class="nav-link" href="./plans.php">Plan yaratish</a></li>
      <li class="nav-item"><a class="nav-link" href="./admin_review.php">Tekshirish</a></li>
      <li class="nav-item"><a class="nav-link" href="./operator_contracts.php">Shartnoma tayyorlash</a></li>
      <li class="nav-item"><a class="nav-link" href="./attendance_calc.php">Keldi / Ketdi</a></li>
      
      <li class="nav-item"><a class="nav-link" href="./admin_penalties.php">Jarimalar</a></li>
<li class="nav-item"><a class="nav-link" href="./logout.php">Chiqish</a></li>
    </ul>
  </div>
</nav>

<div class="container my-3">
  <div class="d-flex justify-content-between align-items-center">
    <h5 class="mb-3">Foydalanuvchilar</h5>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#userModal">Yangi foydalanuvchi</button>
  </div>
  <div class="card shadow-sm"><div class="card-body table-responsive">
    <table class="table table-sm table-hover align-middle" id="tbl">
      <thead class="table-light"><tr><th>ID</th><th>Login</th><th>Role</th><th>Operator</th><th>Amal</th></tr></thead>
      <tbody></tbody>
    </table>
  </div></div>
</div>

<!-- User Modal -->
<div class="modal fade" id="userModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content">
  <div class="modal-header bg-primary text-white"><h5 class="modal-title">Yangi foydalanuvchi</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
  <div class="modal-body">
    <div class="mb-2"><label class="form-label">Login</label><input id="uLogin" class="form-control"></div>
    <div class="mb-2"><label class="form-label">Parol</label><input id="uPass" class="form-control" type="password"></div>
    <div class="mb-2"><label class="form-label">Role</label>
      <select id="uRole" class="form-select">
        <option value="admin">admin</option>
        <option value="operator" selected>operator</option>
      </select>
    </div>
    <div class="mb-2"><label class="form-label">Operator (ixtiyoriy)</label><select id="uOp" class="form-select"></select></div>
  </div>
  <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Bekor</button><button class="btn btn-primary" id="uSave">Saqlash</button></div>
</div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
async function loadUsers(){ const r=await fetch('../api/users.php'); const d=await r.json(); const tb=document.querySelector('#tbl tbody'); tb.innerHTML=''; (d.rows||[]).forEach(u=>{ const tr=document.createElement('tr'); tr.innerHTML=`<td>${u.id}</td><td>${u.username}</td><td>${u.role}</td><td>${u.operator_name||''}</td><td></td>`; tb.appendChild(tr); }); }
async function loadOps(){ const r=await fetch('../api/operators.php'); const d=await r.json(); const sel=document.getElementById('uOp'); sel.innerHTML='<option value="">— Biriktirmaslik —</option>'; (d.rows||d).forEach(o=>{ const opt=document.createElement('option'); opt.value=o.id; opt.textContent=o.name+' ('+o.code+')'; sel.appendChild(opt); }); }
document.getElementById('uSave').addEventListener('click', async ()=>{ const body={ username:document.getElementById('uLogin').value, password:document.getElementById('uPass').value, role:document.getElementById('uRole').value, operator_id:document.getElementById('uRole').value==='operator'?parseInt(document.getElementById('uOp').value||'0',10):null }; const r=await fetch('../api/users.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)}); const d=await r.json(); if(d.id){ loadUsers(); bootstrap.Modal.getInstance(document.getElementById('userModal')).hide(); } else alert(JSON.stringify(d)); });
document.addEventListener('DOMContentLoaded', ()=>{ loadUsers(); loadOps(); });
</script>
</body></html>
