<?php
require_once __DIR__ . '/../config.php';
$method = $_SERVER['REQUEST_METHOD'];
if ($method === 'POST') {
  $data = json_decode(file_get_contents('php://input'), true);
  $username = trim($data['username'] ?? '');
  $password = $data['password'] ?? '';
  $stmt = db()->prepare("SELECT * FROM users WHERE username=? LIMIT 1");
  $stmt->bind_param("s",$username); $stmt->execute();
  $u = $stmt->get_result()->fetch_assoc(); $stmt->close();
  if ($u && password_verify($password, $u['password_hash'])) {
    $_SESSION['user_obj'] = ['id'=>$u['id'],'username'=>$u['username'],'role'=>$u['role'],'operator_id'=>$u['operator_id']];
    json_out(['ok'=>true,'user'=>$_SESSION['user_obj']]);
  } else json_out(['error'=>'Login yoki parol xato'], 401);
}
if ($method === 'GET') { json_out(['user'=>current_user()]); }
if ($method === 'DELETE') { unset($_SESSION['user_obj']); json_out(['ok'=>true]); }
json_out(['error'=>'Method not allowed'],405);
