<?php
/* ===============================
   CONFIG — Oylik Hisob tizimi
   =============================== */
ini_set('default_charset', 'UTF-8');
mb_internal_encoding('UTF-8');
if (!defined('TZ')) define('TZ', 'Asia/Tashkent');
date_default_timezone_set(TZ);

if (!defined('DEBUG')) define('DEBUG', 1);
if (DEBUG) { error_reporting(E_ALL); ini_set('display_errors', 1); }
else { error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED); ini_set('display_errors', 0); }

if (session_status() === PHP_SESSION_NONE) {
  $sec = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
  session_set_cookie_params([ 'lifetime'=>60*60*24*7, 'path'=>'/', 'secure'=>$sec, 'httponly'=>true, 'samesite'=>'Lax' ]);
  session_start();
}

if (!defined('DB_HOST')) define('DB_HOST', '127.0.0.1');
if (!defined('DB_USER')) define('DB_USER', 'root');
if (!defined('DB_PASS')) define('DB_PASS', '');
if (!defined('DB_NAME')) define('DB_NAME', 'payroll_db');

// Legacy login constants (if you still use old public/login.php somewhere)
if (!defined('APP_USER')) define('APP_USER', getenv('APP_USER') ?: 'admin');
if (!defined('APP_PASS')) define('APP_PASS', getenv('APP_PASS') ?: 'admin123');

if (!defined('ROOT_DIR'))   define('ROOT_DIR', __DIR__);
if (!defined('PUBLIC_DIR')) define('PUBLIC_DIR', __DIR__ . '/public');
if (!defined('UPLOAD_DIR')) define('UPLOAD_DIR', PUBLIC_DIR . '/uploads');
if (!defined('MAX_UPLOAD_MB')) define('MAX_UPLOAD_MB', 25);
if (!is_dir(UPLOAD_DIR)) @mkdir(UPLOAD_DIR, 0775, true);

function db() {
  static $mysqli = null;
  if ($mysqli) return $mysqli;
  $mysqli = @new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
  if ($mysqli->connect_errno) {
    header('Content-Type: application/json; charset=utf-8', true, 500);
    echo json_encode(['error'=>'DB connection failed','detail'=>$mysqli->connect_error], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
    exit;
  }
  $mysqli->set_charset('utf8mb4');
  return $mysqli;
}
function json_out($payload, $code=200){
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($payload, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit;
}
function public_rel_path($absPath){
  $rel = str_replace(PUBLIC_DIR, '', $absPath);
  return $rel ?: '/';
}
function current_user(){
  if (isset($_SESSION['user_obj']) && is_array($_SESSION['user_obj'])) return $_SESSION['user_obj'];
  if (isset($_SESSION['user'])){
    if (is_string($_SESSION['user'])) return ['id'=>null,'username'=>$_SESSION['user'],'role'=>'admin','operator_id'=>null];
    if (is_array($_SESSION['user'])){
      if (!isset($_SESSION['user']['role'])) $_SESSION['user']['role']='admin';
      if (!isset($_SESSION['user']['operator_id'])) $_SESSION['user']['operator_id']=null;
      return $_SESSION['user'];
    }
  }
  return null;
}
function require_login(){
  if (current_user()) return;
  $login = file_exists(PUBLIC_DIR.'/login.php') ? 'login.php' : 'login_user.php';
  header("Location: ./$login"); exit;
}
function require_admin(){ $u=current_user(); if(!$u || $u['role']!=='admin'){ header("HTTP/1.1 403 Forbidden"); exit("Admin kirishi kerak"); } }
function require_operator(){ $u=current_user(); if(!$u || $u['role']!=='operator'){ header("HTTP/1.1 403 Forbidden"); exit("Operator kirishi kerak"); } }
if (!headers_sent()){ header('X-Content-Type-Options: nosniff'); header('X-Frame-Options: SAMEORIGIN'); header('Referrer-Policy: strict-origin-when-cross-origin'); }
function is_post(){ return ($_SERVER['REQUEST_METHOD']??'')==='POST'; }
function is_json_request(){ $ct=$_SERVER['CONTENT_TYPE']??''; return stripos($ct,'application/json')!==false; }
