-- 004_attendance.sql
CREATE TABLE IF NOT EXISTS attendance_logs (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  operator_id INT NOT NULL,
  day DATE NOT NULL,
  time_in TIME DEFAULT NULL,
  time_out TIME DEFAULT NULL,
  late_minutes INT DEFAULT 0,
  note VARCHAR(255) DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (operator_id) REFERENCES operators(id) ON DELETE CASCADE,
  INDEX (operator_id, day)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
