<?php require_once __DIR__ . '/../config.php'; require_admin(); ?>
<!doctype html><html lang="uz"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Dalillarni tekshirish</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="bg-light">
<nav class="navbar navbar-dark" style="background:#dc3545;"><div class="container">
  <a class="navbar-brand fw-bold" href="./dashboard.php">Oylik Hisob</a>
  <ul class="navbar-nav ms-auto flex-row gap-3">
    <li class="nav-item"><a class="nav-link" href="./operators.php">Operatorlar</a></li>
    <li class="nav-item"><a class="nav-link" href="./plans.php">Plan konstruktor</a></li>
    <li class="nav-item"><a class="nav-link" href="./logout.php">Chiqish</a></li>
  </ul>
</div></nav>

<div class="container my-3">
  <div class="row g-3 align-items-end">
    <div class="col-md-3"><label class="form-label">Oy</label><input type="month" id="ym" class="form-control" value="<?php echo date('Y-m'); ?>"></div>
    <div class="col-md-3"><label class="form-label">Holat</label><select id="status" class="form-select"><option value="pending">pending</option><option value="approved">approved</option><option value="rejected">rejected</option></select></div>
    <div class="col-md-3"><label class="form-label">Plan ID</label><input id="plan_id" class="form-control" placeholder="ixtiyoriy"></div>
    <div class="col-md-3"><button id="load" class="btn btn-primary">Yuklash</button></div>
  </div>

  <div id="list" class="row g-3 mt-2"></div>
</div>

<div class="modal fade" id="revModal" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content">
  <div class="modal-header bg-primary text-white"><h5 class="modal-title">Tekshirish</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
  <div class="modal-body"><div id="revBody"></div><div class="mt-2"><label class="form-label">Izoh</label><textarea id="revNote" class="form-control"></textarea></div></div>
  <div class="modal-footer"><button class="btn btn-danger" id="rej">Rad etish</button><button class="btn btn-success" id="ok">Tasdiqlash</button></div>
</div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
let curId=null; function preview(path,mime){ mime=mime||''; if(mime.startsWith('image/')) return `<div class='mt-2'><img src='${path}' class='img-fluid rounded'></div>`; if(mime.startsWith('audio/')) return `<div class='mt-2'><audio controls src='${path}'></audio></div>`; if(mime.startsWith('video/')) return `<div class='mt-2'><video controls class='w-100' src='${path}'></video></div>`; return `<div class='mt-2'><a href='${path}' target='_blank'>Fayl</a></div>`; }
document.getElementById('load').addEventListener('click', loadData);
async function loadData(){ const ym=document.getElementById('ym').value, status=document.getElementById('status').value, pid=document.getElementById('plan_id').value; const r=await fetch(`../api/review_list.php?ym=${ym}&status=${status}${pid?`&plan_id=${pid}`:''}`); const d=await r.json(); const box=document.getElementById('list'); box.innerHTML=''; (d.rows||[]).forEach(x=>{ const card=document.createElement('div'); card.className='col-md-6'; card.innerHTML=`<div class='card shadow-sm'><div class='card-body'><div class='d-flex justify-content-between'><div><strong>${x.operator_name}</strong> — <span class='text-muted'>${x.plan_name} / ${x.item_title}</span></div><div><span class='badge bg-secondary'>${x.status}</span></div></div>${x.text_content?('<div class=\'mt-2\'><strong>Matn:</strong> '+x.text_content+'</div>'):''}${x.username_ref?('<div><strong>Username:</strong> '+x.username_ref+'</div>'):''}${x.file_path?preview(x.file_path, x.file_mime):''}<div class='text-end mt-2'><button class='btn btn-sm btn-outline-primary review' data-id='${x.id}'>Ko‘rish</button></div></div></div>`; box.appendChild(card); }); document.querySelectorAll('.review').forEach(b=>b.addEventListener('click',()=>openRev(b.dataset.id, d.rows))); }
function openRev(id,rows){ curId=id; const x=(rows||[]).find(r=>r.id==id); document.getElementById('revBody').innerHTML=`<div><strong>${x.operator_name}</strong> — <span class='text-muted'>${x.plan_name} / ${x.item_title}</span></div>${x.text_content?('<div class=\'mt-2\'><strong>Matn:</strong> '+x.text_content+'</div>'):''}${x.username_ref?('<div><strong>Username:</strong> '+x.username_ref+'</div>'):''}${x.file_path?preview(x.file_path, x.file_mime):''}`; new bootstrap.Modal(document.getElementById('revModal')).show(); }
document.getElementById('ok').addEventListener('click',()=>review('approved')); document.getElementById('rej').addEventListener('click',()=>review('rejected'));
async function review(status){ const note=document.getElementById('revNote').value; const r=await fetch('../api/review.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({id:parseInt(curId,10),status,note})}); const d=await r.json(); if(d.ok) location.reload(); }
</script>
</body></html>
