<?php require_once __DIR__ . '/../config.php'; require_admin(); ?>
<!doctype html><html lang="uz"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Admin — Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>
</head><body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark" style="background:#0d6efd;"><div class="container">
  <a class="navbar-brand fw-bold" href="./dashboard.php">Oylik Hisob (Admin)</a>
  <ul class="navbar-nav ms-auto">
    <li class="nav-item"><a class="nav-link" href="./operators.php">Operatorlar</a></li>
    <li class="nav-item"><a class="nav-link" href="./plans.php">Plan konstruktor</a></li>
    <li class="nav-item"><a class="nav-link" href="./admin_review.php">Tekshirish</a></li>
    <li class="nav-item"><a class="nav-link" href="./logout.php">Chiqish</a></li>
  </ul>
</div></nav>

<div class="container my-4">
  <div class="d-flex align-items-end gap-3 flex-wrap mb-3">
    <div><label class="form-label">Oy</label><input type="month" id="ym" class="form-control" value="<?php echo date('Y-m'); ?>"></div>
    <div><label class="form-label">Hodim</label><select id="fOp" class="form-select"></select></div>
    <div><label class="form-label">Bo‘lim</label><input id="fDept" class="form-control" placeholder="Sales"></div>
    <div><label class="form-label">Hudud</label><input id="fReg" class="form-control" placeholder="Chilonzor"></div>
    <div><label class="form-label">Qidirish</label><input id="fQ" class="form-control" placeholder="ism yoki kod"></div>
    <button id="refreshBtn" class="btn btn-primary">Hisobla</button>
  </div>

  <div class="mb-2">
    <a id="btnCsv" class="btn btn-outline-secondary btn-sm me-2" href="#">CSV</a>
    <a id="btnXls" class="btn btn-outline-secondary btn-sm me-2" href="#">Excel (XLS)</a>
    <a id="btnPdf" class="btn btn-outline-secondary btn-sm" href="#">PDF</a>
  </div>

  <div id="totals" class="row g-3 mb-3">
    <div class="col-md-3"><div class="card border-primary"><div class="card-body"><div class="text-muted">Asosiy oylik</div><div class="h4 mb-0" id="tBase">—</div></div></div></div>
    <div class="col-md-3"><div class="card border-info"><div class="card-body"><div class="text-muted">Gross</div><div class="h4 mb-0" id="tGross">—</div></div></div></div>
    <div class="col-md-3"><div class="card border-warning"><div class="card-body"><div class="text-muted">Jarimalar</div><div class="h4 mb-0" id="tPen">—</div></div></div></div>
    <div class="col-md-3"><div class="card border-success"><div class="card-body"><div class="text-muted">Net</div><div class="h4 mb-0" id="tNet">—</div></div></div></div>
  </div>

  <div class="card shadow-sm mb-4"><div class="card-body table-responsive">
    <table class="table table-sm table-hover align-middle" id="tbl">
      <thead class="table-primary">
        <tr>
          <th>Hodim</th><th>Bo‘lim</th><th>Hudud</th><th>Asosiy (so‘m)</th>
          <th>Qayta ishga tushirish (reja/amal/%)</th><th>Yangi mijoz (reja/amal/%)</th><th>Oqim</th>
          <th>Telegram (reja/amal/%)</th><th>Instagram (akkaunt/video)</th>
          <th>Reyting</th><th>Gross</th><th>Jarima</th><th>Net</th><th>Amal</th>
        </tr>
      </thead><tbody></tbody>
    </table>
  </div></div>

  <div class="row g-3">
    <div class="col-md-6"><div class="card shadow-sm"><div class="card-body"><canvas id="chartNet"></canvas></div></div></div>
    <div class="col-md-6"><div class="card shadow-sm"><div class="card-body"><canvas id="chartPen"></canvas></div></div></div>
  </div>
</div>

<!-- Approve Modal -->
<div class="modal fade" id="approveModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content">
  <div class="modal-header bg-primary text-white"><h5 class="modal-title">Asosiy oylikni tasdiqlash</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
  <div class="modal-body">
    <div class="mb-2"><strong id="mOpName"></strong></div>
    <div class="mb-3"><label class="form-label">Asosiy oylik (so'm)</label><input type="number" id="mBaseAmount" class="form-control" step="1000"></div>
    <div class="form-check"><input class="form-check-input" type="checkbox" id="mConfirm"><label class="form-check-label" for="mConfirm">Tasdiqlayman</label></div>
    <input type="hidden" id="mOpId"><input type="hidden" id="mYm">
  </div>
  <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Bekor</button><button class="btn btn-primary" id="mSave">Saqlash</button></div>
</div></div></div>

<!-- View Modal -->
<div class="modal fade" id="viewModal" tabindex="-1"><div class="modal-dialog modal-lg modal-dialog-scrollable"><div class="modal-content">
  <div class="modal-header bg-success text-white"><h5 class="modal-title">Hodim tafsilotlari</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
  <div class="modal-body"><div id="viewBody"></div></div>
  <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button></div>
</div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
var lastRows = [];
function fmt(n){ try{ return new Intl.NumberFormat('uz-UZ').format(n)+' so\'m'; }catch(e){ return n+' so\'m'; } }
async function loadOpFilter(){
  const r=await fetch('../api/operators.php'); const d=await r.json(); const sel=document.getElementById('fOp'); sel.innerHTML='<option value="">— Barchasi —</option>';
  (d.rows||d).forEach(o=>{ const opt=document.createElement('option'); opt.value=o.id; opt.textContent=o.name+' ('+o.code+')'; sel.appendChild(opt); });
}
function updateExportLinks(){
  const ym=document.getElementById('ym').value; const params=new URLSearchParams({ym:ym,dept:document.getElementById('fDept').value,region:document.getElementById('fReg').value,q:document.getElementById('fQ').value,op:document.getElementById('fOp').value});
  document.getElementById('btnCsv').href='../api/export_csv.php?'+params.toString(); document.getElementById('btnCsv').setAttribute('download','payroll_'+ym+'.csv');
  document.getElementById('btnXls').href='../api/export_xls.php?'+params.toString(); document.getElementById('btnXls').setAttribute('download','payroll_'+ym+'.xls');
  document.getElementById('btnPdf').href='../api/export_pdf.php?'+params.toString(); document.getElementById('btnPdf').setAttribute('download','payroll_'+ym+'.pdf');
}
async function refresh(){
  const ym=document.getElementById('ym').value;
  const params=new URLSearchParams({ym:ym,dept:document.getElementById('fDept').value,region:document.getElementById('fReg').value,q:document.getElementById('fQ').value,op:document.getElementById('fOp').value});
  const res=await fetch('../api/calc_payroll.php?'+params.toString()); const data=await res.json(); lastRows=data.rows||[];
  document.getElementById('tBase').innerText=fmt((data.totals&&data.totals.base)||0); document.getElementById('tGross').innerText=fmt((data.totals&&data.totals.gross)||0);
  document.getElementById('tPen').innerText=fmt((data.totals&&data.totals.penalties)||0); document.getElementById('tNet').innerText=fmt((data.totals&&data.totals.net)||0);
  const tbody=document.querySelector('#tbl tbody'); tbody.innerHTML='';
  for(let i=0;i<lastRows.length;i++){ const r=lastRows[i]; const badge = r.base_confirmed?"<span class='badge bg-success'>Tasdiqlangan</span>":(r.base_pending?"<span class='badge bg-warning text-dark'>Kutilmoqda</span>":"<span class='badge bg-secondary'>Yo'q</span>"); tbody.insertAdjacentHTML('beforeend', `
    <tr>
      <td>${r.name}</td><td>${r.department||''}</td><td>${r.region||''}</td>
      <td>${fmt(r.base_amount)}<br>${badge}</td>
      <td>Reja: ${r.reac_plan}/${r.reac_done} — ${r.reac_pct}% ${(r.reac_pct>=90)?'✅':''}<br><span class='text-muted'>Bonus: ${fmt(r.bonus_reactivation)}</span></td>
      <td>Reja: ${r.new_plan}/${r.new_done} — ${r.new_pct}% ${(r.new_pct>=90)?'✅':''}<br><span class='text-muted'>Bonus: ${fmt(r.bonus_new)}</span></td>
      <td>${r.flow_ok?'Hisobot topshirildi ✅':'Hisobot topshirilmagan'}<br><span class='text-muted'>Bonus: ${fmt(r.bonus_flow_control)}</span></td>
      <td>Reja: ${r.tg_plan}/${r.tg_done} — ${r.tg_pct}% ${(r.tg_pct>=90)?'✅':''}<br><span class='text-muted'>Bonus: ${fmt(r.bonus_telegram)}</span></td>
      <td>Acc: ${r.ig_acc_plan}/${r.ig_acc_done} — ${r.ig_acc_pct}% ${(r.ig_acc_pct>=90)?'✅':''}<br>Vid: ${r.ig_vid_plan}/${r.ig_vid_done} — ${r.ig_vid_pct}% ${(r.ig_vid_pct>=90)?'✅':''}<br><span class='text-muted'>Bonus: ${fmt(r.bonus_instagram)}</span></td>
      <td>${r.rating_pos ? (r.rating_pos+'-o‘rin') : '—'}<br><span class='text-muted'>Bonus: ${fmt(r.bonus_rating)}</span></td>
      <td class='fw-semibold'>${fmt(r.gross)}</td><td class='text-danger'>-${fmt(r.penalties_total)}</td><td class='fw-bold'>${fmt(r.net)}</td>
      <td><button class='btn btn-sm btn-outline-primary' data-action='approve' data-id='${r.operator_id}' data-name='${r.name}' data-base='${r.base_amount}'>Tasdiqlash</button> <button class='btn btn-sm btn-outline-success ms-1' data-action='view' data-index='${i}'>Ko‘rish</button></td>
    </tr>`); }
  tbody.querySelectorAll('button[data-action=approve]').forEach(btn=>btn.addEventListener('click',()=>{ document.getElementById('mOpId').value=btn.dataset.id; document.getElementById('mOpName').textContent=btn.dataset.name; document.getElementById('mBaseAmount').value=btn.dataset.base; document.getElementById('mConfirm').checked=true; document.getElementById('mYm').value=document.getElementById('ym').value; new bootstrap.Modal(document.getElementById('approveModal')).show(); }));
  tbody.querySelectorAll('button[data-action=view]').forEach(btn=>btn.addEventListener('click',()=>{ const r=lastRows[parseInt(btn.dataset.index,10)]; const badgeP=(p)=> p>=90?"<span class='badge bg-success'>✅ "+p+"%</span>":(p>=50?"<span class='badge bg-warning text-dark'>"+p+"%</span>":"<span class='badge bg-danger'>"+p+"%</span>"); document.getElementById('viewBody').innerHTML = `
    <div class='mb-2'><strong>${r.name}</strong> <span class='text-muted'>(${r.code}) — ${(r.department||'')} / ${(r.region||'')}</span></div>
    <div class='row g-2'>
      <div class='col-sm-6'><div class='card border-success'><div class='card-header bg-success text-white'>Asosiy oylik</div><div class='card-body'><div><strong>Summasi:</strong> ${fmt(r.base_amount)}</div><div><strong>Holat:</strong> ${r.base_confirmed?"<span class='badge bg-success'>Tasdiqlangan</span>":"<span class='badge bg-warning text-dark'>Kutilmoqda</span>"}</div></div></div></div>
      <div class='col-sm-6'><div class='card border-info'><div class='card-header bg-info text-white'>Umumiy natija</div><div class='card-body'><div><strong>Gross:</strong> ${fmt(r.gross)}</div><div><strong>Jarimalar:</strong> ${fmt(r.penalties_total)}</div><div class='h6 mt-2'><strong>NET:</strong> ${fmt(r.net)}</div></div></div></div>
    </div>
    <div class='card mt-3'><div class='card-header bg-primary text-white'>Reja / Amal / %</div><div class='card-body p-0'>
      <table class='table table-bordered table-sm mb-0 align-middle'><thead class='table-light'><tr><th>Ko‘rsatkich</th><th>Reja</th><th>Amal</th><th>%</th><th>Bonus</th></tr></thead><tbody>
        <tr><td>Qayta ishga tushirish</td><td>${r.reac_plan}</td><td>${r.reac_done}</td><td>${badgeP(r.reac_pct)}</td><td>${fmt(r.bonus_reactivation)}</td></tr>
        <tr><td>Yangi mijoz</td><td>${r.new_plan}</td><td>${r.new_done}</td><td>${badgeP(r.new_pct)}</td><td>${fmt(r.bonus_new)}</td></tr>
        <tr><td>Telegram (a'zo)</td><td>${r.tg_plan}</td><td>${r.tg_done}</td><td>${badgeP(r.tg_pct)}</td><td>${fmt(r.bonus_telegram)}</td></tr>
        <tr><td>Instagram (akkaunt)</td><td>${r.ig_acc_plan}</td><td>${r.ig_acc_done}</td><td>${badgeP(r.ig_acc_pct)}</td><td rowspan='2'>${fmt(r.bonus_instagram)}</td></tr>
        <tr><td>Instagram (video)</td><td>${r.ig_vid_plan}</td><td>${r.ig_vid_done}</td><td>${badgeP(r.ig_vid_pct)}</td></tr>
        <tr><td>Oqim hisobot</td><td colspan='2'>${r.flow_ok?'Topshirildi':'Topshirilmadi'}</td><td>${r.flow_ok?"<span class='badge bg-success'>✅</span>":"-"}</td><td>${fmt(r.bonus_flow_control)}</td></tr>
        <tr><td>Reyting</td><td colspan='2'>${r.rating_pos? (r.rating_pos+'-o‘rin') : '—'}</td><td>-</td><td>${fmt(r.bonus_rating)}</td></tr>
      </tbody></table>
    </div></div>`; new bootstrap.Modal(document.getElementById('viewModal')).show(); }));
  const labels=lastRows.map(x=>x.name), net=lastRows.map(x=>x.net), pen=lastRows.map(x=>x.penalties_total);
  if(window.netChart) window.netChart.destroy(); if(window.penChart) window.penChart.destroy();
  window.netChart=new Chart(document.getElementById('chartNet'),{type:'bar',data:{labels:labels,datasets:[{label:"Net (so'm)",data:net}]} ,options:{plugins:{legend:{display:false}}}});
  window.penChart=new Chart(document.getElementById('chartPen'),{type:'bar',data:{labels:labels,datasets:[{label:"Jarimalar (so'm)",data:pen}]} ,options:{plugins:{legend:{display:false}}}});
  updateExportLinks();
}
document.getElementById('refreshBtn').addEventListener('click', refresh);
document.addEventListener('DOMContentLoaded', ()=>{ loadOpFilter(); refresh(); });
document.addEventListener('input', (e)=>{ if(['ym','fOp','fDept','fReg','fQ'].indexOf(e.target.id)>=0) updateExportLinks(); });

// Approve save
document.getElementById('mSave').addEventListener('click', async ()=>{
  const body={ ym:document.getElementById('mYm').value, operator_id:parseInt(document.getElementById('mOpId').value,10), confirm:document.getElementById('mConfirm').checked?1:0, amount:parseInt(document.getElementById('mBaseAmount').value||'0',10) };
  const res=await fetch('../api/set_base_confirm.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)});
  const d=await res.json(); if(d.ok){ bootstrap.Modal.getInstance(document.getElementById('approveModal')).hide(); refresh(); } else alert('Xatolik: '+JSON.stringify(d));
});
</script>
</body></html>
