<?php require_once __DIR__ . '/../config.php'; require_operator(); ?>
<!doctype html><html lang="uz"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Hodim portali</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="bg-light">
<nav class="navbar navbar-dark" style="background:#20c997;"><div class="container">
  <a class="navbar-brand fw-bold" href="#">Hodim portali</a>
  <ul class="navbar-nav ms-auto flex-row gap-3"><li class="nav-item"><a class="nav-link" href="./logout.php">Chiqish</a></li></ul>
</div></nav>

<div class="container mt-2 d-flex gap-2"><button class="btn btn-outline-primary" id="btnSalary">Oylik tafsilotlari</button></div>

<div class="container my-3">
  <div class="card shadow-sm"><div class="card-body">
    <div class="row g-2">
      <div class="col-md-3"><label class="form-label">Oy</label><input type="month" id="ym" class="form-control" value="<?php echo date('Y-m'); ?>"></div>
      <div class="col-md-6"><label class="form-label">Plan</label><select id="plan" class="form-select"></select></div>
      <div class="col-md-3 text-end"><button id="refresh" class="btn btn-primary mt-4">Yuklash</button></div>
    </div>
  </div></div>
  <div id="items" class="mt-3"></div>
</div>

<div class="modal fade" id="salaryModal" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content">
  <div class="modal-header bg-dark text-white"><h5 class="modal-title">Oylik tafsilotlari</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
  <div class="modal-body"><div id="salaryBody"></div></div>
  <div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button></div>
</div></div></div>

<script>
async function sha256(file){ const buf=await file.arrayBuffer(); const h=await crypto.subtle.digest('SHA-256',buf); return Array.from(new Uint8Array(h)).map(b=>b.toString(16).padStart(2,'0')).join(''); }
async function loadPlans(){
  const ym=document.getElementById('ym').value;
  const r=await fetch('../api/op_my_plans.php?ym='+ym); const d=await r.json();
  const planSel=document.getElementById('plan'); planSel.innerHTML='';
  (d.plans||[]).forEach(x=>{ const opt=document.createElement('option'); opt.value=x.plan.id; opt.textContent=x.plan.name+' ('+d.ym+')'; planSel.appendChild(opt); });
}
async function loadItems(){
  const plan_id=document.getElementById('plan').value; const r=await fetch('../api/plans.php?action=list&plan_id='+plan_id); const data=await r.json(); const wrap=document.getElementById('items'); wrap.innerHTML='';
  if(!data.items||!data.items.length){ wrap.innerHTML="<div class='alert alert-warning'>Plan punktlari topilmadi</div>"; return; }
  data.items.forEach(it=>{
    const types=(it.evidence_types||'').split(',');
    let inputs=''; if(types.includes('text')) inputs+="<div class='mb-2'><label class='form-label'>Matn</label><textarea class='form-control' name='text_content'></textarea></div>";
    if(types.includes('username')) inputs+="<div class='mb-2'><label class='form-label'>Username</label><input class='form-control' name='username_ref'></div>";
    if(types.some(t=>['image','audio','video'].includes(t))) inputs+="<div class='mb-2'><label class='form-label'>Fayl</label><input type='file' class='form-control' name='file'></div>";
    wrap.insertAdjacentHTML('beforeend', `
      <div class="card mb-3"><div class="card-header bg-light d-flex justify-content-between"><div><strong>${it.title}</strong> <span class="text-muted">(reja: ${it.target_int??''})</span></div><div><span class="badge ${it.required?'bg-primary':'bg-secondary'}">${it.required?'Majburiy':'Ixtiyoriy'}</span></div></div>
      <div class="card-body"><form class="evidence" data-item="${it.id}">${inputs}
        <div class="d-flex gap-2"><button type="button" class="btn btn-success btn-sm upload">Yuborish</button><span class="dup text-danger fw-semibold d-none">⚠ Dublikat aniqlandi</span><span class="ok text-success fw-semibold d-none">✔ Saqlandi</span></div>
      </form></div></div>`);
  });
  document.querySelectorAll('form.evidence .upload').forEach(btn=>btn.addEventListener('click', async ()=>{
    const form=btn.closest('form.evidence'); const item_id=form.getAttribute('data-item'); const ym=document.getElementById('ym').value; const plan_id=document.getElementById('plan').value; const fd=new FormData();
    fd.append('plan_id',plan_id); fd.append('item_id',item_id); fd.append('ym',ym);
    const txt=form.querySelector('[name=text_content]'); if(txt) fd.append('text_content', txt.value);
    const usr=form.querySelector('[name=username_ref]'); if(usr) fd.append('username_ref', usr.value);
    const f=form.querySelector('[name=file]')?.files?.[0]||null; let hash=null; if(f){ hash=await sha256(f); }
    if(hash){ const r=await fetch('../api/submissions.php?action=check',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({plan_id:parseInt(plan_id,10),item_id:parseInt(item_id,10),ym,sha256:hash})}); const d=await r.json(); form.querySelector('.dup').classList.toggle('d-none', !d.exists); }
    if(f){ fd.append('file',f); fd.append('sha256', hash); }
    const r2=await fetch('../api/submissions.php?action=upload',{method:'POST', body:fd}); const d2=await r2.json(); if(d2.ok){ form.querySelector('.ok').classList.remove('d-none'); }
  }));
}

// Salary modal
document.getElementById('btnSalary').addEventListener('click', async ()=>{
  const ym=(document.getElementById('ym')||{value:(new Date().toISOString().slice(0,7))}).value;
  const r=await fetch('../api/op_salary_breakdown.php?ym='+ym); const d=await r.json(); const br=d.breakdown, m=d.metrics, t=d.targets;
  function fmt(n){ try { return new Intl.NumberFormat('uz-UZ').format(n)+' so\'m'; } catch(e){ return n+' so\'m'; } }
  const planCards=(d.plans||[]).map(p=>`
    <div class="card mb-2 border-success"><div class="card-header bg-success text-white d-flex justify-content-between"><div>${p.plan.name} (${d.ym})</div><div><span class="badge bg-light text-dark">${p.plan_pct??0}%</span></div></div>
      <div class="card-body p-0"><table class="table table-sm mb-0"><thead class="table-light"><tr><th>Punkt</th><th>Reja</th><th>Amal (tasdiqlangan)</th><th>%</th></tr></thead><tbody>
        ${p.items.map(it=>`<tr><td>${it.title}</td><td>${it.target_int??''}</td><td>${it.approved_count}</td><td>${(it.target_int?Math.round(it.approved_count*1000/it.target_int)/10:0)}%</td></tr>`).join('')}
      </tbody></table></div></div>`).join('');
  const attRows=(d.attendance||[]).map(a=>`<tr><td>${a.day}</td><td>${a.time_in||''}</td><td>${a.time_out||''}</td><td>${a.late_minutes||0}</td><td>${a.note||''}</td></tr>`).join('');
  document.getElementById('salaryBody').innerHTML = `
    <div class="row g-2">
      <div class="col-sm-4"><div class="card border-primary"><div class="card-header bg-primary text-white">Asosiy oylik</div><div class="card-body"><div><strong>Summasi:</strong> ${fmt(br.base_amount)}</div><div><strong>Holat:</strong> ${br.base_confirmed ? "<span class='badge bg-success'>Tasdiqlangan</span>" : "<span class='badge bg-warning text-dark'>Kutilmoqda</span>"}</div></div></div></div>
      <div class="col-sm-8"><div class="card border-info"><div class="card-header bg-info text-white">Bonuslar</div><div class="card-body">
        <div>Qayta ishga tushirish: ${fmt(br.bonus_reactivation)} <span class="text-muted">(Reja ${t.target_reactivation}/${m.reac_count||0})</span></div>
        <div>Yangi mijoz: ${fmt(br.bonus_new)} <span class="text-muted">(Reja ${t.target_new}/${m.new_count||0})</span></div>
        <div>Oqim hisobot: ${fmt(br.bonus_flow_control)} ${m.flow_report_submitted? "✅": ""}</div>
        <div>Telegram: ${fmt(br.bonus_telegram)} <span class="text-muted">(Reja ${t.telegram_target}/${m.telegram_added||0})</span></div>
        <div>Instagram: ${fmt(br.bonus_instagram)} <span class="text-muted">(Acc ${t.insta_accounts_target}/${m.insta_accounts||0}; Video ${t.insta_videos_target}/${m.insta_videos||0})</span></div>
        <div>Reyting: ${fmt(br.bonus_rating)} ${m.rating_position?("("+m.rating_position+"-o‘rin)"):""}</div>
      </div></div></div>
    </div>
    <div class="row g-2 mt-2">
      <div class="col-sm-6"><div class="card border-warning"><div class="card-header bg-warning">Jarimalar</div><div class="card-body">
        <div>Kechikish: ${m.late_minutes||0} daqiqa × 300 = ${fmt((m.late_minutes||0)*300)}</div>
        <div>Sababsiz: ${m.absent_days||0} kun × 100 000 = ${fmt((m.absent_days||0)*100000)}</div>
        <div>Qo‘pol muomala: ${m.bad_comm_count||0} × 30 000 = ${fmt((m.bad_comm_count||0)*30000)}</div>
        <div>Ma’lumot yo‘q: ${m.missing_info_count||0} × 20 000 = ${fmt((m.missing_info_count||0)*20000)}</div>
        <div>Qo‘shimcha jarima: ${fmt(m.other_penalty||0)}</div>
      </div></div></div>
      <div class="col-sm-6"><div class="card border-success"><div class="card-header bg-success text-white">Yakun</div><div class="card-body">
        <div><strong>Gross:</strong> ${fmt(br.gross)}</div><div><strong>Jami jarimalar:</strong> ${fmt(br.penalties_total)}</div><div class="h5 mt-2"><strong>NET:</strong> ${fmt(br.net)}</div>
      </div></div></div>
    </div>
    <div class="card mt-3"><div class="card-header bg-secondary text-white">Planlar</div><div class="card-body">${planCards || "<div class='text-muted'>Plan topilmadi</div>"}</div></div>
    <div class="card mt-3"><div class="card-header bg-dark text-white">Keldi-ketdi</div><div class="card-body p-0"><table class="table table-sm mb-0"><thead class="table-light"><tr><th>Kun</th><th>Kelish</th><th>Ketish</th><th>Kechikish (min)</th><th>Izoh</th></tr></thead><tbody>${attRows || "<tr><td colspan='5' class='text-muted'>Ma'lumot yo‘q</td></tr>"}</tbody></table></div></div>
  `;
  new bootstrap.Modal(document.getElementById('salaryModal')).show();
});

document.getElementById('refresh').addEventListener('click', loadItems);
window.addEventListener('DOMContentLoaded', ()=>{ loadPlans(); loadItems(); });
</script>
</body></html>
