<?php require_once __DIR__ . '/../config.php'; require_admin(); ?>
<!doctype html><html lang="uz"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Plan konstruktor</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="bg-light">
<nav class="navbar navbar-dark" style="background:#198754;"><div class="container">
  <a class="navbar-brand fw-bold" href="./dashboard.php">Oylik Hisob</a>
  <ul class="navbar-nav ms-auto flex-row gap-3">
    <li class="nav-item"><a class="nav-link" href="./operators.php">Operatorlar</a></li>
    <li class="nav-item"><a class="nav-link" href="./admin_review.php">Tekshirish</a></li>
    <li class="nav-item"><a class="nav-link" href="./logout.php">Chiqish</a></li>
  </ul>
</div></nav>

<div class="container my-3">
  <div class="row g-3">
    <div class="col-lg-4">
      <div class="card shadow-sm"><div class="card-body">
        <h5>Yangi plan</h5>
        <div class="mb-2"><label class="form-label">Oy</label><input type="month" id="ym" class="form-control" value="<?php echo date('Y-m'); ?>"></div>
        <div class="mb-2"><label class="form-label">Nomi</label><input id="pname" class="form-control"></div>
        <div class="mb-2"><label class="form-label">Tavsif</label><textarea id="pdesc" class="form-control"></textarea></div>
        <button id="mk" class="btn btn-success">Plan yaratish</button>
        <div id="mkmsg" class="text-success mt-2"></div>
      </div></div>

      <div class="card shadow-sm mt-3"><div class="card-body">
        <h5>Biriktirish</h5>
        <div class="mb-2"><label class="form-label">Plan ID</label><input id="plan_id" class="form-control" placeholder="plan_id"></div>
        <div class="mb-2"><label class="form-label">Operator ID</label><input id="op_id" class="form-control" placeholder="operator_id"></div>
        <button id="as" class="btn btn-outline-primary">Biriktir</button>
        <div id="asmsg" class="text-success mt-2"></div>
      </div></div>
    </div>

    <div class="col-lg-8">
      <div class="card shadow-sm"><div class="card-body">
        <h5>Punkt qo‘shish</h5>
        <div class="row g-2">
          <div class="col-md-3"><input id="pid" class="form-control" placeholder="plan_id"></div>
          <div class="col-md-5"><input id="title" class="form-control" placeholder="Sarlavha (mas: Telegram)"></div>
          <div class="col-md-2"><input id="target" class="form-control" placeholder="Reja (son)"></div>
          <div class="col-md-2"><input id="sort" class="form-control" placeholder="Tartib"></div>
        </div>
        <div class="mt-2">
          <label class="form-label">Dalil turlari</label>
          <div class="d-flex gap-3 flex-wrap">
            <label class="form-check"><input class="form-check-input" type="checkbox" value="text"> Matn</label>
            <label class="form-check"><input class="form-check-input" type="checkbox" value="username"> Username</label>
            <label class="form-check"><input class="form-check-input" type="checkbox" value="image"> Rasm</label>
            <label class="form-check"><input class="form-check-input" type="checkbox" value="audio"> Audio</label>
            <label class="form-check"><input class="form-check-input" type="checkbox" value="video"> Video</label>
          </div>
          <div class="form-check mt-2"><input class="form-check-input" type="checkbox" id="req" checked><label class="form-check-label" for="req">Majburiy</label></div>
          <div class="mb-2"><textarea id="desc" class="form-control" placeholder="Tavsif (ixtiyoriy)"></textarea></div>
          <button id="addItem" class="btn btn-primary">Punkt qo‘shish</button>
          <div id="imsg" class="text-success mt-2"></div>
        </div>
      </div></div>
    </div>
  </div>
</div>

<script>
document.getElementById('mk').addEventListener('click', async ()=>{
  const r=await fetch('../api/plans.php?action=create',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({ym:document.getElementById('ym').value,name:document.getElementById('pname').value,description:document.getElementById('pdesc').value})});
  const d=await r.json(); if(d.plan_id){ document.getElementById('mkmsg').textContent='Plan ID: '+d.plan_id; document.getElementById('plan_id').value=d.plan_id; document.getElementById('pid').value=d.plan_id; }
});
document.getElementById('addItem').addEventListener('click', async ()=>{
  const checks=[...document.querySelectorAll('input[type=checkbox][value]')].filter(x=>x.checked).map(x=>x.value);
  const body={plan_id:parseInt(document.getElementById('pid').value,10),title:document.getElementById('title').value,description:document.getElementById('desc').value,target_int:parseInt(document.getElementById('target').value||'0',10),evidence_types:checks,required:document.getElementById('req').checked,sort_order:parseInt(document.getElementById('sort').value||'0',10)};
  const r=await fetch('../api/plans.php?action=add_item',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)});
  const d=await r.json(); document.getElementById('imsg').textContent = d.item_id ? ('Punkt ID: '+d.item_id) : 'Xato';
});
document.getElementById('as').addEventListener('click', async ()=>{
  const r=await fetch('../api/plans.php?action=assign',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({plan_id:parseInt(document.getElementById('plan_id').value,10),operator_id:parseInt(document.getElementById('op_id').value,10)})});
  const d=await r.json(); document.getElementById('asmsg').textContent = d.ok ? 'Biriktirildi' : 'Xato';
});
</script>
</body></html>
