<?php
if (session_status()===PHP_SESSION_NONE) session_start();
$CFG = require __DIR__.'/config.php';

$script = $_SERVER['SCRIPT_NAME'] ?? '/s2/public/index.php';
$base   = rtrim(str_replace('\\','/', dirname($script)), '/');
if ($base === '/' || $base === '\\') $base = '';
define('BASE_URL', $base);

// Autoload
spl_autoload_register(function($class){
  if (strpos($class,'App\\')!==0) return;
  $path = __DIR__ . '/../src/' . str_replace(['App\\','\\'],['','/'],$class) . '.php';
  if (file_exists($path)) require $path;
});

function url($r,$params=[]){ $q=http_build_query(array_merge(['r'=>$r],$params)); return 'index.php?'.$q; }
function asset($p){ return 'assets/'.ltrim($p,'/'); }
function db(){
  static $pdo=null; if ($pdo) return $pdo;
  $c = require __DIR__.'/config.php';
  $pdo = new PDO($c['db']['dsn'],$c['db']['user'],$c['db']['pass'],[
    PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC
  ]);
  return $pdo;
}
function flash($k,$v=null){ if($v===null){ if(!empty($_SESSION['flash'][$k])){$t=$_SESSION['flash'][$k];unset($_SESSION['flash'][$k]);return $t;} return null; } else { $_SESSION['flash'][$k]=$v; } }
function auth(){ return $_SESSION['auth'] ?? null; }
function require_login(){ if(!auth()){ header('Location: '.url('auth/login')); exit; } }
function can($perm){ $u=auth(); if(!$u) return false; if(($u['role']??'')==='ADMIN') return true; if(in_array('*',$u['perms']??[])) return true; return in_array($perm,$u['perms']??[]); }

// Soft delete helper -> recycle_bin
function soft_delete($table,$id,$pk='id'){
  $stm = db()->prepare("SELECT * FROM {$table} WHERE {$pk}=? LIMIT 1");
  $stm->execute([$id]); $row=$stm->fetch();
  if($row){
    $ins=db()->prepare("INSERT INTO recycle_bin(entity,entity_id,row_json,deleted_at) VALUES(?,?,?,NOW())");
    $ins->execute([$table,$id,json_encode($row,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)]);
    db()->prepare("DELETE FROM {$table} WHERE {$pk}=?")->execute([$id]);
  }
}


if (!defined('BASE_HREF')) {
  $scr = $_SERVER['PHP_SELF'] ?? ($_SERVER['SCRIPT_NAME'] ?? '/public/index.php');
  $bh  = rtrim(str_replace('\\','/', dirname($scr)), '/');
  if ($bh==='' || $bh=='/' || $bh=='\\') $bh='';
  define('BASE_HREF', $bh);
}
if (!function_exists('asset_url')){
  function asset_url($rel){ return BASE_HREF.'/assets/'.ltrim($rel,'/'); }
}
