
window.openModal = id => { const m=document.getElementById(id); if(!m) return; m.classList.add('modal-zoom'); const bs=new bootstrap.Modal(m); bs.show(); };
window.closeModal = id => { const m=document.getElementById(id); if(!m) return; const bs=bootstrap.Modal.getInstance(m); if(bs) bs.hide(); };
window.applyPhoneMask = (inp)=>{
  if(!inp) return;
  inp.addEventListener('input', ()=>{
    let v = inp.value.replace(/\D/g,'');
    if(!v.startsWith('998')) v = '998' + v;
    v = v.slice(0,12);
    const a = `+${v.slice(0,3)} ${v.slice(3,5)} ${v.slice(5,8)} ${v.slice(8,10)} ${v.slice(10,12)}`;
    inp.value = a.trim();
  });
};
window.bindMiniMap = (latInp, lngInp, frame)=>{
  function upd(){
    const la=parseFloat(latInp.value)||41.3111, lo=parseFloat(lngInp.value)||69.2797;
    const bbox = [lo-0.01,la-0.01,lo+0.01,la+0.01].join('%2C');
    frame.src = 'https://www.openstreetmap.org/export/embed.html?bbox='+bbox+'&layer=mapnik&marker='+la+'%2C'+lo;
  }
  latInp && latInp.addEventListener('change',upd);
  lngInp && lngInp.addEventListener('change',upd);
  upd();
};

function openModal(id){
  const el=document.getElementById(id);
  if(!el) return;
  if(window.bootstrap && bootstrap.Modal){
    const m=new bootstrap.Modal(el); m.show();
  }else{
    el.style.display='block'; el.classList.add('show'); document.body.classList.add('modal-open');
    const bk=document.createElement('div'); bk.id='__bk_'+id; bk.className='modal-backdrop fade show'; document.body.appendChild(bk);
  }
}
function closeModal(id){
  const el=document.getElementById(id);
  if(!el) return;
  if(window.bootstrap && bootstrap.Modal){
    const m=bootstrap.Modal.getInstance(el)||new bootstrap.Modal(el); m.hide();
  }else{
    el.style.display='none'; el.classList.remove('show'); document.body.classList.remove('modal-open');
    const bk=document.getElementById('__bk_'+id); if(bk) bk.remove();
  }
}


// ---- Number formatting (Uzbek space groups) ----
UI.nfmt = function(v, dec){
  if(v===null||v===undefined||v==='') return '';
  var n = parseFloat((''+v).replace(/\s/g,'')); if(isNaN(n)) return v;
  var d = (dec===undefined||dec===null)? (Math.floor(n)===n?0:2) : dec;
  return n.toLocaleString('ru-RU', {minimumFractionDigits:d, maximumFractionDigits:d}).replace(/\u00A0/g,' ');
};
UI.formatNumbers = function(rootEl){
  (rootEl||document).querySelectorAll('.num, [data-num]').forEach(function(el){
    var dec = el.dataset.dec || el.getAttribute('data-dec') || el.getAttribute('data-num') || null;
    var raw = el.getAttribute('data-raw') || el.textContent.trim();
    el.textContent = UI.nfmt(raw, dec?parseInt(dec):undefined);
  });
};
document.addEventListener('DOMContentLoaded', ()=> UI.formatNumbers());

// ---- Intercept data-confirm links to show modal ----
document.addEventListener('click', function(e){
  var a = e.target.closest('a[data-confirm]'); if(!a) return;
  e.preventDefault();
  var txt = a.getAttribute('data-confirm') || 'Amalni tasdiqlaysizmi?';
  var cm = document.getElementById('confirmModal'); var ct=document.getElementById('confirmText'); var go=document.getElementById('confirmGo');
  ct.textContent = txt; go.setAttribute('href', a.getAttribute('href'));
  openModal('confirmModal');
});

// ---- Toast helper ----
UI.toast = function(msg, ok){
  var t = document.getElementById('toastBox'); if(!t) return alert(msg);
  document.getElementById('toastMsg').textContent = msg;
  t.classList.remove('text-bg-danger','text-bg-success');
  t.classList.add(ok===false?'text-bg-danger':'text-bg-success');
  var inst = window.bootstrap? bootstrap.Toast.getOrCreateInstance(t): null;
  if(inst) inst.show(); else { t.style.display='block'; setTimeout(()=>t.style.display='none', 2500); }
};

// ---- Inputs: auto-format on blur for .num-input ----
document.addEventListener('blur', function(e){
  var inp = e.target.closest('input.num-input'); if(!inp) return;
  var dec=parseInt(inp.dataset.dec||'2'); var v = inp.value.replace(/\s/g,'');
  if(v==='') return; if(isNaN(parseFloat(v))) return;
  inp.value = UI.nfmt(v, dec);
}, true);

// ---- Edit-in-modal pattern ----
document.addEventListener('click', function(e){
  var b = e.target.closest('[data-modal]'); if(!b) return;
  var mid = b.getAttribute('data-modal'); var fill = b.getAttribute('data-fill');
  if(mid && fill){ try{ var obj=JSON.parse(fill); for(let k in obj){ var el=document.querySelector(mid+" [name='"+k+"']"); if(el) el.value=obj[k]; } }catch(err){} }
  var act = b.getAttribute('data-action'); if(act){ var fm=document.querySelector(mid+' form'); if(fm) fm.setAttribute('action', act); }
  openModal(mid.replace('#',''));
});
