<?php
namespace App\Controllers\Admin;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class RolesController extends Controller{
  private function colExists($t,$c){
    $q=db()->prepare("SELECT COUNT(*) c FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name=? AND column_name=?");
    $q->execute([$t,$c]); return $q->fetch()['c']>0;
  }
  public function matrix(){ require_login();
    $roles = db()->query("SELECT * FROM roles ORDER BY id")->fetchAll();
    $perms = db()->query("SELECT * FROM permissions ORDER BY code")->fetchAll();
    $granted=[];
    if($this->colExists('role_permissions','role_code')){
      foreach(db()->query("SELECT role_code, perm_code FROM role_permissions")->fetchAll() as $x){ $granted[$x['role_code']][$x['perm_code']]=1; }
    } elseif($this->colExists('role_permissions','role_id')){
      foreach(db()->query("SELECT r.code role_code, p.code perm_code FROM role_permissions rp JOIN roles r ON r.id=rp.role_id JOIN permissions p ON p.id=rp.permission_id")->fetchAll() as $x){ $granted[$x['role_code']][$x['perm_code']]=1; }
    } else {
      db()->exec("CREATE TABLE IF NOT EXISTS role_permissions ( role_code VARCHAR(40) NOT NULL, perm_code VARCHAR(120) NOT NULL, PRIMARY KEY(role_code,perm_code) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
    }
    $this->view('admin/roles_matrix', compact('roles','perms','granted'));
  }
  public function save(){ require_login();
    $role = $_POST['role_code'];
    if($this->colExists('role_permissions','role_code')){
      db()->prepare("DELETE FROM role_permissions WHERE role_code=?")->execute([$role]);
      $ins=db()->prepare("INSERT INTO role_permissions(role_code,perm_code) VALUES(?,?)");
      foreach(($_POST['perm']??[]) as $p){ $ins->execute([$role,$p]); }
    }else{
      // legacy schema - ignore save or migrate
      db()->exec("CREATE TABLE IF NOT EXISTS role_permissions ( role_code VARCHAR(40) NOT NULL, perm_code VARCHAR(120) NOT NULL, PRIMARY KEY(role_code,perm_code) )");
      db()->prepare("DELETE FROM role_permissions WHERE role_code=?")->execute([$role]);
      $ins=db()->prepare("INSERT INTO role_permissions(role_code,perm_code) VALUES(?,?)");
      foreach(($_POST['perm']??[]) as $p){ $ins->execute([$role,$p]); }
    }
    flash('ok','Ruxsatlar saqlandi'); $this->redirect('admin/roles/matrix');
  }
}
