<?php
namespace App\Core;
require_once __DIR__.'/../../config/bootstrap.php';

class Router {
  public static function dispatch(){
    $r = $_GET['r'] ?? 'admin/dashboard/index';
    $parts = array_values(array_filter(explode('/', $r)));
    if (count($parts) < 2) { http_response_code(400); echo 'Bad route format. Use ?r=module/controller/action'; exit; }
    if (count($parts)===2) $parts[]='index';
    list($module,$controller,$action) = $parts;
    $class = 'App\\Controllers\\'.self::studly($module).'\\'.self::studly($controller).'Controller';
    if (!class_exists($class)) { http_response_code(404); echo 'Controller topilmadi: '.$class; exit; }
    $obj = new $class();
    if (!method_exists($obj,$action)) { http_response_code(404); echo 'Action topilmadi: '.$class.'::'.$action; exit; }
    return $obj->$action();
  }
  private static function studly($s){ return str_replace(' ','', ucwords(str_replace(['-','_'],' ', $s))); }
}
