
<div class="d-flex justify-content-between align-items-center mb-2">
  <h5><svg width="18" height="18"><use xlink:href="#i-users"/></svg> Foydalanuvchilar</h5>
  <button class="btn btn-primary" onclick="openModal('userCreate')">+ Yangi foydalanuvchi</button>
</div>
<?php $rows = $rows ?? (db()->query("SELECT u.*, r.name rname FROM users u LEFT JOIN roles r ON r.id=u.role_id ORDER BY u.id DESC")->fetchAll()); ?>
<div class="card p-2">
<table class="table table-striped"><thead><tr><th>ID</th><th>Login</th><th>FIO</th><th>Rol</th><th>Filial</th><th>Ombor</th><th>Holat</th><th></th></tr></thead>
<tbody><?php foreach($rows as $r): ?><tr>
  <td><?= $r['id'] ?></td><td><?= htmlspecialchars($r['username']) ?></td><td><?= htmlspecialchars($r['full_name']) ?></td><td><?= htmlspecialchars($r['rname']) ?></td>
  <td><?= htmlspecialchars($r['branch_id']) ?></td><td><?= htmlspecialchars($r['warehouse_id']) ?></td><td><?= htmlspecialchars($r['status'] ?? 'ACTIVE') ?></td>
  <td>
    <a class="btn btn-sm btn-outline-primary" href="<?= url('admin/users/edit',['id'=>$r['id']]) ?>">Tahrirlash</a>
    <a class="btn btn-sm btn-outline-danger" href="<?= url('admin/users/delete',['id'=>$r['id']]) ?>">O‘chirish</a>
  </td>
</tr><?php endforeach; ?></tbody></table>
</div>

<div class="modal" id="userCreate"><div class="modal-dialog modal-lg"><div class="modal-content">
  <div class="modal-header"><h5><svg width="18" height="18"><use xlink:href="#i-users"/></svg> Yangi foydalanuvchi</h5><button class="btn-close" onclick="closeModal('userCreate')"></button></div>
  <form id="userForm" method="post" action="<?= url('admin/users/store') ?>"><input type="hidden" name="id">
  <div class="modal-body">
    <div class="row g-3">
      <div class="col-md-8">
        <fieldset class="section">
          <legend class="section-title">Asosiy ma’lumotlar</legend>
          <div class="row g-2">
            <div class="col-md-6"><label class="form-label">Login</label><input name="username" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">To‘liq ism (FIO)</label><input name="full_name" class="form-control"></div>
            <div class="col-md-6"><label class="form-label">Parol</label><input name="password" type="password" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Rol</label><select name="role_id" class="form-select"><?php foreach(db()->query("SELECT id,name FROM roles ORDER BY name")->fetchAll() as $ro): ?><option value="<?= $ro['id'] ?>"><?= htmlspecialchars($ro['name']) ?></option><?php endforeach; ?></select></div>
          </div>
        </fieldset>
        <fieldset class="section">
          <legend class="section-title">Bog‘lanish & joylashuv</legend>
          <div class="row g-2">
            <div class="col-md-6 input-with-icon"><label class="form-label">Telefon</label>
              <div class="input-group">
                <span class="input-group-text"><svg width="16" height="16"><use xlink:href="#i-phone"/></svg></span>
                <input name="phone" id="u_phone" class="form-control" placeholder="+998 90 123 45 67">
              </div>
            </div>
            <div class="col-md-6"><label class="form-label">Email</label><input name="email" type="email" class="form-control" placeholder="user@example.com"></div>
            <div class="col-md-6"><label class="form-label">Filial</label><select name="branch_id" class="form-select"><?php foreach(db()->query("SELECT id,code,name FROM branches ORDER BY name")->fetchAll() as $b): ?><option value="<?= $b['id'] ?>"><?= $b['code'] ?> — <?= htmlspecialchars($b['name']) ?></option><?php endforeach; ?></select></div>
            <div class="col-md-6"><label class="form-label">Ombor</label><select name="warehouse_id" class="form-select"><?php foreach(db()->query("SELECT id,code,name FROM warehouses ORDER BY name")->fetchAll() as $w): ?><option value="<?= $w['id'] ?>"><?= $w['code'] ?> — <?= htmlspecialchars($w['name']) ?></option><?php endforeach; ?></select></div>
          </div>
        </fieldset>
        <fieldset class="section">
          <legend class="section-title">Ruxsatlar (CRUD)</legend>
          <div class="row">
            <?php
            $mods=['sales.orders','sales.invoices','sales.shipments','purchase.orders','purchase.grn','inventory.stock','catalog.products','catalog.customers','catalog.suppliers','finance.gl','finance.bank','reports.pivot','approvals.core'];
            $ops=['create','read','update','delete','export'];
            foreach($mods as $m): ?>
              <div class="col-6 col-md-4">
                <div class="form-check"><input class="form-check-input" type="checkbox" name="perms[]" value="<?= $m ?>.*" id="p-<?= $m ?>-all"><label class="form-check-label" for="p-<?= $m ?>-all"><b><?= $m ?></b></label></div>
                <div class="ms-3">
                  <?php foreach($ops as $o): $v="$m.$o"; $id="p-".str_replace('.','-',$v); ?>
                    <div class="form-check form-check-sm"><input class="form-check-input" type="checkbox" name="perms[]" value="<?= $v ?>" id="<?= $id ?>"><label class="form-check-label" for="<?= $id ?>"><?= strtoupper($o) ?></label></div>
                  <?php endforeach; ?>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </fieldset>
      </div>
      <div class="col-md-4">
        <fieldset class="section">
          <legend class="section-title">Profil</legend>
          <div class="text-center mb-2">
            <img id="u_avatar_prev" class="avatar-preview" src="https://i.pravatar.cc/64?img=3" alt="avatar">
          </div>
          <label class="form-label">Avatar URL</label>
          <input name="avatar" id="u_avatar" class="form-control" value="https://i.pravatar.cc/64?img=3" oninput="u_avatar_prev.src=this.value">
          <label class="form-label mt-2">Holat</label>
          <select name="status" class="form-select"><option value="ACTIVE">ACTIVE</option><option value="BLOCKED">BLOCKED</option></select>
        </fieldset>
      </div>
    </div>
  </div>
  <div class="modal-footer">
    <button class="btn btn-secondary" type="button" onclick="closeModal('userCreate')">Bekor</button>
    <button class="btn btn-primary">Saqlash</button>
  </div>
  </form>
</div></div></div>
<script>
applyPhoneMask(document.getElementById('u_phone'));
</script>
