<?php
if (session_status()===PHP_SESSION_NONE) session_start();

$__cfg = require __DIR__ . '/config.php';

if (!defined('BASE_URL')) {
  $script = $_SERVER['SCRIPT_NAME'] ?? '/public/index.php';
  $base   = rtrim(str_replace('\\','/', dirname($script)), '/');
  if ($base==='/' || $base==='\\') $base = '';
  define('BASE_URL', $base);
}

spl_autoload_register(function($class){
  if (strpos($class, 'App\\')!==0) return;
  $path = __DIR__ . '/../src/' . str_replace(['App\\','\\'], ['','/'], $class) . '.php';
  if (file_exists($path)) require $path;
});

if (!function_exists('url')) {
  function url($r, $params=[]){
    $q = http_build_query(array_merge(['r'=>$r], $params));
    return 'index.php?'.$q;
  }
}
if (!function_exists('asset')) {
  function asset($path){ return 'assets/'.ltrim($path,'/'); }
}
if (!function_exists('db')) {
  function db(){
    static $pdo=null; if ($pdo) return $pdo;
    $cfg = require __DIR__.'/config.php';
    $pdo = new PDO($cfg['db']['dsn'],$cfg['db']['user'],$cfg['db']['pass'],[
      PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC
    ]);
    return $pdo;
  }
}
if (!function_exists('flash')) {
  function flash($k,$v=null){
    if ($v===null){ if(!empty($_SESSION['flash'][$k])){$val=$_SESSION['flash'][$k]; unset($_SESSION['flash'][$k]); return $val;} return null; }
    $_SESSION['flash'][$k]=$v;
  }
}
if (!function_exists('auth')) {
  function auth(){ return $_SESSION['auth'] ?? null; }
}
if (!function_exists('require_login')) {
  function require_login(){ if (!auth()){ header('Location: '.url('auth/login')); exit; } }
}
if (!function_exists('nf')) {
  function nf($v, $dec=0){ if ($v===null || $v==='') return '0'; return number_format((float)$v, $dec, '.', ' '); }
}
if (!function_exists('soft_delete')) {
  function soft_delete($table,$id){
    $pdo=db();
    $row=$pdo->prepare("SELECT * FROM {$table} WHERE id=?"); $row->execute([$id]); $row=$row->fetch();
    if($row){ $pdo->prepare("INSERT INTO recycle_bin(entity,entity_id,payload) VALUES(?,?,?)")->execute([$table,$id,json_encode($row)]); }
    $pdo->prepare("DELETE FROM {$table} WHERE id=?")->execute([$id]);
  }
}
