
window.UI=(function(){
  const toggleSidebar=()=>{ const s=document.getElementById('sidebar'); if(s) s.classList.toggle('open'); };
  const phoneMask=(inp)=>{ if(!inp) return; inp.addEventListener('input',()=>{ let v=inp.value.replace(/\D/g,''); if(v.startsWith('998')) v='+'+v; else if(v.length>0 && v[0]!='+') v='+998'+v; inp.value=v; }); };
  const initLeaflet=(elId,latInp,lngInp)=>{ if(!window.L) return; const lat=parseFloat(document.getElementById(latInp)?.value||'41.3111')||41.3111; const lng=parseFloat(document.getElementById(lngInp)?.value||'69.2797')||69.2797; const m=L.map(elId).setView([lat,lng],12); L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',{maxZoom:19}).addTo(m); const mk=L.marker([lat,lng],{draggable:true}).addTo(m); mk.on('dragend',()=>{ const p=mk.getLatLng(); document.getElementById(latInp).value=p.lat.toFixed(6); document.getElementById(lngInp).value=p.lng.toFixed(6); }); m.on('click',(e)=>{ mk.setLatLng(e.latlng); document.getElementById(latInp).value=e.latlng.lat.toFixed(6); document.getElementById(lngInp).value=e.latlng.lng.toFixed(6); }); setTimeout(()=>m.invalidateSize(),200); return m; };
  const ensureItemsTable=()=>{ window.ItemsTable=window.ItemsTable||{init(){}}; };
  const nf=(v,dec)=>{ if(v===null||v===undefined||v==='') return '0'; let num=parseFloat((''+v).replace(/\s/g,'')); if(!isFinite(num)) return v; const fixed=dec===undefined? num.toFixed(0):num.toFixed(dec); return fixed.replace(/\B(?=(\d{3})+(?!\d))/g,' '); };
  const formatAllNumbers=()=>{
    document.querySelectorAll('.num').forEach(td=>{ const dec=parseInt(td.getAttribute('data-nf-decimals')||'0'); const raw=td.getAttribute('data-raw')||td.textContent.trim(); td.textContent=nf(raw,isNaN(dec)?0:dec); });
    document.querySelectorAll('input.nf-input').forEach(inp=>{ const dec=parseInt(inp.getAttribute('data-nf-decimals')||'0'); inp.addEventListener('blur', ()=>{ inp.value=nf(inp.value,dec); }); inp.addEventListener('focus',()=>{ inp.value=(''+inp.value).replace(/\s/g,''); }); });
  };
  const modalLoad=(url,title='Tahrirlash')=>{
    const body=document.getElementById('glModalBody'); const ttl=document.getElementById('glModalTitle');
    ttl.textContent=title; body.innerHTML='<div class="text-center p-4">Yuklanmoqda...</div>';
    if(url.indexOf('partial=1')<0){ url+=(url.indexOf('?')>=0?'&':'?')+'partial=1'; }
    fetch(url,{headers:{'X-Requested-With':'XMLHttpRequest'}}).then(r=>r.text()).then(html=>{ body.innerHTML=html; formatAllNumbers(); }).catch(e=>{ body.innerHTML='<div class="alert alert-danger">Yuklab bo‘lmadi</div>'; });
    openModal('glModal');
  };
  const bindDelegates=()=>{
    document.body.addEventListener('click',e=>{
      const a=e.target.closest('[data-modal]'); if(a){ e.preventDefault(); modalLoad(a.getAttribute('href')||a.getAttribute('data-url'), a.getAttribute('data-title')||a.textContent.trim()); }
      const c=e.target.closest('[data-confirm]'); if(c){ e.preventDefault(); const txt=c.getAttribute('data-confirm')||'Tasdiqlaysizmi?'; const href=c.getAttribute('href')||c.getAttribute('data-href'); document.getElementById('confirmText').textContent=txt; document.getElementById('confirmGo').setAttribute('href', href); openModal('confirmModal'); }
    });
  };
  const toggleTheme=()=>{ const rt=document.documentElement; const cur=rt.getAttribute('data-theme')||'light'; const nxt=(cur==='light'?'dark':'light'); rt.setAttribute('data-theme',nxt); try{localStorage.setItem('theme',nxt);}catch(e){} };
  return {toggleSidebar,phoneMask,initLeaflet,ensureItemsTable,formatAllNumbers,modalLoad,bindDelegates,toggleTheme,nf};
})(); document.addEventListener('DOMContentLoaded',()=>{ try{const th=localStorage.getItem('theme')||'light'; document.documentElement.setAttribute('data-theme',th);}catch(e){document.documentElement.setAttribute('data-theme','light');} UI.ensureItemsTable(); UI.bindDelegates(); UI.formatAllNumbers(); });
function openModal(id){ const el=document.getElementById(id); if(!el)return; if(window.bootstrap&&window.bootstrap.Modal){ new bootstrap.Modal(el).show(); return; } el.classList.add('show'); el.style.display='block'; el.removeAttribute('aria-hidden'); let bk=document.createElement('div'); bk.className='modal-backdrop fade show'; bk.id='bk-'+id; document.body.appendChild(bk); }
function closeModal(id){ const el=document.getElementById(id); if(!el)return; if(window.bootstrap&&window.bootstrap.Modal){ (bootstrap.Modal.getInstance(el)||new bootstrap.Modal(el)).hide(); return; } el.classList.remove('show'); el.style.display='none'; el.setAttribute('aria-hidden','true'); const bk=document.getElementById('bk-'+id); if(bk) bk.remove(); }
