<?php
namespace App\Controllers\Admin;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class DiagnosticsController extends Controller{
  private function existsCol($table,$col){
    $q=db()->prepare("SELECT COUNT(*) c FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name=? AND column_name=?");
    $q->execute([$table,$col]); return $q->fetch()['c']>0;
  }
  private function existsTable($table){
    $q=db()->prepare("SELECT COUNT(*) c FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name=?");
    $q->execute([$table]); return $q->fetch()['c']>0;
  }

  public function index(){ require_login(); $this->view('admin/diagnostics'); }
  public function migrate(){ require_login(); $sql=file_get_contents(__DIR__.'/../../../database/migrations.sql'); db()->exec($sql); flash('ok','Migratsiya bajarildi'); $this->redirect('admin/diagnostics/index'); }
  public function seed(){ require_login();
    // Ensure critical columns for seed
    if(!$this->existsCol('users','login')){ db()->exec("ALTER TABLE users ADD COLUMN login VARCHAR(60) UNIQUE NULL"); }
    if(!$this->existsCol('users','password')){ db()->exec("ALTER TABLE users ADD COLUMN password VARCHAR(255) NULL"); }
    if(!$this->existsCol('users','role')){ db()->exec("ALTER TABLE users ADD COLUMN role VARCHAR(40) NULL"); }
 $sql=file_get_contents(__DIR__.'/../../../database/seed.sql'); db()->exec($sql);
    $u=db()->prepare("SELECT * FROM users WHERE login='admin' LIMIT 1"); $u->execute(); if(!$u->fetch()){
      db()->prepare("INSERT INTO users(login,password,name,role,active) VALUES('admin', ?, 'Administrator', 'ADMIN', 1)")->execute([password_hash('admin123', PASSWORD_DEFAULT)]); }
    flash('ok','Seed bajarildi (admin/admin123)'); $this->redirect('admin/diagnostics/index'); }
  public function patch(){ require_login(); $pdo=db();
    // Ensure permissions & role_permissions tables
    $pdo->exec("CREATE TABLE IF NOT EXISTS permissions (id INT AUTO_INCREMENT PRIMARY KEY, code VARCHAR(120) UNIQUE NOT NULL, name VARCHAR(180) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    $pdo->exec("CREATE TABLE IF NOT EXISTS role_permissions (role_code VARCHAR(40) NULL, perm_code VARCHAR(120) NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    // Add missing columns
    $addc=function($t,$c,$ddl) use($pdo){ $q=$pdo->prepare("SELECT COUNT(*) c FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name=? AND column_name=?"); $q->execute([$t,$c]); if($q->fetch()['c']==0){ $pdo->exec("ALTER TABLE {$t} ADD COLUMN {$ddl}"); } };
    $addc('role_permissions','role_code',"role_code VARCHAR(40) NULL");
    $addc('role_permissions','perm_code',"perm_code VARCHAR(120) NULL");
    // Try migrate from role_id/perm_id if present
    $hasRid=$this->existsCol('role_permissions','role_id'); $hasPid=$this->existsCol('role_permissions','perm_id');
    if($hasRid){ $pdo->exec("UPDATE role_permissions rp JOIN roles r ON r.id=rp.role_id SET rp.role_code=r.code WHERE rp.role_code IS NULL"); }
    if($hasPid){ $pdo->exec("UPDATE role_permissions rp JOIN permissions p ON p.id=rp.perm_id SET rp.perm_code=p.code WHERE rp.perm_code IS NULL"); }
    // Add PK if not exists
    try{ $pdo->exec("ALTER TABLE role_permissions ADD PRIMARY KEY (role_code, perm_code)"); }catch(\Throwable $e){}

    $add=function($t,$c,$ddl) use($pdo){ $q=$pdo->prepare("SELECT COUNT(*) c FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name=? AND column_name=?"); $q->execute([$t,$c]); if($q->fetch()['c']==0) $pdo->exec("ALTER TABLE {$t} ADD COLUMN {$ddl}"); };
    $add('users','phone',"phone VARCHAR(40) NULL");
    $add('users','email',"email VARCHAR(120) NULL");
    $add('users','branch_id',"branch_id INT NULL");
    $add('users','warehouse_id',"warehouse_id INT NULL");
    $add('users','active',"active TINYINT NOT NULL DEFAULT 1");
    $add('customers','avatar',"avatar VARCHAR(255) NULL");
    $add('customers','lat',"lat DECIMAL(10,6) NULL");
    $add('customers','lng',"lng DECIMAL(10,6) NULL");
    $add('products','avatar',"avatar VARCHAR(255) NULL");
    flash('ok','Patch bajarildi'); $this->redirect('admin/diagnostics/index'); }
}
