
<div class="d-flex justify-content-between align-items-center mb-2">
  <h5><i class="bi bi-people"></i> Mijozlar</h5>
  <button class="btn btn-primary" onclick="openModal('custModal')"><i class="bi bi-person-plus"></i> Yangi mijoz</button>
</div>
<table class="table table-striped">
  <thead><tr><th></th><th>Kod</th><th>Nomi</th><th>Telefon</th><th>Hudud</th><th>Manzil</th><th>Amal</th></tr></thead>
  <tbody>
  <?php foreach($list as $r): $avatar = $r['avatar'] ?: ('https://api.dicebear.com/6.x/initials/svg?seed='.urlencode($r['name'])); ?>
    <tr>
      <td><img src="<?= htmlspecialchars($avatar) ?>" style="width:32px;height:32px;border-radius:50%;object-fit:cover" alt=""></td>
      <td><?= htmlspecialchars($r['code']) ?></td>
      <td><?= htmlspecialchars($r['name']) ?></td>
      <td><?= htmlspecialchars($r['phone']) ?></td>
      <td><?= htmlspecialchars($r['region']) ?></td>
      <td><?= htmlspecialchars($r['address']) ?></td>
      <td>
        <a class="btn btn-sm btn-outline-primary" href="<?= url('catalog/customers/edit',['id'=>$r['id']]) ?>"><i class="bi bi-pencil"></i></a>
        <a class="btn btn-sm btn-outline-danger" href="<?= url('catalog/customers/delete',['id'=>$r['id']]) ?>" onclick="return confirm('O‘chirsinmi?')"><i class="bi bi-trash"></i></a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>

<div class="modal fade" id="custModal" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content">
  <div class="modal-header"><h5 class="modal-title"><i class="bi bi-person-vcard"></i> Mijoz kartochkasi</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
  <form method="post" action="<?= url('catalog/customers/store') ?>"><div class="modal-body"><div class="row g-3">
    <div class="col-md-3 text-center">
      <img id="custAvatarPreview" src="https://cdn.jsdelivr.net/gh/feathericons/feather/icons/user.svg" style="width:90px;height:90px;border-radius:50%;background:#0f1b14;padding:10px">
      <div class="mt-2 small text-muted">Default avatar (URL orqali ham bo‘ladi)</div>
      <input class="form-control form-control-sm mt-2" name="avatar" placeholder="https://... (ixtiyoriy)" oninput="document.getElementById('custAvatarPreview').src=this.value||'https://cdn.jsdelivr.net/gh/feathericons/feather/icons/user.svg'">
    </div>
    <div class="col-md-9"><div class="row g-2">
      <div class="col-md-4"><label class="form-label"><i class="bi bi-upc"></i> Kod</label><input name="code" class="form-control" required></div>
      <div class="col-md-8"><label class="form-label"><i class="bi bi-person"></i> Nomi</label><input name="name" class="form-control" required></div>
      <div class="col-md-4"><label class="form-label"><i class="bi bi-telephone"></i> Telefon</label><input id="custPhone" name="phone" class="form-control" placeholder="+998..."></div>
      <div class="col-md-4"><label class="form-label"><i class="bi bi-envelope"></i> Email</label><input name="email" class="form-control"></div>
      <div class="col-md-4"><label class="form-label"><i class="bi bi-geo-alt"></i> Hudud</label><input name="region" class="form-control"></div>
      <div class="col-md-12"><label class="form-label"><i class="bi bi-signpost"></i> Manzil</label><input name="address" class="form-control"></div>
      <div class="col-md-3"><label class="form-label"><i class="bi bi-pin-map"></i> Lat</label><input id="custLat" name="lat" class="form-control" value="41.3111"></div>
      <div class="col-md-3"><label class="form-label"><i class="bi bi-pin-map-fill"></i> Lng</label><input id="custLng" name="lng" class="form-control" value="69.2797"></div>
      <div class="col-md-6"><label class="form-label"><i class="bi bi-map"></i> Kichik xarita</label><div id="custMap" style="height:180px;border-radius:10px;overflow:hidden;border:1px solid var(--gl-border)"></div></div>
    </div></div>
  </div></div><div class="modal-footer"><button class="btn btn-secondary" data-bs-dismiss="modal">Bekor</button><button class="btn btn-primary">Saqlash</button></div></form>
</div></div></div>

<script>
document.addEventListener('DOMContentLoaded', ()=>{
  UI.phoneMask(document.getElementById('custPhone'));
  document.getElementById('custModal').addEventListener('shown.bs.modal', ()=> UI.initLeaflet('custMap','custLat','custLng'));
});
</script>
