-- Roles
INSERT INTO roles(code,name) VALUES
('ADMIN','Administrator'),('MANAGER','Menejer'),('WAREHOUSE','Omborchi'),('SALES','Sotuvchi'),('PURCHASE','Zakup'),('ACCOUNTANT','Buxgalter')
ON DUPLICATE KEY UPDATE name=VALUES(name);

-- Permissions
INSERT INTO permissions(code,name) VALUES
('customers.read','Mijozlarni ko‘rish'),('customers.write','Mijozlar CRUD'),
('products.read','Mahsulotlarni ko‘rish'),('products.write','Mahsulotlar CRUD'),
('orders.read','Buyurtmalarni ko‘rish'),('orders.write','Buyurtmalar CRUD'),
('invoices.read','Fakturalarni ko‘rish'),('invoices.write','Fakturalar CRUD'),
('shipments.read','Jo‘natmalarni ko‘rish'),('shipments.write','Jo‘natmalar CRUD'),
('po.read','PO ko‘rish'),('po.write','PO CRUD'),
('grn.read','GRN ko‘rish'),('grn.write','GRN CRUD'),
('ap.read','AP ko‘rish'),('ap.write','AP CRUD'),
('stock.read','Ombor ko‘rish'),('stock.write','Ombor yozish'),
('users.read','Foydalanuvchilar ko‘rish'),('users.write','Foydalanuvchilar CRUD')
ON DUPLICATE KEY UPDATE name=VALUES(name);

-- Role permissions (basic)
DELETE FROM role_permissions;
INSERT INTO role_permissions(role_id,perm_code)
SELECT r.id, 'customers.read' FROM roles r WHERE r.code IN('ADMIN','MANAGER','SALES');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'customers.write' FROM roles r WHERE r.code IN('ADMIN','MANAGER');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'products.read' FROM roles r WHERE r.code IN('ADMIN','MANAGER','SALES','PURCHASE');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'products.write' FROM roles r WHERE r.code IN('ADMIN','MANAGER');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'orders.read' FROM roles r WHERE r.code IN('ADMIN','MANAGER','SALES');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'orders.write' FROM roles r WHERE r.code IN('ADMIN','MANAGER','SALES');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'po.read' FROM roles r WHERE r.code IN('ADMIN','PURCHASE','MANAGER');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'po.write' FROM roles r WHERE r.code IN('ADMIN','PURCHASE');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'grn.read' FROM roles r WHERE r.code IN('ADMIN','PURCHASE');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'grn.write' FROM roles r WHERE r.code IN('ADMIN','PURCHASE');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'stock.read' FROM roles r WHERE r.code IN('ADMIN','WAREHOUSE','MANAGER','PURCHASE','SALES');
INSERT INTO role_permissions(role_id,perm_code) SELECT r.id,'stock.write' FROM roles r WHERE r.code IN('ADMIN','WAREHOUSE');

-- Branches & warehouses samples
INSERT INTO branches(code,name) VALUES ('HQ','Markaziy ofis') ON DUPLICATE KEY UPDATE name=VALUES(name);
INSERT INTO warehouses(branch_id,code,name) VALUES (1,'MAIN','Asosiy ombor') ON DUPLICATE KEY UPDATE name=VALUES(name);

-- Admin user
DELETE FROM users;
INSERT INTO users(username,password_hash,role,branch_id,active) VALUES ('admin','$2y$10$CwTycUXWue0Thq9StjUM0uJ8VQm8LZ1Iex1A9NgrrhqUTrWyd4MHe','ADMIN',1,1);

-- Samples
INSERT INTO customers(code,name,phone,region,address,lat,lng,avatar) VALUES
('C-001','Mashhuraxon','998901111111','Toshkent','Yakka',41.3111,69.2797,'https://via.placeholder.com/26'),
('C-002','Anoraxon','998902222222','Toshkent','Mirzo Ulug‘bek',41.3275,69.2813,'https://via.placeholder.com/26');

INSERT INTO suppliers(code,name,phone,region,address,avatar) VALUES
('S-001','Aqua Supply','998909000000','Toshkent','Olmazor','https://via.placeholder.com/26'),
('S-002','Blue Water','998907777777','Toshkent','Chilonzor','https://via.placeholder.com/26');

INSERT INTO products(code,name,uom,price,brand,category,avatar) VALUES
('P-001','Daily 19L SUV','dona',20000,'Daily','Suv','https://via.placeholder.com/26'),
('P-002','Daily 19L TARA','dona',25000,'Daily','Suv','https://via.placeholder.com/26');


-- COA
INSERT INTO gl_accounts(code,name,type) VALUES
('1000','Bank','ASSET'),
('1100','Inventory','ASSET'),
('1200','Accounts Receivable','ASSET'),
('2100','Accounts Payable','LIAB'),
('4000','Sales Revenue','INCOME'),
('5000','COGS','EXPENSE')
ON DUPLICATE KEY UPDATE name=VALUES(name), type=VALUES(type);

-- CRM Stages
INSERT INTO deals_stages(code,name,sort) VALUES
('NEW','Yangi',10),('QUAL','Kvalifikatsiya',20),('PROPOSAL','Tijoriy taklif',30),('NEGOT','Muzokara',40),('WON','Yopildi — Yutuq',90),('LOST','Yopildi — Yo‘qotildi',95)
ON DUPLICATE KEY UPDATE name=VALUES(name), sort=VALUES(sort);
