<?php
require_once __DIR__.'/../../config/bootstrap.php';
$type = $_GET['t'] ?? 'products';
$fmt  = $_GET['fmt'] ?? 'csv';
$map=[
 'products'=>'SELECT id,code,name,uom,price,brand,category FROM products ORDER BY id DESC',
 'customers'=>'SELECT id,code,name,phone,email,region,address,lat,lng FROM customers ORDER BY id DESC',
 'suppliers'=>'SELECT id,code,name,phone,email,region,address FROM suppliers ORDER BY id DESC',
 'sales'=>'SELECT i.id, i.invoice_date, c.name customer, i.total FROM sales_invoices i LEFT JOIN customers c ON c.id=i.customer_id ORDER BY i.id DESC',
 'stock'=>'SELECT p.code,p.name,COALESCE(SUM(CASE WHEN t.type IN ("IN","PURCHASE") THEN t.qty WHEN t.type IN ("OUT","SHIPMENT") THEN -t.qty ELSE 0 END),0) AS onhand FROM products p LEFT JOIN stock_transactions t ON t.product_id=p.id GROUP BY p.id ORDER BY p.name',
];
$sql=$map[$type] ?? $map['products']; $rows=db()->query($sql)->fetchAll();
if($fmt==='json'){ header('Content-Type: application/json'); echo json_encode($rows); exit; }
if($fmt==='xml'){ header('Content-Type: application/xml'); echo toXml($rows,$type); exit; }
if($fmt==='doc'){ header('Content-Type: application/msword'); header('Content-Disposition: attachment; filename="'.$type.'.doc"'); echo toHtml($rows); exit; }
if($fmt==='xlsx' || $fmt==='xls'){ header('Content-Type: application/vnd.ms-excel'); header('Content-Disposition: attachment; filename="'.$type.'.xls"'); echo toExcelXml($rows); exit; }
header('Content-Type: text/csv'); header('Content-Disposition: attachment; filename="'.$type.'.csv"');
$out=fopen('php://output','w'); if(!empty($rows)){ fputcsv($out,array_keys($rows[0])); foreach($rows as $r) fputcsv($out,$r); } fclose($out);
function toHtml($rows){ ob_start(); echo '<table border="1">'; if(!empty($rows)){ echo '<tr>'; foreach(array_keys($rows[0]) as $h) echo '<th>'.htmlspecialchars($h).'</th>'; echo '</tr>'; } foreach($rows as $r){ echo '<tr>'; foreach($r as $v) echo '<td>'.htmlspecialchars($v).'</td>'; echo '</tr>'; } echo '</table>'; return ob_get_clean(); }
function toXml($rows,$root='rows'){ $xml=new SimpleXMLElement('<'.$root.'/>');
  foreach($rows as $r){ $item=$xml->addChild('row'); foreach($r as $k=>$v) $item->addChild($k, htmlspecialchars((string)$v)); } return $xml->asXML(); }
function toExcelXml($rows){ $xml='<?xml version="1.0" encoding="UTF-8"?>'; $xml.='<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"><Worksheet ss:Name="Sheet1" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"><Table>';
  if(!empty($rows)){ $xml.='<Row>'; foreach(array_keys($rows[0]) as $h) $xml.='<Cell><Data ss:Type="String">'.htmlspecialchars($h).'</Data></Cell>'; $xml.='</Row>'; }
  foreach($rows as $r){ $xml.='<Row>'; foreach($r as $v){ $type=is_numeric($v)?'Number':'String'; $xml.='<Cell><Data ss:Type="'.$type.'">'.htmlspecialchars((string)$v).'</Data></Cell>'; } $xml.='</Row>'; }
  $xml.='</Table></Worksheet></Workbook>'; return $xml; }
