<?php
namespace App\Services;
require_once __DIR__.'/../../config/bootstrap.php';

class CostingService {
  // method: FIFO|AVG|FEFO
  public static function cogsForShipment($shipmentId){
    $cfg = require __DIR__.'/../../config/config.php';
    $method = strtoupper($cfg['app']['cost_method'] ?? 'FIFO');

    // Get shipment lines via order items
    $s = db()->prepare("SELECT s.*, o.warehouse_id FROM shipments s JOIN sales_orders o ON o.id=s.order_id WHERE s.id=?");
    $s->execute([$shipmentId]); $ship=$s->fetch(); if(!$ship) return;
    $wi = (int)$ship['warehouse_id'];

    $items = db()->prepare("SELECT i.product_id, i.qty FROM sales_order_items i WHERE i.order_id=?");
    $items->execute([$ship['order_id']]); $items=$items->fetchAll();
    if(!$items) return;

    // Create voucher header
    db()->prepare("INSERT INTO gl_vouchers(type,ref,vdate,descr) VALUES('COGS',?,CURDATE(),'COGS for shipment')")->execute(['SHIP-'.$shipmentId]);
    $vid = db()->lastInsertId();

    $invAcc = self::accountIdByCode('1100'); // Inventory
    $cogsAcc= self::accountIdByCode('5000'); // COGS

    foreach($items as $it){
      $pid=(int)$it['product_id']; $qty=(float)$it['qty']; if($qty<=0) continue;

      // Determine cost per unit
      $unit_cost = 0.0; $remain = $qty;
      if($method==='AVG'){
        $avg = db()->prepare("SELECT SUM(qty_remain*unit_cost)/NULLIF(SUM(qty_remain),0) AS avg_cost FROM cost_layers WHERE product_id=? AND warehouse_id=? AND qty_remain>0");
        $avg->execute([$pid,$wi]); $unit_cost=(float)($avg->fetch()['avg_cost'] ?? 0);
        // Consume FIFO for layer qty_remain adjustments
        $layers = db()->prepare("SELECT * FROM cost_layers WHERE product_id=? AND warehouse_id=? AND qty_remain>0 ORDER BY created_at ASC, id ASC");
      } else if($method==='FEFO'){
        $layers = db()->prepare("SELECT * FROM cost_layers WHERE product_id=? AND warehouse_id=? AND qty_remain>0 ORDER BY (expiry IS NULL), expiry ASC, created_at ASC");
      } else { // FIFO
        $layers = db()->prepare("SELECT * FROM cost_layers WHERE product_id=? AND warehouse_id=? AND qty_remain>0 ORDER BY created_at ASC, id ASC");
      }
      if($method!=='AVG') $layers->execute([$pid,$wi]);
      else $layers->execute([$pid,$wi]);

      $cost_total = 0.0;
      foreach($layers->fetchAll() as $L){
        if($remain<=0) break;
        $take = min($remain, (float)$L['qty_remain']);
        $u = ($method==='AVG' && $unit_cost>0) ? $unit_cost : (float)$L['unit_cost'];
        $cost_total += $take * $u;
        // decrease layer
        db()->prepare("UPDATE cost_layers SET qty_remain=qty_remain-? WHERE id=?")->execute([$take,$L['id']]);
        $remain -= $take;
      }
      if($remain>0){
        // negative layer (no cost layer) - assume zero cost, but still proceed
      }
      // COGS entry row
      db()->prepare("INSERT INTO cogs_entries(shipment_id,product_id,qty,unit_cost,total_cost) VALUES(?,?,?,?,?)")
        ->execute([$shipmentId,$pid,$qty, $qty>0 ? $cost_total/$qty : 0, $cost_total]);

      // GL entries: Dr COGS, Cr Inventory
      db()->prepare("INSERT INTO gl_entries(voucher_id,account_id,dr,cr,memo) VALUES(?,?,?,?,?)")->execute([$vid,$cogsAcc,$cost_total,0,'COGS']);
      db()->prepare("INSERT INTO gl_entries(voucher_id,account_id,dr,cr,memo) VALUES(?,?,?,?,?)")->execute([$vid,$invAcc,0,$cost_total,'Inventory']);
    }
  }

  protected static function accountIdByCode($code){
    $s=db()->prepare("SELECT id FROM gl_accounts WHERE code=? LIMIT 1"); $s->execute([$code]); $r=$s->fetch(); return $r? (int)$r['id'] : null;
  }
}
