
<div class="d-flex justify-content-between align-items-center mb-2">
  <h5>Mahsulotlar</h5>
  <div>
    <a class="btn btn-sm btn-outline-secondary" href="api/export.php?t=products&fmt=csv">CSV</a>
    <a class="btn btn-sm btn-outline-secondary" href="api/export.php?t=products&fmt=xls">XLS</a>
    <a class="btn btn-sm btn-outline-secondary" href="api/export.php?t=products&fmt=xml">XML</a>
    <a class="btn btn-sm btn-outline-secondary" href="api/export.php?t=products&fmt=json">JSON</a>
    <button class="btn btn-primary" onclick="openModal('prodCreate')">+ Yangi</button>
  </div>
</div>
<table class="table table-striped"><thead><tr>
<th>ID</th><th>Kod</th><th>Nomi</th><th>UoM</th><th>Narx</th><th>Brend</th><th>Toifa</th><th>Avatar</th><th></th>
</tr></thead><tbody>
<?php foreach($rows as $r): ?><tr>
  <td><?= $r['id'] ?></td><td><?= htmlspecialchars($r['code']) ?></td><td><?= htmlspecialchars($r['name']) ?></td>
  <td><?= htmlspecialchars($r['uom']) ?></td><td><?= number_format($r['price'],0,'.',' ') ?></td>
  <td><?= htmlspecialchars($r['brand']) ?></td><td><?= htmlspecialchars($r['category']) ?></td>
  <td><?php if($r['avatar']): ?><img src="<?= htmlspecialchars($r['avatar']) ?>" width="26"><?php endif; ?></td>
  <td><button class="btn btn-sm btn-outline-primary" onclick="fillProd(<?= $r['id'] ?>,'<?= htmlspecialchars($r['code'],ENT_QUOTES) ?>','<?= htmlspecialchars($r['name'],ENT_QUOTES) ?>','<?= htmlspecialchars($r['uom'],ENT_QUOTES) ?>','<?= htmlspecialchars($r['price'],ENT_QUOTES) ?>','<?= htmlspecialchars($r['brand'],ENT_QUOTES) ?>','<?= htmlspecialchars($r['category'],ENT_QUOTES) ?>','<?= htmlspecialchars($r['avatar'],ENT_QUOTES) ?>')">Tahrirlash</button>
  <a class="btn btn-sm btn-outline-danger" onclick="return confirm('O‘chirsinmi?')" href="<?= url('catalog/products/delete',['id'=>$r['id']]) ?>">O‘chirish</a></td>
</tr><?php endforeach; ?></tbody></table>

<div class="modal" id="prodCreate"><div class="modal-dialog"><div class="modal-content">
  <div class="modal-header"><h5>Mahsulot qo‘shish</h5><button class="btn-close" onclick="closeModal('prodCreate')"></button></div>
  <form method="post" action="<?= url('catalog/products/store') ?>"><div class="modal-body"><div class="row g-2">
    <div class="col-md-3"><label class="form-label">Kod</label><input name="code" class="form-control" required></div>
    <div class="col-md-6"><label class="form-label">Nomi</label><input name="name" class="form-control" required></div>
    <div class="col-md-3"><label class="form-label">UoM</label><input name="uom" class="form-control" value="dona"></div>
    <div class="col-md-3"><label class="form-label">Narx</label><input name="price" type="number" step="0.01" class="form-control" value="0"></div>
    <div class="col-md-3"><label class="form-label">Brend</label><input name="brand" class="form-control"></div>
    <div class="col-md-3"><label class="form-label">Toifa</label><input name="category" class="form-control"></div>
    <div class="col-md-12"><label class="form-label">Avatar (URL)</label><input name="avatar" class="form-control" placeholder="https://..."></div>
  </div></div><div class="modal-footer"><button class="btn btn-secondary" type="button" onclick="closeModal('prodCreate')">Bekor</button><button class="btn btn-primary">Saqlash</button></div></form>
</div></div></div>

<div class="modal" id="prodEdit"><div class="modal-dialog"><div class="modal-content">
  <div class="modal-header"><h5>Mahsulot tahrirlash</h5><button class="btn-close" onclick="closeModal('prodEdit')"></button></div>
  <form method="post" action="<?= url('catalog/products/update') ?>"><input type="hidden" name="id" id="pe_id"><div class="modal-body"><div class="row g-2">
    <div class="col-md-3"><label class="form-label">Kod</label><input name="code" id="pe_code" class="form-control"></div>
    <div class="col-md-6"><label class="form-label">Nomi</label><input name="name" id="pe_name" class="form-control"></div>
    <div class="col-md-3"><label class="form-label">UoM</label><input name="uom" id="pe_uom" class="form-control"></div>
    <div class="col-md-3"><label class="form-label">Narx</label><input name="price" id="pe_price" type="number" step="0.01" class="form-control"></div>
    <div class="col-md-3"><label class="form-label">Brend</label><input name="brand" id="pe_brand" class="form-control"></div>
    <div class="col-md-3"><label class="form-label">Toifa</label><input name="category" id="pe_category" class="form-control"></div>
    <div class="col-md-12"><label class="form-label">Avatar (URL)</label><input name="avatar" id="pe_avatar" class="form-control"></div>
  </div></div><div class="modal-footer"><button class="btn btn-secondary" type="button" onclick="closeModal('prodEdit')">Bekor</button><button class="btn btn-primary">Saqlash</button></div></form>
</div></div></div>

<script>
function fillProd(id,code,name,uom,price,brand,category,avatar){
  pe_id.value=id; pe_code.value=code; pe_name.value=name; pe_uom.value=uom; pe_price.value=price; pe_brand.value=brand; pe_category.value=category; pe_avatar.value=avatar;
  openModal('prodEdit');
}
</script>
