<?php
namespace App\Controllers\Finance;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class BankController extends Controller{
  public function rules(){ require_login(); $rules=db()->query("SELECT * FROM bank_rules ORDER BY id DESC")->fetchAll(); $acc=db()->query("SELECT * FROM gl_accounts ORDER BY code")->fetchAll(); $this->view('finance/bank_rules',compact('rules','acc')); }
  public function saverule(){ require_login(); db()->prepare("INSERT INTO bank_rules(name,pattern,days_tol,amount_tol,dr_account_id,cr_account_id,active) VALUES(?,?,?,?,?,?,1)")->execute([$_POST['name'],$_POST['pattern'],$_POST['days_tol']??3,$_POST['amount_tol']??0.5,$_POST['dr_account_id']??null,$_POST['cr_account_id']??null]); flash('ok','Qoidalar saqlandi'); $this->redirect('finance/bank/rules'); }
  public function batchconfirm(){ require_login(); db()->prepare("UPDATE bank_statements SET status='CONFIRMED' WHERE status='MATCHED'")->execute(); flash('ok','MATCHED yozuvlar CONFIRMED qilindi'); $this->redirect('finance/bank/index'); }

  public function index(){ require_login();
    $list=db()->query("SELECT * FROM bank_statements ORDER BY id DESC LIMIT 500")->fetchAll();
    $this->view('finance/bank_index',compact('list'));
  }
  public function import(){ require_login();
    if(!empty($_FILES['csv']['name'])){
      $path = __DIR__.'/../../../tmp'; if(!is_dir($path)) mkdir($path,0777,true);
      $fn = $path.'/'.time().'_'.basename($_FILES['csv']['name']);
      if(move_uploaded_file($_FILES['csv']['tmp_name'],$fn)){
        $h=fopen($fn,'r');
        while(($row=fgetcsv($h,0,','))!==false){
          // Expect: date, descr, debit, credit (can be swapped)
          $date = $row[0] ?? null; $descr = $row[1] ?? null;
          $debit = is_numeric(str_replace(',','.', $row[2] ?? '')) ? (float)str_replace(',','.', $row[2]) : 0;
          $credit= is_numeric(str_replace(',','.', $row[3] ?? '')) ? (float)str_replace(',','.', $row[3]) : 0;
          db()->prepare("INSERT INTO bank_statements(bank_account,tx_date,descr,debit,credit,status) VALUES('BANK-1',?,?,?,?, 'NEW')")->execute([$date,$descr,$debit,$credit]);
        }
        fclose($h);
        flash('ok','Bank CSV import qilindi');
      } else flash('err','CSV yuklanmadi');
    }
    $this->redirect('finance/bank/index');
  }
  public function automatch(){ require_login();
    // match AR payments by amount and near date
    $stm = db()->query("SELECT * FROM bank_statements WHERE status='NEW'");
    $upd = db()->prepare("UPDATE bank_statements SET status='MATCHED', match_ref=? WHERE id=?");
    while($b = $stm->fetch()){
      $amount = $b['credit']>0 ? $b['credit'] : ($b['debit']>0 ? -$b['debit'] : 0);
      if($amount<=0) continue;
      $m = db()->prepare("SELECT p.id, p.pay_date FROM ar_payments p WHERE ABS(p.amount - ?) < 0.01 LIMIT 1");
      $m->execute([$amount]); $r=$m->fetch();
      if($r){
        $upd->execute(['ARPAY-'.$r['id'],$b['id']]);
        // GL: Dr Bank, Cr AR
        db()->prepare("INSERT INTO gl_vouchers(type,ref,vdate,descr) VALUES('BANK','BANKMATCH',?,?)")->execute([$b['tx_date'],'Auto-match']);
        $vid=db()->lastInsertId();
        $bank=db()->query("SELECT id FROM gl_accounts WHERE code='1000' LIMIT 1")->fetch()['id'] ?? null;
        $ar  =db()->query("SELECT id FROM gl_accounts WHERE code='1200' LIMIT 1")->fetch()['id'] ?? null;
        db()->prepare("INSERT INTO gl_entries(voucher_id,account_id,dr,cr,memo) VALUES(?,?,?,?,?)")->execute([$vid,$bank,abs($amount),0,'Bank in']);
        db()->prepare("INSERT INTO gl_entries(voucher_id,account_id,dr,cr,memo) VALUES(?,?,?,?,?)")->execute([$vid,$ar,0,abs($amount),'AR clear']);
      }
    }
    flash('ok','Auto-match tugadi'); $this->redirect('finance/bank/index');
  }
}
