<?php
namespace App\Controllers\Import;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class WizardController extends Controller{
  public function index(){ require_login(); $this->view('import/wizard_step1'); }
  public function step2(){ require_login();
    $csv = trim($_POST['csv'] ?? '');
    $entity = $_POST['entity'] ?? 'products';
    if(!$csv){ flash('err','CSV bo‘sh'); $this->redirect('import/wizard/index'); }
    $lines = preg_split('/\r?\n/',$csv); $first = str_getcsv($lines[0]);
    $_SESSION['iw_csv'] = $csv; $_SESSION['iw_entity'] = $entity; $_SESSION['iw_header'] = $first;
    $this->view('import/wizard_step2',['first'=>$first,'entity'=>$entity]);
  }
  public function step3(){ require_login();
    $map = $_POST['map'] ?? []; $entity = $_SESSION['iw_entity'] ?? 'products'; $csv = $_SESSION['iw_csv'] ?? '';
    $lines = preg_split('/\r?\n/',$csv); $rows=[];
    foreach($lines as $i=>$ln){ if($i==0) continue; $c=str_getcsv($ln); $row=[]; foreach($map as $idx=>$field){ if($field==='__skip__') continue; $row[$field] = $c[(int)$idx] ?? null; } if($row) $rows[]=$row; }
    $_SESSION['iw_rows']=$rows; $_SESSION['iw_map']=$map;
    $this->view('import/wizard_step3',['rows'=>$rows,'entity'=>$entity]);
  }
  public function commit(){ require_login();
    $entity = $_SESSION['iw_entity'] ?? 'products'; $rows = $_SESSION['iw_rows'] ?? [];
    db()->beginTransaction();
    db()->prepare("INSERT INTO import_sessions(entity,status,mapping) VALUES(?,?,?)")->execute([$entity,'NEW', json_encode($_SESSION['iw_map'] ?? []) ]);
    $sid = db()->lastInsertId();
    $insSql=''; $fields=[];
    if($entity==='products'){ $insSql="INSERT INTO products(code,name,uom,price,brand,category,avatar) VALUES(?,?,?,?,?,?,?)"; $fields=['code','name','uom','price','brand','category','avatar']; }
    elseif($entity==='customers'){ $insSql="INSERT INTO customers(code,name,phone,email,region,address,avatar) VALUES(?,?,?,?,?,?,?)"; $fields=['code','name','phone','email','region','address','avatar']; }
    else { db()->rollBack(); flash('err','Entity qo‘llab-quvvatlanmaydi'); $this->redirect('import/wizard/index'); }
    $ins=db()->prepare($insSql);
    foreach($rows as $r){ $vals=[]; foreach($fields as $f){ $vals[]=$r[$f] ?? null; } $ins->execute($vals); $rid=db()->lastInsertId(); db()->prepare("INSERT INTO import_logs(session_id,table_name,row_id) VALUES(?,?,?)")->execute([$sid,$entity,$rid]); }
    db()->prepare("UPDATE import_sessions SET status='COMMITTED' WHERE id=?")->execute([$sid]);
    db()->commit(); flash('ok','Import yakunlandi (#'.$sid.')'); $this->redirect('import/wizard/index');
  }
  public function rollback(){ require_login();
    $sid=(int)($_GET['sid']??0); $rows=db()->prepare("SELECT * FROM import_logs WHERE session_id=?"); $rows->execute([$sid]); db()->beginTransaction();
    foreach($rows->fetchAll() as $r){ soft_delete($r['table_name'], $r['row_id']); }
    db()->prepare("UPDATE import_sessions SET status='ROLLED' WHERE id=?")->execute([$sid]); db()->commit(); flash('ok','Rollback bajarildi'); $this->redirect('import/wizard/index');
  }
}
