<?php
namespace App\Controllers\Reports;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class Pivot2Controller extends Controller{
  public function index(){ require_login();
    $this->view('reports/pivot2_index');
  }
  public function run(){ require_login();
    $row = $_POST['row_dim'] ?? 'customer'; $col = $_POST['col_dim'] ?? 'date';
    if($row==='customer') $rowExpr="c.name";
    else if($row==='product') $rowExpr="p.name";
    else $rowExpr="i.invoice_date";

    if($col==='customer') $colExpr="c.name";
    else if($col==='product') $colExpr="p.name";
    else $colExpr="i.invoice_date";

    // Build raw dataset (sales by order items)
    $sql = "SELECT {$rowExpr} r, {$colExpr} c, SUM(oi.qty*oi.price) v
            FROM sales_order_items oi
            JOIN sales_orders so ON so.id=oi.order_id
            LEFT JOIN customers c ON c.id=so.customer_id
            LEFT JOIN products p ON p.id=oi.product_id
            LEFT JOIN sales_invoices i ON i.customer_id=so.customer_id
            GROUP BY r,c ORDER BY r,c";
    $rows = db()->query($sql)->fetchAll();
    $this->view('reports/pivot2_result',compact('rows','row','col'));
  }
}
