<?php
namespace App\Controllers\Reports;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class PivotController extends Controller{
  public function index(){ require_login();
    $saved = db()->query("SELECT * FROM saved_reports ORDER BY id DESC")->fetchAll();
    $this->view('reports/pivot_index',compact('saved'));
  }
  public function run(){ require_login();
    $dataset = $_POST['dataset'] ?? 'sales';
    $group   = $_POST['group_by'] ?? 'date';
    if($dataset==='sales'){
      if($group==='customer'){
        $rows = db()->query("SELECT c.name grp, SUM(i.total) val FROM sales_invoices i LEFT JOIN customers c ON c.id=i.customer_id GROUP BY c.name ORDER BY val DESC")->fetchAll();
      } elseif($group==='product'){
        $rows = db()->query("SELECT p.name grp, SUM(oi.qty*oi.price) val FROM sales_order_items oi JOIN products p ON p.id=oi.product_id GROUP BY p.name ORDER BY val DESC")->fetchAll();
      } else {
        $rows = db()->query("SELECT i.invoice_date grp, SUM(i.total) val FROM sales_invoices i GROUP BY i.invoice_date ORDER BY grp")->fetchAll();
      }
    } else { // stock
      $rows = db()->query("SELECT p.name grp, COALESCE(SUM(CASE WHEN t.type IN('IN','PURCHASE') THEN t.qty WHEN t.type IN('OUT','SHIPMENT') THEN -t.qty ELSE 0 END),0) val FROM products p LEFT JOIN stock_transactions t ON t.product_id=p.id GROUP BY p.name ORDER BY p.name")->fetchAll();
    }
    $this->view('reports/pivot_result',compact('rows','dataset','group'));
  }
  public function save(){ require_login();
    db()->prepare("INSERT INTO saved_reports(name,slug,type,config) VALUES(?,?,?,?)")->execute([$_POST['name'],$_POST['slug']??null,'pivot',json_encode($_POST)]);
    flash('ok','Pivot saqlandi'); $this->redirect('reports/pivot/index');
  }
}
