<?php
namespace App\Controllers\Sales;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
use App\Services\CostingService;

class ShipmentsController extends Controller{
  public function lotdata(){ require_login(); $oid=(int)($_GET['order_id']??0); $wid=(int)($_GET['warehouse_id']??0); $items=db()->prepare("SELECT soi.product_id, soi.qty, p.name product_name FROM sales_order_items soi JOIN products p ON p.id=soi.product_id WHERE soi.order_id=?"); $items->execute([$oid]); $res=[]; foreach($items->fetchAll() as $it){ $layers=db()->prepare("SELECT id,lot,expiry,qty_remain FROM cost_layers WHERE product_id=? AND warehouse_id=? AND qty_remain>0 ORDER BY (expiry IS NULL), expiry ASC, created_at ASC"); $layers->execute([$it['product_id'],$wid]); $res[]=['product_id'=>$it['product_id'],'qty'=>(float)$it['qty'],'product_name'=>$it['product_name'],'layers'=>$layers->fetchAll()]; } $this->json(['items'=>$res]); }

  public function index(){ require_login();
    $list=db()->query("SELECT s.*, c.name customer FROM shipments s LEFT JOIN customers c ON c.id=s.customer_id ORDER BY s.id DESC")->fetchAll();
    $orders=db()->query("SELECT id FROM sales_orders ORDER BY id DESC")->fetchAll();
    $ware=db()->query("SELECT id,code,name FROM warehouses ORDER BY name")->fetchAll();
    $this->view('sales/shipments_index',compact('list','orders','ware'));
  }
  public function store(){ require_login();
    db()->beginTransaction();
    $stm=db()->prepare("INSERT INTO shipments(order_id,customer_id,warehouse_id,ship_date,status) SELECT o.id, o.customer_id, ?, ?, 'NEW' FROM sales_orders o WHERE o.id=?");
    $stm->execute([$_POST['warehouse_id'],$_POST['ship_date'],$_POST['order_id']]);
    $shipId=db()->lastInsertId();
    // OUT transactions (qty from order items)
    $sel=db()->prepare("SELECT product_id,qty FROM sales_order_items WHERE order_id=?");
    $sel->execute([$_POST['order_id']]);
    $out=db()->prepare("INSERT INTO stock_transactions(product_id,warehouse_id,type,qty,lot,expiry) VALUES(?,?, 'OUT', ?,?,?)");
    foreach($sel->fetchAll() as $r){
      $lots = $_POST['lots'][$r['product_id']] ?? [];
      if($lots){ foreach($lots as $pair){ list($layerId,$take)=array_map('trim', explode(':',$pair)); $L=db()->prepare("SELECT lot,expiry FROM cost_layers WHERE id=? LIMIT 1"); $L->execute([$layerId]); $LL=$L->fetch(); $out->execute([$r['product_id'],$_POST['warehouse_id'],$take, $LL['lot']??null, $LL['expiry']??null]); db()->prepare("UPDATE cost_layers SET qty_remain=qty_remain-? WHERE id=?")->execute([$take,$layerId]); }
      } else { $out->execute([$r['product_id'],$_POST['warehouse_id'],$r['qty'], null, null]); }
    }
    db()->commit();
    // COGS OUT allocate
    CostingService::cogsForShipment($shipId);
    flash('ok','Jo‘natma yaratildi, OUT va COGS yozildi'); $this->redirect('sales/shipments/index');
  }
}
