<?php
namespace App\Core;
class Router{
  public static function dispatch($r){
    $parts = array_values(array_filter(explode('/', trim($r,'/'))));
    if (count($parts)==0) $parts = ['admin','dashboard','index'];
    $module = ucfirst($parts[0]);
    $ctrl   = ucfirst($parts[1] ?? '');
    $act    = $parts[2] ?? null;

    if ($ctrl){
      $class = "App\\Controllers\\{$module}\\{$ctrl}Controller";
      if (class_exists($class)){
        if(!$act) $act='index';
        if(!method_exists($class,$act)) throw new \Exception("Action topilmadi: {$class}::{$act}");
        $obj = new $class();
        return $obj->$act();
      }
    }
    $fallback = "App\\Controllers\\{$module}Controller";
    if (class_exists($fallback)){
      $act = $ctrl ? strtolower($ctrl) : 'index';
      if(!method_exists($fallback,$act)) throw new \Exception("Action topilmadi: {$fallback}::{$act}");
      $obj = new $fallback();
      return $obj->$act();
    }
    throw new \Exception("Controller topilmadi: ".($ctrl ? "App\\Controllers\\{$module}\\{$ctrl}Controller" : $fallback));
  }
}
