
<h5>CRM — Pipeline (Kanban)</h5>
<div class="d-flex mb-2">
  <button class="btn btn-primary" onclick="openModal('dealCreate')">+ Deal</button>
</div>
<div class="row">
<?php foreach($stages as $s): ?>
  <div class="col-md-4">
    <div class="card p-2">
      <h6><?= htmlspecialchars($s['name']) ?> <span class="text-muted small">(<?= $s['code'] ?>)</span></h6>
      <div class="kan-col" data-stage="<?= $s['code'] ?>" ondragover="event.preventDefault()" ondrop="dropDeal(event,this)">
        <?php foreach($deals as $d): if($d['stage_code']!==$s['code']) continue; ?>
          <div class="kan-card" draggable="true" ondragstart="dragDeal(event)" data-id="<?= $d['id'] ?>">
            <div><b>#<?= $d['id'] ?></b> — <?= htmlspecialchars($d['title']) ?></div>
            <div class="small text-muted"><?= number_format($d['amount'],0,'.',' ') ?></div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
<?php endforeach; ?>
</div>

<div class="modal" id="dealCreate"><div class="modal-dialog"><div class="modal-content">
  <div class="modal-header"><h5>Yangi Deal</h5><button class="btn-close" onclick="closeModal('dealCreate')"></button></div>
  <form method="post" action="<?= url('crm/deals/store') ?>"><div class="modal-body"><div class="row g-2">
    <div class="col-md-8"><label class="form-label">Sarlavha</label><input name="title" class="form-control" required></div>
    <div class="col-md-4"><label class="form-label">Miqdor</label><input name="amount" type="number" class="form-control"></div>
    <div class="col-md-6"><label class="form-label">Bosqich</label><select name="stage_code" class="form-select">
      <?php foreach($stages as $s): ?><option value="<?= $s['code'] ?>"><?= htmlspecialchars($s['name']) ?></option><?php endforeach; ?>
    </select></div>
    <div class="col-md-6"><label class="form-label">Muddati</label><input name="due_date" type="date" class="form-control" value="<?= date('Y-m-d') ?>"></div>
  </div></div><div class="modal-footer"><button class="btn btn-secondary" type="button" onclick="closeModal('dealCreate')">Bekor</button><button class="btn btn-primary">Saqlash</button></div></form>
</div></div></div>

<script>
let dragId=null;
function dragDeal(e){ dragId = e.target.dataset.id; }
function dropDeal(e,col){
  const stage = col.dataset.stage;
  fetch("<?= url('crm/deals/move') ?>", {method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body:'id='+dragId+'&stage_code='+encodeURIComponent(stage)})
    .then(_=>location.reload());
}
</script>
