
<div class="d-flex justify-content-between align-items-center mb-2">
  <h5>Buyurtmalar</h5>
  <button class="btn btn-primary" onclick="openModal('ordCreate')">+ Yangi</button>
</div>
<table class="table table-striped"><thead><tr><th>ID</th><th>Sana</th><th>Mijoz</th><th>Ombor</th><th>Status</th><th>Izoh</th><th></th></tr></thead>
<tbody><?php foreach($ord as $o): ?><tr>
  <td><?= $o['id'] ?></td><td><?= htmlspecialchars($o['order_date']) ?></td><td><?= htmlspecialchars($o['customer']) ?></td><td><?= htmlspecialchars($o['warehouse_id']) ?></td><td><?= htmlspecialchars($o['status']) ?></td><td><?= htmlspecialchars($o['notes']) ?></td>
  <td><a class="btn btn-sm btn-outline-danger" onclick="return confirm('O‘chirsinmi?')" href="<?= url('sales/orders/delete',['id'=>$o['id']]) ?>">O‘chirish</a></td>
</tr><?php endforeach; ?></tbody></table>

<div class="modal" id="ordCreate"><div class="modal-dialog modal-lg"><div class="modal-content">
  <div class="modal-header"><h5>Buyurtma</h5><button class="btn-close" onclick="closeModal('ordCreate')"></button></div>
  <form method="post" action="<?= url('sales/orders/store') ?>" onsubmit="return syncItems()"><div class="modal-body">
    <div class="row g-2">
      <div class="col-md-4"><label class="form-label">Mijoz</label><select name="customer_id" class="form-select"><?php foreach($cust as $c): ?><option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option><?php endforeach; ?></select></div>
      <div class="col-md-4"><label class="form-label">Ombor</label><select name="warehouse_id" class="form-select"><?php foreach($ware as $w): ?><option value="<?= $w['id'] ?>"><?= htmlspecialchars($w['name']) ?></option><?php endforeach; ?></select></div>
      <div class="col-md-4"><label class="form-label">Sana</label><input type="date" name="order_date" value="<?= date('Y-m-d') ?>" class="form-control"></div>
      <div class="col-md-12"><label class="form-label">Izoh</label><input name="notes" class="form-control"></div>
    </div><hr>
    <div class="table-responsive"><table class="table" id="itemsTbl"><thead><tr><th>Mahsulot</th><th>Miqdor</th><th>Narx</th><th>Summa</th><th></th></tr></thead><tbody></tbody></table></div>
    <button class="btn btn-outline-primary" type="button" onclick="addRow()">+ Qator</button><input type="hidden" id="items_json">
  </div><div class="modal-footer"><button class="btn btn-secondary" type="button" onclick="closeModal('ordCreate')">Bekor</button><button class="btn btn-primary">Saqlash</button></div></form>
</div></div></div>

<script>
const products = <?= json_encode($prod) ?>;
function addRow(){
  const tr = document.createElement('tr');
  tr.innerHTML = `<td><select class="form-select itm-prod">${products.map(p=>`<option data-price="${p.price}" value="${p.id}">${p.code} — ${p.name}</option>`).join('')}</select></td>
  <td><input type="number" class="form-control itm-qty" value="1" step="1" min="1"></td>
  <td><input type="number" class="form-control itm-price" value="0" step="0.01"></td>
  <td class="itm-sum text-end">0</td>
  <td><button class="btn btn-sm btn-outline-danger" type="button" onclick="this.closest('tr').remove(); recalc();">×</button></td>`;
  itemsTbl.querySelector('tbody').appendChild(tr);
  tr.querySelector('.itm-prod').addEventListener('change', e=>{ const price=e.target.selectedOptions[0].dataset.price||0; tr.querySelector('.itm-price').value=price; recalc(); });
  tr.querySelector('.itm-qty').addEventListener('input', recalc);
  tr.querySelector('.itm-price').addEventListener('input', recalc);
  recalc();
}
function recalc(){ itemsTbl.querySelectorAll('tbody tr').forEach(tr=>{ const q=parseFloat(tr.querySelector('.itm-qty').value||0); const p=parseFloat(tr.querySelector('.itm-price').value||0); tr.querySelector('.itm-sum').textContent=(q*p).toFixed(2); }); }
function syncItems(){
  const form=event.target; const items=[];
  itemsTbl.querySelectorAll('tbody tr').forEach(tr=>{ const pid=parseInt(tr.querySelector('.itm-prod').value); const qty=parseFloat(tr.querySelector('.itm-qty').value||0); const price=parseFloat(tr.querySelector('.itm-price').value||0);
    if(pid && qty>0) items.push({product_id:pid, qty:qty, price:price}); });
  const holder=document.createElement('div');
  items.forEach((it,i)=>{ ['product_id','qty','price'].forEach(k=>{ const inp=document.createElement('input'); inp.type='hidden'; inp.name=`items[${i}][${k}]`; inp.value=it[k]; holder.appendChild(inp); }); });
  form.appendChild(holder); return true;
}
</script>
