<?php
if (session_status()===PHP_SESSION_NONE) session_start();
$CFG = require __DIR__.'/config.php';

$script = $_SERVER['SCRIPT_NAME'] ?? '/s2/public/index.php';
$base   = rtrim(str_replace('\\','/', dirname($script)), '/');
if ($base === '/' || $base === '\\') $base = '';
define('BASE_URL', $base);

// Autoload
spl_autoload_register(function($class){
  if (strpos($class,'App\\')!==0) return;
  $path = __DIR__ . '/../src/' . str_replace(['App\\','\\'],['','/'],$class) . '.php';
  if (file_exists($path)) require $path;
});

function url($r,$params=[]){ $q=http_build_query(array_merge(['r'=>$r],$params)); return 'index.php?'.$q; }
function asset($p){ return 'assets/'.ltrim($p,'/'); }
function db(){
  static $pdo=null; if ($pdo) return $pdo;
  $c = require __DIR__.'/config.php';
  $pdo = new PDO($c['db']['dsn'],$c['db']['user'],$c['db']['pass'],[
    PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC
  ]);
  return $pdo;
}
function flash($k,$v=null){ if($v===null){ if(!empty($_SESSION['flash'][$k])){$t=$_SESSION['flash'][$k];unset($_SESSION['flash'][$k]);return $t;} return null; } else { $_SESSION['flash'][$k]=$v; } }
function auth(){ return $_SESSION['auth'] ?? null; }
function require_login(){ if(!auth()){ header('Location: '.url('auth/login')); exit; } }
function can($perm){ $u=auth(); if(!$u) return false; if($u['role']==='ADMIN') return true; return in_array($perm,$u['perms']??[]); }
