-- USERS & RBAC
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(60) UNIQUE NOT NULL,
  password_hash VARCHAR(255) NULL,
  role VARCHAR(30) NOT NULL DEFAULT 'ADMIN',
  branch_id INT NULL,
  active TINYINT NOT NULL DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS roles (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(40) UNIQUE NOT NULL,
  name VARCHAR(120) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS permissions (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(80) UNIQUE NOT NULL,
  name VARCHAR(120) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS role_permissions (
  role_id INT NOT NULL,
  perm_code VARCHAR(80) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- BRANCHES & WAREHOUSES
CREATE TABLE IF NOT EXISTS branches(
  id INT AUTO_INCREMENT PRIMARY KEY, code VARCHAR(30) UNIQUE, name VARCHAR(120) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS warehouses(
  id INT AUTO_INCREMENT PRIMARY KEY,
  branch_id INT NULL,
  code VARCHAR(30) UNIQUE, name VARCHAR(120) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- CATALOG
CREATE TABLE IF NOT EXISTS customers(
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(60) UNIQUE, name VARCHAR(255) NOT NULL,
  phone VARCHAR(60) NULL, email VARCHAR(120) NULL,
  region VARCHAR(120) NULL, address VARCHAR(255) NULL,
  lat DECIMAL(10,6) NULL, lng DECIMAL(10,6) NULL,
  avatar VARCHAR(255) NULL, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS suppliers(
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(60) UNIQUE, name VARCHAR(255) NOT NULL,
  phone VARCHAR(60) NULL, email VARCHAR(120) NULL,
  region VARCHAR(120) NULL, address VARCHAR(255) NULL,
  avatar VARCHAR(255) NULL, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS products(
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(60) UNIQUE, name VARCHAR(255) NOT NULL,
  uom VARCHAR(30) NOT NULL DEFAULT 'dona', price DECIMAL(12,2) NOT NULL DEFAULT 0,
  brand VARCHAR(120) NULL, category VARCHAR(120) NULL,
  avatar VARCHAR(255) NULL, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- SALES
CREATE TABLE IF NOT EXISTS sales_orders(
  id INT AUTO_INCREMENT PRIMARY KEY,
  customer_id INT NOT NULL, warehouse_id INT NULL,
  order_date DATE NOT NULL, status VARCHAR(20) NOT NULL DEFAULT 'NEW',
  notes VARCHAR(255) NULL, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS sales_order_items(
  id INT AUTO_INCREMENT PRIMARY KEY,
  order_id INT NOT NULL, product_id INT NOT NULL,
  qty DECIMAL(12,2) NOT NULL, price DECIMAL(12,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS sales_invoices(
  id INT AUTO_INCREMENT PRIMARY KEY,
  customer_id INT NOT NULL, invoice_date DATE NOT NULL,
  total DECIMAL(12,2) NOT NULL DEFAULT 0,
  status VARCHAR(20) NOT NULL DEFAULT 'DRAFT',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS shipments(
  id INT AUTO_INCREMENT PRIMARY KEY,
  order_id INT NOT NULL, customer_id INT NOT NULL,
  warehouse_id INT NOT NULL, ship_date DATE NOT NULL,
  status VARCHAR(20) NOT NULL DEFAULT 'NEW', created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ar_payments(
  id INT AUTO_INCREMENT PRIMARY KEY,
  invoice_id INT NOT NULL, amount DECIMAL(12,2) NOT NULL,
  pay_date DATE NOT NULL, method VARCHAR(30) NULL, notes VARCHAR(255) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- PURCHASE
CREATE TABLE IF NOT EXISTS purchase_orders(
  id INT AUTO_INCREMENT PRIMARY KEY,
  supplier_id INT NOT NULL, warehouse_id INT NOT NULL,
  po_date DATE NOT NULL, status VARCHAR(20) NOT NULL DEFAULT 'NEW',
  notes VARCHAR(255) NULL, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS purchase_order_items(
  id INT AUTO_INCREMENT PRIMARY KEY,
  po_id INT NOT NULL, product_id INT NOT NULL, qty DECIMAL(12,2) NOT NULL, price DECIMAL(12,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS grn(
  id INT AUTO_INCREMENT PRIMARY KEY,
  po_id INT NOT NULL, supplier_id INT NOT NULL,
  warehouse_id INT NOT NULL, grn_date DATE NOT NULL,
  status VARCHAR(20) NOT NULL DEFAULT 'NEW', created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ap_invoices(
  id INT AUTO_INCREMENT PRIMARY KEY,
  supplier_id INT NOT NULL, invoice_date DATE NOT NULL,
  total DECIMAL(12,2) NOT NULL DEFAULT 0, status VARCHAR(20) NOT NULL DEFAULT 'NEW',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- INVENTORY & COSTING
CREATE TABLE IF NOT EXISTS stock_transactions(
  id INT AUTO_INCREMENT PRIMARY KEY,
  product_id INT NOT NULL, warehouse_id INT NOT NULL,
  type ENUM('IN','OUT','PURCHASE','SHIPMENT','ADJUST') NOT NULL,
  qty DECIMAL(12,3) NOT NULL, lot VARCHAR(60) NULL, expiry DATE NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS cost_layers(
  id INT AUTO_INCREMENT PRIMARY KEY,
  product_id INT NOT NULL, warehouse_id INT NOT NULL,
  lot VARCHAR(60) NULL, expiry DATE NULL,
  qty_remain DECIMAL(12,3) NOT NULL, unit_cost DECIMAL(12,4) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- APPROVALS
CREATE TABLE IF NOT EXISTS approvals(
  id INT AUTO_INCREMENT PRIMARY KEY,
  entity VARCHAR(40) NOT NULL, entity_id INT NOT NULL,
  step TINYINT NOT NULL DEFAULT 1, status ENUM('PENDING','APPROVED','REJECTED') NOT NULL DEFAULT 'PENDING',
  approver_role VARCHAR(40) NOT NULL, comment VARCHAR(255) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- FILES
CREATE TABLE IF NOT EXISTS attachments(
  id INT AUTO_INCREMENT PRIMARY KEY,
  entity VARCHAR(40) NOT NULL, entity_id INT NOT NULL,
  file_name VARCHAR(200) NOT NULL, path VARCHAR(200) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
