<?php
namespace App\Controllers\Admin;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class UsersController extends Controller{
  public function index(){ require_login();
    $rows=db()->query("SELECT u.*, b.name branch FROM users u LEFT JOIN branches b ON b.id=u.branch_id ORDER BY u.id DESC")->fetchAll();
    $roles=db()->query("SELECT * FROM roles ORDER BY id")->fetchAll();
    $this->view('admin/users_index',compact('rows','roles'));
  }
  public function store(){ require_login();
    $hash = password_hash($_POST['password'] ?? 'admin123', PASSWORD_BCRYPT);
    $stm=db()->prepare("INSERT INTO users(username,password_hash,role,branch_id,active) VALUES(?,?,?,?,1)");
    $stm->execute([$_POST['username'],$hash,$_POST['role'],$_POST['branch_id']??null]);
    flash('ok','Foydalanuvchi qo‘shildi'); $this->redirect('admin/users/index');
  }
  public function update(){ require_login();
    $hash = !empty($_POST['password']) ? password_hash($_POST['password'], PASSWORD_BCRYPT) : null;
    if($hash){
      $stm=db()->prepare("UPDATE users SET username=?, password_hash=?, role=?, branch_id=?, active=? WHERE id=?");
      $stm->execute([$_POST['username'],$hash,$_POST['role'],$_POST['branch_id']??null,($_POST['active']??1),$_POST['id']]);
    }else{
      $stm=db()->prepare("UPDATE users SET username=?, role=?, branch_id=?, active=? WHERE id=?");
      $stm->execute([$_POST['username'],$_POST['role'],$_POST['branch_id']??null,($_POST['active']??1),$_POST['id']]);
    }
    flash('ok','Yangilandi'); $this->redirect('admin/users/index');
  }
  public function delete(){ require_login(); db()->prepare("DELETE FROM users WHERE id=?")->execute([$_GET['id']]); flash('ok','O‘chirildi'); $this->redirect('admin/users/index'); }
}
