<?php
namespace App\Controllers\Inventory;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class StockController extends Controller{
  public function index(){ require_login();
    $rows=db()->query("SELECT p.code,p.name,COALESCE(SUM(CASE WHEN t.type IN('IN','PURCHASE') THEN t.qty WHEN t.type IN('OUT','SHIPMENT') THEN -t.qty ELSE 0 END),0) onhand
                       FROM products p LEFT JOIN stock_transactions t ON t.product_id=p.id GROUP BY p.id ORDER BY p.name")->fetchAll();
    $this->view('inventory/stock_index',compact('rows'));
  }
  public function transfer(){ require_login();
    if($_SERVER['REQUEST_METHOD']==='POST'){
      db()->beginTransaction();
      $out=db()->prepare("INSERT INTO stock_transactions(product_id,warehouse_id,type,qty) VALUES(?,?,'OUT',?)");
      $in =db()->prepare("INSERT INTO stock_transactions(product_id,warehouse_id,type,qty) VALUES(?,?,'IN',?)");
      foreach($_POST['items']??[] as $it){ $out->execute([$it['product_id'],$_POST['from_wh'],$it['qty']]); $in->execute([$it['product_id'],$_POST['to_wh'],$it['qty']]); }
      db()->commit(); flash('ok','Transfer bajarildi'); $this->redirect('inventory/stock/index');
    } else {
      $ware=db()->query("SELECT id,code,name FROM warehouses ORDER BY name")->fetchAll();
      $prod=db()->query("SELECT id,code,name FROM products ORDER BY name")->fetchAll();
      $this->view('inventory/transfer',compact('ware','prod'));
    }
  }
}
