<?php
namespace App\Controllers\Purchase;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class GrnController extends Controller{
  public function index(){ require_login();
    $list=db()->query("SELECT g.*, s.name supplier FROM grn g LEFT JOIN suppliers s ON s.id=g.supplier_id ORDER BY g.id DESC")->fetchAll();
    $po=db()->query("SELECT id FROM purchase_orders ORDER BY id DESC")->fetchAll();
    $ware=db()->query("SELECT id,code,name FROM warehouses ORDER BY name")->fetchAll();
    $this->view('purchase/grn_index',compact('list','po','ware'));
  }
  public function store(){ require_login();
    db()->beginTransaction();
    $stm=db()->prepare("INSERT INTO grn(po_id,supplier_id,warehouse_id,grn_date,status) SELECT p.id,p.supplier_id,?,?,'NEW' FROM purchase_orders p WHERE p.id=?");
    $stm->execute([$_POST['warehouse_id'],$_POST['grn_date'],$_POST['po_id']]);
    $grnId=db()->lastInsertId();
    // IN transactions from PO items
    $sel=db()->prepare("SELECT product_id,qty,price FROM purchase_order_items WHERE po_id=?");
    $sel->execute([$_POST['po_id']]);
    $in=db()->prepare("INSERT INTO stock_transactions(product_id,warehouse_id,type,qty) VALUES(?,?,'IN',?)");
    $layer=db()->prepare("INSERT INTO cost_layers(product_id,warehouse_id,lot,expiry,qty_remain,unit_cost) VALUES(?,?,?,?,?,?)");
    foreach($sel->fetchAll() as $r){
      $in->execute([$r['product_id'],$_POST['warehouse_id'],$r['qty']]);
      $layer->execute([$r['product_id'],$_POST['warehouse_id'],$_POST['lot']??null,$_POST['expiry']??null,$r['qty'],$r['price']]);
    }
    db()->commit();
    flash('ok','GRN yaratildi va IN yozildi'); $this->redirect('purchase/grn/index');
  }
}
