<?php
namespace App\Controllers\Sales;
use App\Core\Controller; require_once __DIR__.'/../../../config/bootstrap.php';
class ShipmentsController extends Controller{
  public function index(){ require_login();
    $list=db()->query("SELECT s.*, c.name customer FROM shipments s LEFT JOIN customers c ON c.id=s.customer_id ORDER BY s.id DESC")->fetchAll();
    $orders=db()->query("SELECT id FROM sales_orders ORDER BY id DESC")->fetchAll();
    $ware=db()->query("SELECT id,code,name FROM warehouses ORDER BY name")->fetchAll();
    $this->view('sales/shipments_index',compact('list','orders','ware'));
  }
  public function store(){ require_login();
    db()->beginTransaction();
    $stm=db()->prepare("INSERT INTO shipments(order_id,customer_id,warehouse_id,ship_date,status) SELECT o.id, o.customer_id, ?, ?, 'NEW' FROM sales_orders o WHERE o.id=?");
    $stm->execute([$_POST['warehouse_id'],$_POST['ship_date'],$_POST['order_id']]);
    $shipId=db()->lastInsertId();
    // OUT transactions (qty from order items)
    $sel=db()->prepare("SELECT product_id,qty FROM sales_order_items WHERE order_id=?");
    $sel->execute([$_POST['order_id']]);
    $out=db()->prepare("INSERT INTO stock_transactions(product_id,warehouse_id,type,qty) VALUES(?,?, 'OUT', ?)");
    foreach($sel->fetchAll() as $r){ $out->execute([$r['product_id'],$_POST['warehouse_id'],$r['qty']]); }
    db()->commit();
    flash('ok','Jo‘natma yaratildi va OUT yozildi'); $this->redirect('sales/shipments/index');
  }
}
